package org.infinispan.server.endpoint.subsystem;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;

public class EncryptableSubsystemHelper {

   private EncryptableSubsystemHelper() {
   }

   static void processEncryption(ExpressionResolver context, ModelNode config, EncryptableService service, ServiceBuilder<?> builder) throws OperationFailedException {
      if (config.hasDefined(ModelKeys.ENCRYPTION) && config.get(ModelKeys.ENCRYPTION, ModelKeys.ENCRYPTION_NAME).isDefined()) {
         config = config.get(ModelKeys.ENCRYPTION, ModelKeys.ENCRYPTION_NAME);
         EndpointUtils.addSecurityRealmDependency(
               builder,
               EncryptionResource.SECURITY_REALM.resolveModelAttribute(context, config).asString(),
               service.getEncryptionSecurityRealm()
         );
         service.setClientAuth(EncryptionResource.REQUIRE_SSL_CLIENT_AUTH.resolveModelAttribute(context, config).asBoolean());
      }
   }

}
