/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.core4j.Func1;
import org.odata4j.core.ImmutableMap;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.producer.jdbc.JdbcMetadataMapping;
import org.odata4j.producer.jdbc.JdbcModel;

public class JdbcModelToMetadata
implements Func1<JdbcModel, JdbcMetadataMapping> {
    private static final Map<Integer, EdmType> SIMPLE_TYPE_MAPPING = ImmutableMap.of(4, EdmSimpleType.INT32, 12, EdmSimpleType.STRING, 16, EdmSimpleType.BOOLEAN);

    public String getModelNamespace() {
        return "JdbcModel";
    }

    public String getContainerNamespace(String entityContainerName) {
        return "JdbcEntities." + entityContainerName;
    }

    public String getEntityContainerName(String schemaName) {
        return this.rename(schemaName);
    }

    public String getEntityTypeName(String tableName) {
        return this.rename(tableName);
    }

    public String getEntitySetName(String tableName) {
        return this.rename(tableName);
    }

    public String getPropertyName(String columnName) {
        return this.rename(columnName);
    }

    public String rename(String dbName) {
        return dbName;
    }

    public EdmType getEdmType(int jdbcType, String columnTypeName, Integer columnSize) {
        if (!SIMPLE_TYPE_MAPPING.containsKey(jdbcType)) {
            throw new UnsupportedOperationException("TODO implement edmtype conversion for jdbc type: " + jdbcType);
        }
        return SIMPLE_TYPE_MAPPING.get(jdbcType);
    }

    public JdbcMetadataMapping apply(JdbcModel jdbcModel) {
        String modelNamespace = this.getModelNamespace();
        ArrayList<EdmEntityType.Builder> entityTypes = new ArrayList<EdmEntityType.Builder>();
        ArrayList<EdmEntityContainer.Builder> entityContainers = new ArrayList<EdmEntityContainer.Builder>();
        ArrayList<EdmEntitySet.Builder> entitySets = new ArrayList<EdmEntitySet.Builder>();
        HashMap<EdmEntitySet.Builder, JdbcModel.JdbcTable> entitySetMapping = new HashMap<EdmEntitySet.Builder, JdbcModel.JdbcTable>();
        HashMap<EdmProperty.Builder, JdbcModel.JdbcColumn> propertyMapping = new HashMap<EdmProperty.Builder, JdbcModel.JdbcColumn>();
        for (JdbcModel.JdbcSchema jdbcSchema : jdbcModel.schemas) {
            for (JdbcModel.JdbcTable jdbcTable : jdbcSchema.tables) {
                String propertyName;
                if (jdbcTable.primaryKeys.isEmpty()) {
                    System.err.println("Skipping JdbcTable " + jdbcTable.tableName + ", no keys");
                    continue;
                }
                String entityTypeName = this.getEntityTypeName(jdbcTable.tableName);
                EdmEntityType.Builder entityType = (EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setName(entityTypeName)).setNamespace(modelNamespace);
                entityTypes.add(entityType);
                for (JdbcModel.JdbcPrimaryKey primaryKey : jdbcTable.primaryKeys) {
                    propertyName = this.getPropertyName(primaryKey.columnName);
                    entityType.addKeys(propertyName);
                }
                for (JdbcModel.JdbcColumn jdbcColumn : jdbcTable.columns) {
                    propertyName = this.getPropertyName(jdbcColumn.columnName);
                    EdmType propertyType = this.getEdmType(jdbcColumn.columnType, jdbcColumn.columnTypeName, jdbcColumn.columnSize);
                    EdmProperty.Builder property = EdmProperty.newBuilder(propertyName).setType(propertyType).setNullable(jdbcColumn.isNullable);
                    entityType.addProperties(property);
                    propertyMapping.put(property, jdbcColumn);
                }
                String entitySetName = this.getEntitySetName(jdbcTable.tableName);
                EdmEntitySet.Builder entitySet = EdmEntitySet.newBuilder().setName(entitySetName).setEntityType(entityType);
                entitySets.add(entitySet);
                entitySetMapping.put(entitySet, jdbcTable);
            }
            String entityContainerName = this.getEntityContainerName(jdbcSchema.schemaName);
            EdmEntityContainer.Builder entityContainer = EdmEntityContainer.newBuilder().setName(entityContainerName).setIsDefault(jdbcSchema.isDefault).addEntitySets(entitySets);
            entityContainers.add(entityContainer);
        }
        ArrayList<EdmSchema.Builder> edmSchemas = new ArrayList<EdmSchema.Builder>();
        EdmSchema.Builder modelSchema = EdmSchema.newBuilder().setNamespace(modelNamespace).addEntityTypes(entityTypes);
        edmSchemas.add(modelSchema);
        for (EdmEntityContainer.Builder entityContainer : entityContainers) {
            String containerSchemaNamespace = this.getContainerNamespace(entityContainer.getName());
            EdmSchema.Builder containerSchema = EdmSchema.newBuilder().setNamespace(containerSchemaNamespace).addEntityContainers(entityContainer);
            edmSchemas.add(containerSchema);
        }
        EdmDataServices metadata = EdmDataServices.newBuilder().addSchemas(edmSchemas).build();
        HashMap<EdmEntitySet, JdbcModel.JdbcTable> finalEntitySetMapping = new HashMap<EdmEntitySet, JdbcModel.JdbcTable>();
        for (Map.Entry entry : entitySetMapping.entrySet()) {
            finalEntitySetMapping.put(((EdmEntitySet.Builder)entry.getKey()).build(), (JdbcModel.JdbcTable)entry.getValue());
        }
        HashMap<EdmProperty, JdbcModel.JdbcColumn> finalPropertyMapping = new HashMap<EdmProperty, JdbcModel.JdbcColumn>();
        for (Map.Entry entry : propertyMapping.entrySet()) {
            finalPropertyMapping.put(((EdmProperty.Builder)entry.getKey()).build(), (JdbcModel.JdbcColumn)entry.getValue());
        }
        return new JdbcMetadataMapping(metadata, jdbcModel, finalEntitySetMapping, finalPropertyMapping);
    }
}

