package com.redhat.installer.action;

import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.password.UsernamePasswordHashUtil;

/**
 * @author Jyoti Tripathi
 */
public class PasswordHelper implements PanelAction  {

    /**
     * @param handler Note, as per spec., if there isn't a GUI, handler is null
     */
    public void executeAction(final AutomatedInstallData idata, AbstractUIHandler handler)  {
        try {
        	String user = idata.getVariable("adminUser");
			String pwd = idata.getVariable("adminPassword");
			if (user != null && pwd != null) {
				String hash = new UsernamePasswordHashUtil().generateHashedHexURP(user, "ManagementRealm", pwd.toCharArray());
				idata.setVariable("adminPasswordHash", hash);
			}
        } catch (Exception e) {
        	e.printStackTrace();
            /**
             * The exception thrown here stems from a blank and therefore null 
             * password field.
             * 
             * This exception can be safely ignored since a blank password doesn't
             * pass validation, and the user is given the corresponding msg. 
             */
        }
    }

    /**
     * There shouldn't be any need for configuration, since this is a dedicated class
     * @param configuration null if no configuration block for the action
     */
    public void initialize(PanelActionConfiguration configuration) {
    }
}
