package com.redhat.installer.postinstall;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.util.ValidatorConstants;

/**
 * Class that creates backups of files that will be modified by the installation, so that 
 * the cleanup() method in RollbackInstallListener is able to restore them if needed.
 * @author thauser
 *
 */
public class BackupCreator {

	
	public static void run(AbstractUIProcessHandler handler, String[]args) throws Exception{
		// create backups of all the files that may be modified by postinstall, or by 
		// the particular product. may require specific modifications for specific products.
		ArrayList<File> toBackup = new ArrayList<File>();
		AutomatedInstallData idata = AutomatedInstallData.getInstance();
		
		String installPath = idata.getVariable("INSTALL_PATH")+File.separator+idata.getVariable("INSTALL_SUBPATH");
		
		for (String file : ValidatorConstants.filesToBackup){
			toBackup.add(new File(installPath + file));
		}
		
		//TODO: perhaps factor this out. duplicated a few places
		for (File original : toBackup){
			if (original.exists()) {
				File backup = new File(original.getPath() + ValidatorConstants.backupExt);
				InputStream in = new FileInputStream(original);
				OutputStream out = new FileOutputStream(backup);
				System.out.println(idata.langpack.getString("BackupCreator.backup") + " " + original.getPath() + " " + 
									idata.langpack.getString("BackupCreator.to") + ": " + backup.getPath());
				byte[] buffer = new byte[1024];
				int l;
				while ((l = in.read(buffer, 0, 1024)) > 0) {
					out.write(buffer, 0, l);
				}

				in.close();
				out.close();
			}
		}
		
		// done
	}
}
