package com.redhat.installer.validator;

import java.util.regex.Pattern;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

public class DirectoryValidator  implements Validator, DataValidator {
	AutomatedInstallData idata;
	String error;
	public boolean validate(ProcessingClient client) //Validator for UserInputSpec
	{
		idata = AutomatedInstallData.getInstance();
		int numFields = client.getNumFields();
		
        for (int i = 0; i < numFields; i++)
        {
            if (!checkDirectory(client.getFieldContents(i)))
    		{
            	return false;
    		}
        } 
        return true;
	}

	public Status validateData(AutomatedInstallData idata) //Validator for target panel
	{
		String path = idata.getVariable("INSTALL_PATH");
		if (!checkDirectory(path))
		{
			setError(idata.langpack.getString("TargetPanel.invalid"));
			return Status.ERROR;
		}
		return Status.OK;
	}
	
	private boolean checkDirectory(String path)
	{
        String pathValidator = "[^\\[\\];,|:]+";
        String windowPathValidator = "[a-zA-Z]:[^\\[\\];,|:\\/\\*\\?<>]*[^ ]";
        
        if(System.getProperty("os.name").toLowerCase().contains("window"))
        {
            pathValidator = windowPathValidator;
        }
        
        if (!Pattern.matches(pathValidator, path) || path.contains("\\0")
        		|| path.contains("  ") || path.contains(" \\"))
        {
            return false;
        }
        return true;
	}
	
	public void setError(String e)
	{
		this.error= e;
	}
	public String getErrorMessageId() {
		// TODO Auto-generated method stub
		return error;
	}

	public String getWarningMessageId() {
		// TODO Auto-generated method stub
		return error;
	}

	public boolean getDefaultAnswer() {
		// TODO Auto-generated method stub
		return false;
	}
}
