/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.sequencer.ddl.DdlConstants;

public interface TeiidDdlConstants
extends DdlConstants {
    public static final String GLOBAL = "GLOBAL";
    public static final String TEMPORARY = "TEMPORARY";

    public static enum SchemaElementType implements DdlElement
    {
        FOREIGN,
        VIRTUAL;


        @Override
        public String toDdl() {
            return this.toString();
        }
    }

    public static enum TeiidReservedWord implements DdlElement
    {
        ADD,
        ALL,
        ALLOCATE,
        ALTER,
        AND,
        ANY,
        ARRAY_AGG,
        AS,
        ASC,
        ATOMIC,
        BEGIN,
        BETWEEN,
        BOTH,
        BREAK,
        BY,
        CALL,
        CASE,
        COLUMN,
        CONSTRAINT,
        CONTINUE,
        CREATE,
        CROSS,
        DAY,
        DECLARE,
        DEFAULT,
        DELETE,
        DESC,
        DISTINCT,
        DROP,
        EACH,
        ELSE,
        END,
        ERROR,
        ESCAPE,
        EXCEPT,
        EXEC,
        EXECUTE,
        EXISTS,
        FALSE,
        FETCH,
        FILTER,
        FOR,
        FOREIGN,
        FROM,
        FULL,
        FUNCTION,
        GROUP,
        HAVING,
        HOUR,
        IF,
        IMMEDIATE,
        IN,
        INNER,
        INOUT,
        INSERT,
        INTERSECT,
        INTO,
        IS,
        JOIN,
        LANGUAGE,
        LATERAL,
        LEADING,
        LEAVE,
        LEFT,
        LIKE,
        LIKE_REGEX,
        LIMIT,
        LOCAL,
        LOOP,
        MAKEDEP,
        MAKENOTDEP,
        MERGE,
        MINUTE,
        MONTH,
        NO,
        NOCACHE,
        NOT,
        NULL,
        OF,
        OFFSET,
        ON,
        ONLY,
        OPTION,
        OPTIONS,
        OR,
        ORDER,
        OUT,
        OUTER,
        OVER,
        PARAMETER,
        PARTITION,
        PREPARE,
        PRIMARY,
        PROCEDURE,
        REFERENCES,
        RETURN,
        RETURNS,
        RIGHT,
        ROLLUP,
        ROW,
        ROWS,
        SECOND,
        SELECT,
        SET,
        SIMILAR,
        SOME,
        SQLEXCEPTION,
        SQLSTATE,
        SQLWARNING,
        TABLE,
        TEMPORARY,
        THEN,
        TO,
        TRAILING,
        TRANSLATE,
        TRIGGER,
        TRUE,
        UNION,
        UNIQUE,
        UNKNOWN,
        UPDATE,
        USER,
        USING,
        VALUES,
        VIRTUAL,
        WHEN,
        WHERE,
        WHILE,
        WITH,
        WITHOUT,
        XMLAGG,
        XMLATTRIBUTES,
        XMLCOMMENT,
        XMLCONCAT,
        XMLELEMENT,
        XMLFOREST,
        XMLNAMESPACES,
        XMLPARSE,
        XMLPI,
        XMLQUERY,
        XMLSERIALIZE,
        XMLTABLE,
        YEAR;

        private static List<String> _list;

        public static List<String> asList() {
            if (_list == null) {
                TeiidReservedWord[] values = TeiidReservedWord.values();
                _list = new ArrayList<String>(values.length);
                for (TeiidReservedWord word : values) {
                    _list.add(word.name());
                }
            }
            return _list;
        }

        @Override
        public String toDdl() {
            return this.toString();
        }
    }

    public static enum TeiidNonReservedWord implements DdlElement
    {
        ACCESSPATTERN,
        ARRAYTABLE,
        AUTO_INCREMENT,
        AVG,
        CHAIN,
        COLUMNS,
        CONTENT,
        COUNT,
        DELIMITER,
        DENSE_RANK,
        DISABLED,
        DOCUMENT,
        EMPTY,
        ENABLED,
        ENCODING,
        EVERY,
        EXCEPTION,
        EXCLUDING,
        EXTRACT,
        FIRST,
        HEADER,
        INCLUDING,
        INDEX,
        INSTEAD,
        JSONARRAY_AGG,
        JSONOBJECT,
        KEY,
        LAST,
        MAX,
        MIN,
        NAME,
        NAMESPACE,
        NEXT,
        NULLS,
        OBJECTTABLE,
        ORDINALITY,
        PASSING,
        PATH,
        PRESERVE,
        QUERYSTRING,
        QUOTE,
        RAISE,
        RANK,
        RESULT,
        ROW_NUMBER,
        SELECTOR,
        SERIAL,
        SKIP,
        SQL_TSI_DAY,
        SQL_TSI_FRAC_SECOND,
        SQL_TSI_HOUR,
        SQL_TSI_MINUTE,
        SQL_TSI_MONTH,
        SQL_TSI_QUARTER,
        SQL_TSI_SECOND,
        SQL_TSI_WEEK,
        SQL_TSI_YEAR,
        STDDEV_POP,
        STDDEV_SAMP,
        SUBSTRING,
        SUM,
        TEXTAGG,
        TEXTTABLE,
        TIMESTAMPADD,
        TIMESTAMPDIFF,
        TO_BYTES,
        TO_CHARS,
        TRIM,
        VAR_POP,
        VAR_SAMP,
        VARIADIC,
        VERSION,
        VIEW,
        WELLFORMED,
        WIDTH,
        XMLDECLARATION;

        private static List<String> _list;

        public static List<String> asList() {
            if (_list == null) {
                TeiidNonReservedWord[] values = TeiidNonReservedWord.values();
                _list = new ArrayList<String>(values.length);
                for (TeiidNonReservedWord word : values) {
                    _list.add(word.name());
                }
            }
            return _list;
        }

        @Override
        public String toDdl() {
            return this.toString();
        }
    }

    public static enum TeiidFutureReserveWord {
        ALLOCATE,
        ARE,
        ARRAY,
        ASENSITIVE,
        ASYMETRIC,
        AUTHORIZATION,
        BINARY,
        CALLED,
        CASCADED,
        CHARACTER,
        CHECK,
        CLOSE,
        COLLATE,
        COMMIT,
        CONNECT,
        CORRESPONDING,
        CRITERIA,
        CURRENT_DATE,
        CURRENT_TIME,
        CURRENT_TIMESTAMP,
        CURRENT_USER,
        CURSOR,
        CYCLE,
        DATALINK,
        DEALLOCATE,
        DEC,
        DEREF,
        DESCRIBE,
        DETERMINISTIC,
        DISCONNECT,
        DLNEWCOPY,
        DLPREVIOUSCOPY,
        DLURLCOMPLETE,
        DLURLCOMPLETEONLY,
        DLURLCOMPLETEWRITE,
        DLURLPATH,
        DLURLPATHONLY,
        DLURLPATHWRITE,
        DLURLSCHEME,
        DLURLSERVER,
        DLVALUE,
        DYNAMIC,
        ELEMENT,
        EXTERNAL,
        FREE,
        GET,
        GLOBAL,
        GRANT,
        HAS,
        HOLD,
        IDENTITY,
        IMPORT,
        INDICATOR,
        INPUT,
        INSENSITIVE,
        INT,
        INTERVAL,
        ISOLATION,
        LARGE,
        LOCALTIME,
        LOCALTIMESTAMP,
        MATCH,
        MEMBER,
        METHOD,
        MODIFIES,
        MODULE,
        MULTISET,
        NATIONAL,
        NATURAL,
        NCHAR,
        NCLOB,
        NEW,
        NONE,
        NUMERIC,
        OLD,
        OPEN,
        OUTPUT,
        OVERLAPS,
        PRECISION,
        PREPARE,
        RANGE,
        READS,
        RECURSIVE,
        REFERENCING,
        RELEASE,
        REVOKE,
        ROLLBACK,
        ROLLUP,
        SAVEPOINT,
        SCROLL,
        SEARCH,
        SENSITIVE,
        SESSION_USER,
        SPECIFIC,
        SPECIFICTYPE,
        SQL,
        START,
        STATIC,
        SUBMULTILIST,
        SYMETRIC,
        SYSTEM,
        SYSTEM_USER,
        TIMEZONE_HOUR,
        TIMEZONE_MINUTE,
        TRANSLATION,
        TREAT,
        VALUE,
        VARYING,
        WHENEVER,
        WINDOW,
        WITHIN,
        XMLBINARY,
        XMLCAST,
        XMLDOCUMENT,
        XMLEXISTS,
        XMLITERATE,
        XMLTEXT,
        XMLVALIDATE;

    }

    public static enum TeiidDataType implements DdlElement
    {
        BIGDECIMAL,
        BIGINT,
        BIGINTEGER,
        BLOB,
        BOOLEAN,
        BYTE,
        CHAR,
        CLOB,
        DATE,
        DECIMAL,
        DOUBLE,
        FLOAT,
        GEOMETRY,
        INTEGER,
        LONG,
        OBJECT,
        REAL,
        SHORT,
        SMALLINT,
        STRING,
        TIME,
        TIMESTAMP,
        TINYINT,
        VARBINARY,
        VARCHAR,
        XML;

        private static List<String> _startWords;

        public static List<String> getStartWords() {
            if (_startWords == null) {
                TeiidDataType[] values = TeiidDataType.values();
                _startWords = new ArrayList<String>(values.length);
                for (TeiidDataType type : values) {
                    _startWords.add(type.toDdl());
                }
            }
            return _startWords;
        }

        @Override
        public String toDdl() {
            return this.toString();
        }
    }

    public static enum DdlStatement implements DdlElement
    {
        CREATE_FOREIGN_TABLE("CREATE", "FOREIGN", "TABLE"),
        CREATE_GLOBAL_TEMPORARY_TABLE("CREATE", "GLOBAL", "TEMPORARY", "TABLE"),
        CREATE_VIRTUAL_VIEW("CREATE", TeiidReservedWord.VIRTUAL.name(), "VIEW"),
        CREATE_VIEW("CREATE", "VIEW"),
        CREATE_FOREIGN_TEMPORARY_TABLE("CREATE", "FOREIGN", "TEMPORARY", "TABLE"),
        CREATE_LOCAL_FOREIGN_TEMPORARY_TABLE("CREATE", TeiidReservedWord.LOCAL.name(), "FOREIGN", "TEMPORARY", "TABLE"),
        CREATE_LOCAL_TEMPORARY_TABLE("CREATE", TeiidReservedWord.LOCAL.name(), "TEMPORARY", "TABLE"),
        CREATE_TEMPORARY_TABLE("CREATE", "TEMPORARY", "TABLE"),
        CREATE_VIRTUAL_FUNCTION("CREATE", TeiidReservedWord.VIRTUAL.name(), TeiidReservedWord.FUNCTION.name()),
        CREATE_VIRTUAL_PROCEDURE("CREATE", TeiidReservedWord.VIRTUAL.name(), TeiidReservedWord.PROCEDURE.name()),
        CREATE_FOREIGN_FUNCTION("CREATE", "FOREIGN", TeiidReservedWord.FUNCTION.name()),
        CREATE_FOREIGN_PROCEDURE("CREATE", "FOREIGN", TeiidReservedWord.PROCEDURE.name()),
        CREATE_FUNCTION("CREATE", TeiidReservedWord.FUNCTION.name()),
        CREATE_PROCEDURE("CREATE", TeiidReservedWord.PROCEDURE.name()),
        OPTION_NAMESPACE("SET", TeiidNonReservedWord.NAMESPACE.name()),
        ALTER_VIRTUAL_PROCEDURE("ALTER", TeiidReservedWord.VIRTUAL.name(), TeiidReservedWord.PROCEDURE.name()),
        ALTER_VIRTUAL_TABLE("ALTER", TeiidReservedWord.VIRTUAL.name(), "TABLE"),
        ALTER_VIRTUAL_VIEW("ALTER", TeiidReservedWord.VIRTUAL.name(), "VIEW"),
        ALTER_FOREIGN_PROCEDURE("ALTER", "FOREIGN", TeiidReservedWord.PROCEDURE.name()),
        ALTER_FOREIGN_TABLE("ALTER", "FOREIGN", "TABLE"),
        ALTER_FOREIGN_VIEW("ALTER", "FOREIGN", "VIEW"),
        ALTER_PROCEDURE("ALTER", TeiidReservedWord.PROCEDURE.name()),
        ALTER_TABLE("ALTER", "TABLE"),
        ALTER_VIEW("ALTER", "VIEW"),
        CREATE_TRIGGER("CREATE", TeiidReservedWord.TRIGGER.name(), "ON");

        private final String[] tokens;

        private DdlStatement(String ... tokens) {
            this.tokens = tokens;
        }

        @Override
        public String toDdl() {
            boolean firstTime = true;
            StringBuilder ddl = new StringBuilder();
            for (String token : this.tokens) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    ddl.append(' ');
                }
                ddl.append(token);
            }
            return ddl.toString();
        }

        public String[] tokens() {
            return this.tokens;
        }
    }

    public static interface DdlElement {
        public String toDdl();
    }
}

