/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionIterator;
import org.infinispan.schematic.SchematicEntry;
import org.modeshape.common.collection.LinkedListMultimap;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.AccessControlManagerImpl;
import org.modeshape.jcr.Connectors;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrDocumentViewExporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.JcrSharedNodeCache;
import org.modeshape.jcr.JcrSystemNode;
import org.modeshape.jcr.JcrSystemViewExporter;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.ModeShapePermissions;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.SequencingRunner;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentAlreadyExistsException;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.ReferentialIntegrityException;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionCacheWrapper;
import org.modeshape.jcr.cache.SiblingCounter;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.WrappedException;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.security.AdvancedAuthorizationProvider;
import org.modeshape.jcr.security.AuthorizationProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.UuidFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.LocalNamespaceRegistry;
import org.modeshape.jcr.value.basic.NodeIdentifierReferenceFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JcrSession
implements Session {
    private static final String[] NO_ATTRIBUTES_NAMES = new String[0];
    protected final JcrRepository repository;
    private final SessionCache cache;
    private final JcrRootNode rootNode;
    private final ConcurrentMap<NodeKey, AbstractJcrNode> jcrNodes = new ConcurrentHashMap<NodeKey, AbstractJcrNode>();
    private final Map<String, Object> sessionAttributes;
    private final JcrWorkspace workspace;
    private final JcrNamespaceRegistry sessionRegistry;
    private final AtomicReference<Map<NodeKey, NodeKey>> baseVersionKeys = new AtomicReference();
    private final AtomicReference<Map<NodeKey, NodeKey>> originalVersionKeys = new AtomicReference();
    private final AtomicReference<JcrSharedNodeCache> shareableNodeCache = new AtomicReference();
    private final AtomicLong aclChangesCount = new AtomicLong(0L);
    private volatile JcrValueFactory valueFactory;
    private volatile boolean isLive = true;
    private final long nanosCreated;
    private ExecutionContext context;
    private final AccessControlManagerImpl acm;
    private final AdvancedAuthorizationProvider.Context authorizerContext = new AdvancedAuthorizationProvider.Context(){

        @Override
        public ExecutionContext getExecutionContext() {
            return JcrSession.this.context();
        }

        @Override
        public String getRepositoryName() {
            return JcrSession.this.repository().getName();
        }

        @Override
        public javax.jcr.Session getSession() {
            return JcrSession.this;
        }

        @Override
        public String getWorkspaceName() {
            return JcrSession.this.workspaceName();
        }
    };

    protected JcrSession(JcrRepository repository, String workspaceName, ExecutionContext context, Map<String, Object> sessionAttributes, boolean readOnly) {
        this.repository = repository;
        RepositoryCache repositoryCache = repository.repositoryCache();
        WorkspaceCache workspace = repositoryCache.getWorkspaceCache(workspaceName);
        NodeKey rootKey = workspace.getRootKey();
        TextDecoder decoder = context.getDecoder();
        ValueFactories factories = context.getValueFactories();
        NodeIdentifierReferenceFactory rootKeyAwareStrongRefFactory = NodeIdentifierReferenceFactory.newInstance(rootKey, decoder, factories, false, false);
        NodeIdentifierReferenceFactory rootKeyAwareWeakRefFactory = NodeIdentifierReferenceFactory.newInstance(rootKey, decoder, factories, true, false);
        NodeIdentifierReferenceFactory rootKeyAwareSimpleRefFactory = NodeIdentifierReferenceFactory.newInstance(rootKey, decoder, factories, true, true);
        context = context.with(rootKeyAwareStrongRefFactory).with(rootKeyAwareWeakRefFactory).with(rootKeyAwareSimpleRefFactory);
        NamespaceRegistry globalNamespaceRegistry = context.getNamespaceRegistry();
        LocalNamespaceRegistry localRegistry = new LocalNamespaceRegistry(globalNamespaceRegistry);
        this.context = context.with(localRegistry);
        this.sessionRegistry = new JcrNamespaceRegistry(JcrNamespaceRegistry.Behavior.SESSION, localRegistry, globalNamespaceRegistry, this);
        this.workspace = new JcrWorkspace(this, workspaceName);
        this.cache = repositoryCache.createSession(this.context, workspaceName, readOnly);
        this.rootNode = new JcrRootNode(this, this.cache.getRootKey());
        this.jcrNodes.put(this.rootNode.key(), this.rootNode);
        this.sessionAttributes = sessionAttributes != null ? sessionAttributes : Collections.emptyMap();
        localRegistry.getNamespaces();
        this.nanosCreated = System.nanoTime();
        repository.statistics().increment(ValueMetric.SESSION_COUNT);
        this.acm = new AccessControlManagerImpl(this);
    }

    protected JcrSession(JcrSession original, boolean readOnly) {
        this.repository = original.repository;
        this.context = original.context;
        this.sessionRegistry = original.sessionRegistry;
        this.valueFactory = original.valueFactory;
        this.sessionAttributes = original.sessionAttributes;
        this.workspace = original.workspace;
        this.cache = this.repository.repositoryCache().createSession(this.context, this.workspace.getName(), readOnly);
        this.rootNode = new JcrRootNode(this, this.cache.getRootKey());
        this.jcrNodes.put(this.rootNode.key(), this.rootNode);
        this.nanosCreated = System.nanoTime();
        this.repository.statistics().increment(ValueMetric.SESSION_COUNT);
        this.acm = new AccessControlManagerImpl(this);
    }

    final JcrWorkspace workspace() {
        return this.workspace;
    }

    final JcrRepository repository() {
        return this.repository;
    }

    void terminate(boolean removeFromActiveSession) {
        if (!this.isLive()) {
            return;
        }
        this.isLive = false;
        this.observationManager().removeAllEventListeners();
        this.cleanLocks();
        if (removeFromActiveSession) {
            this.repository.runningState().removeSession(this);
        }
        this.context.getSecurityContext().logout();
    }

    private void cleanLocks() {
        try {
            this.lockManager().cleanLocks();
        }
        catch (RepositoryException e) {
            Logger.getLogger(this.getClass()).error((Throwable)e, (I18nResource)JcrI18n.unexpectedException, new Object[]{e.getMessage()});
        }
    }

    protected SchematicEntry entryForNode(NodeKey nodeKey) throws RepositoryException {
        SchematicEntry entry = this.repository.documentStore().get(nodeKey.toString());
        if (entry == null) {
            throw new PathNotFoundException(nodeKey.toString());
        }
        return entry;
    }

    final String workspaceName() {
        return this.workspace.getName();
    }

    final String sessionId() {
        return this.context.getId();
    }

    public final boolean isReadOnly() {
        return this.cache().isReadOnly();
    }

    final void checkLive() throws RepositoryException {
        if (!this.isLive()) {
            throw new RepositoryException(JcrI18n.sessionIsNotActive.text(new Object[]{this.sessionId()}));
        }
    }

    NamespaceRegistry namespaces() {
        return this.context.getNamespaceRegistry();
    }

    final StringFactory stringFactory() {
        return this.context.getValueFactories().getStringFactory();
    }

    final NameFactory nameFactory() {
        return this.context.getValueFactories().getNameFactory();
    }

    final PathFactory pathFactory() {
        return this.context.getValueFactories().getPathFactory();
    }

    final PropertyFactory propertyFactory() {
        return this.context.getPropertyFactory();
    }

    final ReferenceFactory referenceFactory() {
        return this.context.getValueFactories().getReferenceFactory();
    }

    final UuidFactory uuidFactory() {
        return this.context.getValueFactories().getUuidFactory();
    }

    final DateTimeFactory dateFactory() {
        return this.context.getValueFactories().getDateFactory();
    }

    final ExecutionContext context() {
        return this.context;
    }

    final JcrValueFactory valueFactory() {
        if (this.valueFactory == null) {
            this.valueFactory = new JcrValueFactory(this.context);
        }
        return this.valueFactory;
    }

    final SessionCache cache() {
        return this.cache;
    }

    final SessionCache createSystemCache(boolean readOnly) {
        SessionCache systemCache = this.repository.createSystemSession(this.context, readOnly);
        return readOnly ? systemCache : new SystemSessionCache(systemCache);
    }

    final JcrNodeTypeManager nodeTypeManager() {
        return this.workspace.nodeTypeManager();
    }

    final NodeTypes nodeTypes() {
        return this.repository().nodeTypeManager().getNodeTypes();
    }

    final JcrVersionManager versionManager() {
        return this.workspace.versionManager();
    }

    final JcrLockManager lockManager() {
        return this.workspace().lockManager();
    }

    final JcrObservationManager observationManager() {
        return this.workspace().observationManager();
    }

    final void signalNamespaceChanges(boolean global) {
        this.nodeTypeManager().signalNamespaceChanges();
        if (global) {
            this.repository.nodeTypeManager().signalNamespaceChanges();
        }
    }

    final void setDesiredBaseVersionKey(NodeKey nodeKey, NodeKey baseVersionKey) {
        this.baseVersionKeys.get().put(nodeKey, baseVersionKey);
    }

    final void setOriginalVersionKey(NodeKey nodeKey, NodeKey originalVersionKey) {
        this.originalVersionKeys.get().put(nodeKey, originalVersionKey);
    }

    final JcrSession spawnSession(boolean readOnly) {
        return new JcrSession(this, readOnly);
    }

    final JcrSession spawnSession(String workspaceName, boolean readOnly) {
        return new JcrSession(this.repository(), workspaceName, this.context(), this.sessionAttributes, readOnly);
    }

    final SessionCache spawnSessionCache(boolean readOnly) {
        SessionCache cache = this.repository().repositoryCache().createSession(this.context(), this.workspaceName(), readOnly);
        return readOnly ? cache : new SystemSessionCache(cache);
    }

    final void addContextData(String key, String value) {
        this.context = this.context.with(key, value);
        this.cache.addContextData(key, value);
    }

    final JcrSharedNodeCache shareableNodeCache() {
        JcrSharedNodeCache result = this.shareableNodeCache.get();
        if (result == null) {
            this.shareableNodeCache.compareAndSet(null, new JcrSharedNodeCache(this));
            result = this.shareableNodeCache.get();
        }
        return result;
    }

    protected final String readableLocation(CachedNode node) {
        try {
            return (String)this.stringFactory().create(node.getPath(this.cache));
        }
        catch (Throwable t) {
            return node.getKey().toString();
        }
    }

    protected final long aclChangesCount() {
        return this.aclChangesCount.longValue();
    }

    protected final long aclAdded(long count) {
        return this.aclChangesCount.addAndGet(count);
    }

    protected final long aclRemoved(long count) {
        return this.aclChangesCount.addAndGet(-count);
    }

    protected final String readable(Path path) {
        return (String)this.stringFactory().create(path);
    }

    protected void releaseCachedNode(AbstractJcrNode node) {
        this.jcrNodes.remove(node.key(), node);
    }

    AbstractJcrNode node(NodeKey nodeKey, AbstractJcrNode.Type expectedType) throws ItemNotFoundException {
        return this.node(nodeKey, expectedType, null);
    }

    AbstractJcrNode node(NodeKey nodeKey, AbstractJcrNode.Type expectedType, NodeKey parentKey) throws ItemNotFoundException {
        CachedNode cachedNode = this.cache.getNode(nodeKey);
        if (cachedNode == null) {
            throw new ItemNotFoundException(nodeKey.toString());
        }
        AbstractJcrNode node = (AbstractJcrNode)this.jcrNodes.get(nodeKey);
        if (node == null) {
            node = this.node(cachedNode, expectedType, parentKey);
        } else if (parentKey != null) {
            node = this.node(cachedNode, expectedType, parentKey);
        }
        return node;
    }

    AbstractJcrNode node(CachedNode cachedNode, AbstractJcrNode.Type expectedType) {
        return this.node(cachedNode, expectedType, null);
    }

    AbstractJcrNode node(CachedNode cachedNode, AbstractJcrNode.Type expectedType, NodeKey parentKey) {
        assert (cachedNode != null);
        NodeKey nodeKey = cachedNode.getKey();
        AbstractJcrNode node = (AbstractJcrNode)this.jcrNodes.get(nodeKey);
        boolean mightBeShared = true;
        if (node == null) {
            Name primaryType;
            if (expectedType == null && (expectedType = AbstractJcrNode.Type.typeForPrimaryType(primaryType = cachedNode.getPrimaryType(this.cache))) == null) {
                expectedType = this.repository().systemWorkspaceKey().equals(nodeKey.getWorkspaceKey()) ? AbstractJcrNode.Type.SYSTEM : AbstractJcrNode.Type.NODE;
                assert (expectedType != null);
            }
            switch (expectedType) {
                case NODE: {
                    node = new JcrNode(this, nodeKey);
                    break;
                }
                case VERSION: {
                    node = new JcrVersionNode(this, nodeKey);
                    mightBeShared = false;
                    break;
                }
                case VERSION_HISTORY: {
                    node = new JcrVersionHistoryNode(this, nodeKey);
                    mightBeShared = false;
                    break;
                }
                case SYSTEM: {
                    node = new JcrSystemNode(this, nodeKey);
                    mightBeShared = false;
                    break;
                }
                case ROOT: {
                    try {
                        return this.getRootNode();
                    }
                    catch (RepositoryException e) {
                        assert (false) : "Should never happen: " + e.getMessage();
                        break;
                    }
                }
            }
            assert (node != null);
            AbstractJcrNode newNode = this.jcrNodes.putIfAbsent(nodeKey, node);
            if (newNode != null) {
                node = newNode;
            }
        }
        if (mightBeShared && parentKey != null && cachedNode.getMixinTypes(this.cache).contains(JcrMixLexicon.SHAREABLE)) {
            node = node.sharedSet().getSharedNode(cachedNode, parentKey);
        }
        return node;
    }

    final CachedNode cachedNode(Path absolutePath) throws PathNotFoundException, RepositoryException {
        return this.cachedNode(this.cache, this.getRootNode().node(), absolutePath, "read");
    }

    final CachedNode cachedNode(SessionCache cache, CachedNode node, Path path, String ... actions) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        Path absPath;
        for (Path.Segment segment : path) {
            if (segment.isSelfReference()) continue;
            if (segment.isParentReference()) {
                node = cache.getNode(node.getParentKey(cache));
                continue;
            }
            ChildReference ref = node.getChildReferences(cache).getChild(segment);
            if (ref == null) {
                throw new PathNotFoundException(JcrI18n.nodeNotFound.text(new Object[]{this.stringFactory().create(path), this.workspaceName()}));
            }
            CachedNode child = cache.getNode(ref);
            assert (child != null) : "Found a child reference in " + node.getPath(cache) + " to a non-existant child " + segment;
            node = child;
        }
        Path path2 = absPath = path.isAbsolute() ? path : null;
        if (absPath == null) {
            try {
                this.checkPermission(node, cache, actions);
            }
            catch (NodeNotFoundException e) {
                throw new PathNotFoundException(JcrI18n.nodeNotFound.text(new Object[]{this.stringFactory().create(path), this.workspaceName()}));
            }
        }
        return node;
    }

    final MutableCachedNode mutableNode(SessionCache cache, CachedNode node, Path path, String ... actions) throws PathNotFoundException, RepositoryException {
        return cache.mutable(this.cachedNode(cache, node, path, actions).getKey());
    }

    final AbstractJcrNode node(CachedNode node, Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        AbstractJcrNode atOrBelow;
        CachedNode child = this.cachedNode(this.cache, node, path, "read");
        AbstractJcrNode result = this.node(child, (AbstractJcrNode.Type)null, null);
        if (result.isShareable() && (atOrBelow = result.sharedSet().getSharedNodeAtOrBelow(path)) != null) {
            result = atOrBelow;
        }
        return result;
    }

    final AbstractJcrNode node(Path absolutePath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        assert (absolutePath.isAbsolute());
        if (absolutePath.isRoot()) {
            return this.getRootNode();
        }
        if (absolutePath.isIdentifier()) {
            String identifierString = ((String)this.stringFactory().create(absolutePath)).replaceAll("\\[", "").replaceAll("\\]", "");
            return this.getNodeByIdentifier(identifierString);
        }
        CachedNode node = this.getRootNode().node();
        return this.node(node, absolutePath);
    }

    final AbstractJcrItem findItem(NodeKey nodeKey, Path relativePath) throws RepositoryException {
        return this.findItem(this.node(nodeKey, null, null), relativePath);
    }

    final AbstractJcrItem findItem(AbstractJcrNode node, Path relativePath) throws RepositoryException {
        Path nodePath;
        Path absolutePath;
        assert (!relativePath.isAbsolute());
        if (relativePath.size() == 1) {
            Path.Segment last = relativePath.getLastSegment();
            if (last.isSelfReference()) {
                return node;
            }
            if (last.isParentReference()) {
                return node.getParent();
            }
        }
        if ((absolutePath = (nodePath = node.path()).resolve(relativePath)).isAtOrBelow(nodePath)) {
            // empty if block
        }
        return this.getItem(absolutePath);
    }

    Path absolutePathFor(String absPath) throws RepositoryException {
        Path path = null;
        try {
            path = (Path)this.pathFactory().create(absPath);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
        if (!path.isAbsolute()) {
            throw new RepositoryException(JcrI18n.invalidAbsolutePath.text(new Object[]{absPath}));
        }
        return path;
    }

    public JcrRepository getRepository() {
        return this.repository;
    }

    public String getUserID() {
        return this.context.getSecurityContext().getUserName();
    }

    public boolean isAnonymous() {
        return this.context.getSecurityContext().isAnonymous();
    }

    public String[] getAttributeNames() {
        Set<String> names = this.sessionAttributes.keySet();
        if (names.isEmpty()) {
            return NO_ATTRIBUTES_NAMES;
        }
        return names.toArray(new String[names.size()]);
    }

    public Object getAttribute(String name) {
        return this.sessionAttributes.get(name);
    }

    public JcrWorkspace getWorkspace() {
        return this.workspace;
    }

    public JcrRootNode getRootNode() throws RepositoryException {
        this.checkLive();
        return this.rootNode;
    }

    public javax.jcr.Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        this.checkLive();
        return this.repository.login(credentials, this.workspaceName());
    }

    @Deprecated
    public AbstractJcrNode getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        return this.getNodeByIdentifier(uuid);
    }

    public AbstractJcrNode getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        this.checkLive();
        if (NodeKey.isValidFormat(id)) {
            try {
                NodeKey key = new NodeKey(id);
                AbstractJcrNode node = this.node(key, null);
                this.checkPermission(this.pathSupplierFor(node), "read");
                return node;
            }
            catch (ItemNotFoundException key) {
                // empty catch block
            }
        }
        NodeKey key = null;
        ItemNotFoundException first = null;
        try {
            key = this.rootNode.key.withId(id);
            AbstractJcrNode node = this.node(key, null);
            this.checkPermission(this.pathSupplierFor(node), "read");
            return node;
        }
        catch (ItemNotFoundException e) {
            first = e;
            try {
                String systemWorkspaceKey = this.repository().systemWorkspaceKey();
                key = key.withWorkspaceKey(systemWorkspaceKey);
                AbstractJcrNode systemNode = this.node(key, null);
                if (systemNode instanceof JcrVersionHistoryNode) {
                    throw first;
                }
                this.checkPermission(this.pathSupplierFor(systemNode), "read");
                return systemNode;
            }
            catch (ItemNotFoundException e2) {
                throw first;
            }
        }
    }

    public AbstractJcrNode getNonSystemNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        this.checkLive();
        if (NodeKey.isValidFormat(id)) {
            try {
                NodeKey key = new NodeKey(id);
                return this.node(key, null);
            }
            catch (ItemNotFoundException key) {
                // empty catch block
            }
        }
        NodeKey key = this.rootNode.key.withId(id);
        return this.node(key, null);
    }

    public AbstractJcrNode getNode(String absPath) throws PathNotFoundException, RepositoryException {
        return this.getNode(absPath, false);
    }

    protected AbstractJcrNode getNode(String absPath, boolean accessControlScope) throws PathNotFoundException, RepositoryException {
        this.checkLive();
        CheckArg.isNotEmpty((String)absPath, (String)"absolutePath");
        Path path = this.absolutePathFor(absPath);
        if (!accessControlScope) {
            this.checkPermission(path, "read");
        }
        if (path.isRoot()) {
            return this.getRootNode();
        }
        return this.node(path);
    }

    public AbstractJcrItem getItem(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkLive();
        CheckArg.isNotEmpty((String)absPath, (String)"absPath");
        Path path = this.absolutePathFor(absPath);
        return this.getItem(path);
    }

    AbstractJcrItem getItem(Path path) throws PathNotFoundException, RepositoryException {
        assert (path.isAbsolute()) : "Path supplied to Session.getItem(Path) must be absolute";
        if (path.isRoot()) {
            return this.getRootNode();
        }
        if (path.isIdentifier() || path.getLastSegment().hasIndex()) {
            return this.node(path);
        }
        try {
            return this.node(path);
        }
        catch (PathNotFoundException e) {
            AbstractJcrNode parent = this.node(path.getParent());
            AbstractJcrProperty prop = parent.getProperty(path.getLastSegment().getName());
            if (prop != null) {
                return prop;
            }
            String pathStr = (String)this.stringFactory().create(path);
            throw new PathNotFoundException(JcrI18n.itemNotFoundAtPath.text(new Object[]{pathStr, this.workspaceName()}));
        }
    }

    public javax.jcr.Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkLive();
        CheckArg.isNotEmpty((String)absPath, (String)"absPath");
        Path path = this.absolutePathFor(absPath);
        if (path.isRoot()) {
            throw new PathNotFoundException(JcrI18n.rootNodeIsNotProperty.text(new Object[0]));
        }
        if (path.isIdentifier()) {
            throw new PathNotFoundException(JcrI18n.identifierPathNeverReferencesProperty.text(new Object[0]));
        }
        Path.Segment lastSegment = path.getLastSegment();
        if (lastSegment.hasIndex()) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{absPath}));
        }
        AbstractJcrNode parentNode = this.node(path.getParent());
        AbstractJcrProperty property = parentNode.getProperty(lastSegment.getName());
        if (property == null) {
            throw new PathNotFoundException(GraphI18n.pathNotFoundExceptionLowestExistingLocationFound.text(new Object[]{absPath, parentNode.getPath()}));
        }
        return property;
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        try {
            return this.getItem(absPath) != null;
        }
        catch (PathNotFoundException error) {
            return false;
        }
    }

    public void removeItem(String absPath) throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.getItem(absPath).remove();
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        this.checkLive();
        CheckArg.isNotEmpty((String)absPath, (String)"absPath");
        Path absolutePath = this.absolutePathFor(absPath);
        try {
            return this.node(absolutePath) != null;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    protected boolean nodeExists(NodeKey key) {
        return this.cache.getNode(key) != null;
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        this.checkLive();
        CheckArg.isNotEmpty((String)absPath, (String)"absPath");
        Path path = this.absolutePathFor(absPath);
        if (path.isRoot() || path.isIdentifier()) {
            return false;
        }
        Path.Segment lastSegment = path.getLastSegment();
        if (lastSegment.hasIndex()) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{absPath}));
        }
        try {
            CachedNode parentNode = this.cachedNode(path.getParent());
            return parentNode != null && parentNode.hasProperty(lastSegment.getName(), this.cache());
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Lock newParentLock;
        Lock sourceLock;
        this.checkLive();
        Path srcPath = this.absolutePathFor(srcAbsPath);
        this.checkPermission(srcPath, "remove");
        Path destPath = this.absolutePathFor(destAbsPath);
        this.checkPermission(destPath.getParent(), "add_node");
        if (srcPath.isRoot()) {
            throw new RepositoryException(JcrI18n.unableToMoveRootNode.text(new Object[]{this.workspaceName()}));
        }
        if (destPath.isRoot()) {
            throw new RepositoryException(JcrI18n.rootNodeCannotBeDestinationOfMovedNode.text(new Object[]{this.workspaceName()}));
        }
        if (!destPath.isIdentifier() && destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
        }
        if (srcPath.isAncestorOf(destPath)) {
            String msg = JcrI18n.unableToMoveNodeToBeChildOfDecendent.text(new Object[]{srcAbsPath, destAbsPath, this.workspaceName()});
            throw new RepositoryException(msg);
        }
        if (srcPath.equals(destPath)) {
            return;
        }
        AbstractJcrNode srcNode = this.node(srcPath);
        AbstractJcrNode destParentNode = this.node(destPath.getParent());
        SessionCache sessionCache = this.cache();
        if (srcNode.isLocked() && !srcNode.getLock().isLockOwningSession() && (sourceLock = srcNode.getLock()) != null && sourceLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{srcAbsPath}));
        }
        if (destParentNode.isLocked() && !destParentNode.getLock().isLockOwningSession() && (newParentLock = destParentNode.getLock()) != null && newParentLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{destAbsPath}));
        }
        AbstractJcrNode srcParent = srcNode.getParent();
        if (!srcParent.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{srcNode.getPath()}));
        }
        if (!destParentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{destParentNode.getPath()}));
        }
        this.validateMoveForExternalNodes(srcPath, destPath);
        Name newChildName = destPath.getLastSegment().getName();
        destParentNode.validateChildNodeDefinition(newChildName, srcNode.getPrimaryTypeName(), true);
        AbstractJcrNode destAncestor = destParentNode;
        while (!destAncestor.isRoot()) {
            JcrSharedNodeCache.SharedSet sharedSet;
            AbstractJcrNode sharedNodeThatCreatesCircularity;
            if (destAncestor.isShareable() && (sharedNodeThatCreatesCircularity = (sharedSet = destAncestor.sharedSet()).getSharedNodeAtOrBelow(srcPath)) != null) {
                Path badPath = sharedNodeThatCreatesCircularity.path();
                throw new RepositoryException(JcrI18n.unableToMoveNodeDueToCycle.text(new Object[]{srcAbsPath, destAbsPath, this.readable(badPath)}));
            }
            destAncestor = destAncestor.getParent();
        }
        try {
            MutableCachedNode mutableSrcParent = srcParent.mutable();
            MutableCachedNode mutableDestParent = destParentNode.mutable();
            if (mutableSrcParent.equals(mutableDestParent)) {
                mutableSrcParent.renameChild(sessionCache, srcNode.key(), destPath.getLastSegment().getName());
            } else {
                mutableSrcParent.moveChild(sessionCache, srcNode.key(), mutableDestParent, newChildName);
            }
        }
        catch (NodeNotFoundException e) {
            String msg = JcrI18n.nodeNotFound.text(new Object[]{this.stringFactory().create(srcPath.getParent()), this.workspaceName()});
            throw new PathNotFoundException(msg);
        }
    }

    private void validateMoveForExternalNodes(Path srcPath, Path destPath) throws RepositoryException {
        AbstractJcrNode srcNode = this.node(srcPath);
        String rootSourceKey = this.getRootNode().key().getSourceKey();
        Set<NodeKey> sourceNodeKeys = this.cache().getNodeKeysAtAndBelow(srcNode.key());
        boolean sourceContainsExternalNodes = false;
        String externalSourceKey = null;
        for (NodeKey sourceNodeKey : sourceNodeKeys) {
            if (sourceNodeKey.getSourceKey().equalsIgnoreCase(rootSourceKey)) continue;
            externalSourceKey = sourceNodeKey.getSourceKey();
            sourceContainsExternalNodes = true;
            break;
        }
        AbstractJcrNode destNode = null;
        try {
            destNode = this.node(destPath);
        }
        catch (PathNotFoundException e) {
            destNode = this.node(destPath.getParent());
        }
        String externalTargetKey = null;
        boolean targetIsExternal = false;
        if (!destNode.key().getSourceKey().equalsIgnoreCase(rootSourceKey)) {
            targetIsExternal = true;
            externalTargetKey = destNode.key().getSourceKey();
        }
        Connectors connectors = this.repository().runningState().connectors();
        if (sourceContainsExternalNodes && !targetIsExternal) {
            String sourceName = connectors.getSourceNameAtKey(externalSourceKey);
            throw new RepositoryException(JcrI18n.unableToMoveSourceContainExternalNodes.text(new Object[]{srcPath, sourceName}));
        }
        if (!sourceContainsExternalNodes && targetIsExternal) {
            String sourceName = connectors.getSourceNameAtKey(externalTargetKey);
            throw new RepositoryException(JcrI18n.unableToMoveTargetContainExternalNodes.text(new Object[]{srcPath, sourceName}));
        }
        if (targetIsExternal) {
            assert (externalTargetKey != null);
            if (!externalTargetKey.equalsIgnoreCase(srcNode.key().getSourceKey())) {
                String sourceNodeSourceName = connectors.getSourceNameAtKey(srcNode.key().getSourceKey());
                String targetNodeSourceName = connectors.getSourceNameAtKey(externalTargetKey);
                throw new RepositoryException(JcrI18n.unableToMoveSourceTargetMismatch.text(new Object[]{sourceNodeSourceName, targetNodeSourceName}));
            }
            if (connectors.hasExternalProjection(srcPath.getLastSegment().getString(), srcNode.key().toString())) {
                throw new RepositoryException(JcrI18n.unableToMoveProjection.text(new Object[]{srcPath}));
            }
            if (connectors.hasExternalProjection(destPath.getLastSegment().getString(), destNode.key().toString())) {
                throw new RepositoryException(JcrI18n.unableToMoveProjection.text(new Object[]{destPath}));
            }
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, javax.jcr.ReferentialIntegrityException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.checkLive();
        SessionCache systemCache = this.createSystemCache(false);
        SystemContent systemContent = new SystemContent(systemCache);
        Map<NodeKey, NodeKey> baseVersionKeys = this.baseVersionKeys.get();
        Map<NodeKey, NodeKey> originalVersionKeys = this.originalVersionKeys.get();
        try {
            this.cache().save(systemContent.cache(), new JcrPreSave(systemContent, baseVersionKeys, originalVersionKeys, this.aclChangesCount()));
            this.baseVersionKeys.set(null);
            this.originalVersionKeys.set(null);
            this.aclChangesCount.set(0L);
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RepositoryException ? (RepositoryException)cause : new RepositoryException(e.getCause());
        }
        catch (DocumentNotFoundException e) {
            throw new InvalidItemStateException(JcrI18n.nodeModifiedBySessionWasRemovedByAnotherSession.text(new Object[]{e.getKey()}), (Throwable)e);
        }
        catch (DocumentAlreadyExistsException e) {
            NodeKey key = new NodeKey(e.getKey());
            AbstractJcrNode problemNode = this.node(key, null);
            String path = problemNode.getPath();
            throw new InvalidItemStateException(JcrI18n.nodeCreatedBySessionUsedExistingKey.text(new Object[]{path, key}), (Throwable)e);
        }
        catch (ReferentialIntegrityException e) {
            throw new javax.jcr.ReferentialIntegrityException((Throwable)e);
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        try {
            this.repository().statistics().increment(ValueMetric.SESSION_SAVES);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    void save(AbstractJcrNode node) throws RepositoryException {
        Set<NodeKey> keysToBeSaved = null;
        try {
            if (node.isNew()) {
                throw new RepositoryException(JcrI18n.unableToSaveNodeThatWasCreatedSincePreviousSave.text(new Object[]{node.getPath(), this.workspaceName()}));
            }
            AtomicReference<Set<NodeKey>> refToKeys = new AtomicReference<Set<NodeKey>>();
            if (node.containsChangesWithExternalDependencies(refToKeys)) {
                I18n msg = JcrI18n.unableToSaveBranchBecauseChangesDependOnChangesToNodesOutsideOfBranch;
                throw new ConstraintViolationException(msg.text(new Object[]{node.path(), this.workspaceName()}));
            }
            keysToBeSaved = refToKeys.get();
        }
        catch (ItemNotFoundException e) {
            throw new InvalidItemStateException((Throwable)e);
        }
        catch (NodeNotFoundException e) {
            throw new InvalidItemStateException((Throwable)e);
        }
        assert (keysToBeSaved != null);
        SessionCache sessionCache = this.cache();
        if (sessionCache.getChangedNodeKeys().size() == keysToBeSaved.size()) {
            this.save();
            return;
        }
        SessionCache systemCache = this.createSystemCache(false);
        SystemContent systemContent = new SystemContent(systemCache);
        Map<NodeKey, NodeKey> baseVersionKeys = this.baseVersionKeys.get();
        Map<NodeKey, NodeKey> originalVersionKeys = this.originalVersionKeys.get();
        try {
            sessionCache.save(keysToBeSaved, systemContent.cache(), new JcrPreSave(systemContent, baseVersionKeys, originalVersionKeys, this.aclChangesCount()));
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RepositoryException ? (RepositoryException)cause : new RepositoryException(e.getCause());
        }
        catch (DocumentNotFoundException e) {
            throw new InvalidItemStateException(JcrI18n.nodeModifiedBySessionWasRemovedByAnotherSession.text(new Object[]{e.getKey()}), (Throwable)e);
        }
        catch (DocumentAlreadyExistsException e) {
            NodeKey key = new NodeKey(e.getKey());
            AbstractJcrNode problemNode = this.node(key, null);
            String path = problemNode.getPath();
            throw new InvalidItemStateException(JcrI18n.nodeCreatedBySessionUsedExistingKey.text(new Object[]{path, key}), (Throwable)e);
        }
        catch (ReferentialIntegrityException e) {
            throw new javax.jcr.ReferentialIntegrityException((Throwable)e);
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        try {
            this.repository().statistics().increment(ValueMetric.SESSION_SAVES);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.checkLive();
        if (!keepChanges) {
            this.cache.clear();
            this.aclChangesCount.set(0L);
        }
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.checkLive();
        return this.cache().hasChanges();
    }

    public JcrValueFactory getValueFactory() throws RepositoryException {
        this.checkLive();
        return this.valueFactory();
    }

    private PathSupplier pathSupplierFor(final Path path) {
        return new PathSupplier(){

            @Override
            public Path getAbsolutePath() {
                return path;
            }
        };
    }

    private PathSupplier pathSupplierFor(final CachedNode node, final NodeCache nodeCache) {
        return new PathSupplier(){

            @Override
            public Path getAbsolutePath() throws ItemNotFoundException {
                return node.getPath(nodeCache);
            }
        };
    }

    private PathSupplier pathSupplierFor(final AbstractJcrItem item) {
        return new PathSupplier(){

            @Override
            public Path getAbsolutePath() throws ItemNotFoundException {
                try {
                    return item.path();
                }
                catch (InvalidItemStateException invalidItemStateException) {
                }
                catch (ItemNotFoundException err) {
                    throw err;
                }
                catch (RepositoryException e) {
                    return null;
                }
                assert (false);
                return null;
            }
        };
    }

    private boolean hasPermission(String workspaceName, PathSupplier pathSupplier, String ... actions) {
        SecurityContext sec = this.context.getSecurityContext();
        boolean checkAcl = this.repository.repositoryCache().isAccessControlEnabled();
        boolean hasPermission = true;
        String repositoryName = this.repository.repositoryName();
        try {
            Path path;
            Object authorizer;
            if (sec instanceof AuthorizationProvider) {
                authorizer = (String[])sec;
                Path path2 = path = pathSupplier != null ? pathSupplier.getAbsolutePath() : null;
                if (path != null) {
                    assert (path.isAbsolute()) : "The path (if provided) must be absolute";
                    hasPermission = authorizer.hasPermission(this.context, repositoryName, repositoryName, workspaceName, path, actions);
                    if (checkAcl && hasPermission) {
                        hasPermission = this.acm.hasPermission(path, actions);
                    }
                    return hasPermission;
                }
            }
            if (sec instanceof AdvancedAuthorizationProvider) {
                authorizer = (AdvancedAuthorizationProvider)((Object)sec);
                Path path3 = path = pathSupplier != null ? pathSupplier.getAbsolutePath() : null;
                if (path != null) {
                    assert (path.isAbsolute()) : "The path (if provided) must be absolute";
                    hasPermission = authorizer.hasPermission(this.authorizerContext, path, actions);
                    if (checkAcl && hasPermission) {
                        hasPermission = this.acm.hasPermission(path, actions);
                    }
                    return hasPermission;
                }
            }
            for (String action : actions) {
                if ("read".equals(action)) {
                    hasPermission &= JcrSession.hasRole(sec, "readonly", repositoryName, workspaceName) || JcrSession.hasRole(sec, "readwrite", repositoryName, workspaceName) || JcrSession.hasRole(sec, "admin", repositoryName, workspaceName);
                    continue;
                }
                if ("register_namespace".equals(action) || "register_type".equals(action) || "unlock_any".equals(action) || "create_workspace".equals(action) || "delete_workspace".equals(action) || "monitor".equals(action) || "delete_workspace".equals(action) || "index_workspace".equals(action)) {
                    hasPermission &= JcrSession.hasRole(sec, "admin", repositoryName, workspaceName);
                    continue;
                }
                hasPermission &= JcrSession.hasRole(sec, "admin", repositoryName, workspaceName) || JcrSession.hasRole(sec, "readwrite", repositoryName, workspaceName);
            }
            if (checkAcl && hasPermission) {
                Path path4;
                Path path5 = path4 = pathSupplier != null ? pathSupplier.getAbsolutePath() : null;
                if (path4 != null) {
                    assert (path4.isAbsolute()) : "The path (if provided) must be absolute";
                    hasPermission = this.acm.hasPermission(path4, actions);
                }
            }
            return hasPermission;
        }
        catch (ItemNotFoundException err) {
            return false;
        }
    }

    private boolean hasPermissionOnExternalPath(PathSupplier pathSupplier, String ... actions) throws RepositoryException {
        Connectors connectors = this.repository().runningState().connectors();
        if (!connectors.hasConnectors() || !connectors.hasReadonlyConnectors()) {
            return true;
        }
        Path path = pathSupplier.getAbsolutePath();
        if (path == null) {
            return false;
        }
        if (connectors.isReadonlyPath(path, this)) {
            if (actions.length > ModeShapePermissions.READONLY_EXTERNAL_PATH_PERMISSIONS.size()) {
                return false;
            }
            ArrayList<String> actionsList = new ArrayList<String>(Arrays.asList(actions));
            Iterator actionsIterator = actionsList.iterator();
            while (actionsIterator.hasNext()) {
                String action = (String)actionsIterator.next();
                if (!ModeShapePermissions.READONLY_EXTERNAL_PATH_PERMISSIONS.contains(action)) {
                    return false;
                }
                actionsIterator.remove();
            }
            return actionsList.isEmpty();
        }
        return true;
    }

    static boolean hasRole(SecurityContext context, String roleName, String repositoryName, String workspaceName) {
        if (context.hasRole(roleName)) {
            return true;
        }
        if (context.hasRole(roleName = roleName + "." + repositoryName)) {
            return true;
        }
        roleName = roleName + "." + workspaceName;
        return context.hasRole(roleName);
    }

    public void checkPermission(String path, String actions) {
        CheckArg.isNotEmpty((String)path, (String)"path");
        CheckArg.isNotEmpty((String)actions, (String)"actions");
        try {
            PathSupplier supplier = this.pathSupplierFor(this.absolutePathFor(path));
            String[] actionsArray = actions.split(",");
            this.checkPermission(this.workspace().getName(), supplier, actionsArray);
            if (!this.hasPermissionOnExternalPath(supplier, actionsArray)) {
                String absPath = supplier.getAbsolutePath().getString(this.namespaces());
                throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, actions}));
            }
        }
        catch (RepositoryException e) {
            throw new AccessControlException(JcrI18n.permissionDenied.text(new Object[]{path, actions}));
        }
    }

    void checkPermission(Path path, String ... actions) throws AccessDeniedException {
        this.checkPermission(this.workspace().getName(), path, actions);
    }

    void checkPermission(PathSupplier pathSupplier, String ... actions) throws AccessDeniedException {
        this.checkPermission(this.workspace().getName(), pathSupplier, actions);
    }

    void checkPermission(AbstractJcrItem item, String ... actions) throws AccessDeniedException {
        this.checkPermission(this.workspace().getName(), this.pathSupplierFor(item), actions);
    }

    void checkPermission(CachedNode node, NodeCache cache, String ... actions) throws AccessDeniedException {
        this.checkPermission(this.workspace().getName(), this.pathSupplierFor(node, cache), actions);
    }

    void checkPermission(String workspaceName, Path path, String ... actions) throws AccessDeniedException {
        this.checkPermission(workspaceName, this.pathSupplierFor(path), actions);
    }

    void checkPermission(String workspaceName, PathSupplier pathSupplier, String ... actions) throws AccessDeniedException {
        CheckArg.isNotEmpty((Object[])actions, (String)"actions");
        if (this.hasPermission(workspaceName, pathSupplier, actions)) {
            return;
        }
        String pathAsString = "<unknown>";
        if (pathSupplier != null) {
            try {
                pathAsString = pathSupplier.getAbsolutePath().getString(this.namespaces());
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{pathAsString, actions}));
    }

    void checkWorkspacePermission(String workspaceName, String ... actions) throws AccessDeniedException {
        this.checkPermission(workspaceName, (PathSupplier)null, actions);
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        this.checkLive();
        CheckArg.isNotEmpty((String)absPath, (String)"absPath");
        PathSupplier pathSupplier = this.pathSupplierFor(this.absolutePathFor(absPath));
        String[] actionsArray = actions.split(",");
        String workspaceName = this.workspace().getName();
        return this.hasPermission(workspaceName, pathSupplier, actionsArray) && this.hasPermissionOnExternalPath(pathSupplier, actionsArray);
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        CheckArg.isNotEmpty((String)methodName, (String)"methodName");
        CheckArg.isNotNull((Object)target, (String)"target");
        this.checkLive();
        if (target instanceof AbstractJcrNode) {
            AbstractJcrNode node = (AbstractJcrNode)target;
            if ("addNode".equals(methodName)) {
                CheckArg.hasSizeOfAtLeast((Object[])arguments, (int)1, (String)"arguments");
                CheckArg.hasSizeOfAtMost((Object[])arguments, (int)2, (String)"arguments");
                CheckArg.isInstanceOf((Object)arguments[0], String.class, (String)"arguments[0]");
                String relPath = (String)arguments[0];
                String primaryNodeTypeName = null;
                if (arguments.length > 1) {
                    CheckArg.isInstanceOf((Object)arguments[1], String.class, (String)"arguments[1]");
                    primaryNodeTypeName = (String)arguments[1];
                }
                return node.canAddNode(relPath, primaryNodeTypeName);
            }
        }
        return true;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.checkLive();
        AbstractJcrNode parent = this.getNode(parentAbsPath);
        if (!parent.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parent.getPath()}));
        }
        boolean retainLifecycleInfo = this.getRepository().getDescriptorValue("option.lifecycle.supported").getBoolean();
        boolean retainRetentionInfo = this.getRepository().getDescriptorValue("option.retention.supported").getBoolean();
        return new JcrContentHandler(this, parent, uuidBehavior, false, retainRetentionInfo, retainLifecycleInfo);
    }

    protected void initBaseVersionKeys() {
        this.baseVersionKeys.compareAndSet(null, new ConcurrentHashMap());
    }

    protected void initOriginalVersionKeys() {
        this.originalVersionKeys.compareAndSet(null, new ConcurrentHashMap());
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        CheckArg.isNotNull((Object)in, (String)"in");
        this.checkLive();
        boolean error = false;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this.getImportContentHandler(parentAbsPath, uuidBehavior));
            parser.parse(new InputSource(in));
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)((Object)cause);
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            error = true;
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            error = true;
            throw new RepositoryException((Throwable)se);
        }
        finally {
            block16: {
                try {
                    in.close();
                }
                catch (IOException t) {
                    if (!error) {
                        throw t;
                    }
                }
                catch (RuntimeException re) {
                    if (error) break block16;
                    throw re;
                }
            }
        }
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)contentHandler, (String)"contentHandler");
        AbstractJcrNode exportRootNode = this.getNode(absPath);
        JcrSystemViewExporter exporter = new JcrSystemViewExporter(this);
        exporter.exportView((Node)exportRootNode, contentHandler, skipBinary, noRecurse);
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)out, (String)"out");
        AbstractJcrNode exportRootNode = this.getNode(absPath);
        JcrSystemViewExporter exporter = new JcrSystemViewExporter(this);
        exporter.exportView((Node)exportRootNode, out, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)contentHandler, (String)"contentHandler");
        this.checkLive();
        AbstractJcrNode exportRootNode = this.getNode(absPath);
        JcrDocumentViewExporter exporter = new JcrDocumentViewExporter(this);
        exporter.exportView((Node)exportRootNode, contentHandler, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)out, (String)"out");
        AbstractJcrNode exportRootNode = this.getNode(absPath);
        JcrDocumentViewExporter exporter = new JcrDocumentViewExporter(this);
        exporter.exportView((Node)exportRootNode, out, skipBinary, noRecurse);
    }

    public String getNamespacePrefix(String uri) throws RepositoryException {
        this.checkLive();
        return this.sessionRegistry.getPrefix(uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        this.checkLive();
        return this.sessionRegistry.getPrefixes();
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        this.checkLive();
        return this.sessionRegistry.getURI(prefix);
    }

    public void setNamespacePrefix(String newPrefix, String existingUri) throws NamespaceException, RepositoryException {
        this.checkLive();
        this.sessionRegistry.registerNamespace(newPrefix, existingUri);
    }

    public synchronized void logout() {
        this.terminate(true);
        try {
            JcrRepository.RunningState running = this.repository.runningState();
            long lifetime = Math.abs(System.nanoTime() - this.nanosCreated);
            Map<String, String> payload = Collections.singletonMap("userId", this.getUserID());
            running.statistics().recordDuration(DurationMetric.SESSION_LIFETIME, lifetime, TimeUnit.NANOSECONDS, payload);
            running.statistics().decrement(ValueMetric.SESSION_COUNT);
            running.removeSession(this);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void addLockToken(String lockToken) {
        CheckArg.isNotNull((Object)lockToken, (String)"lockToken");
        try {
            this.lockManager().addLockToken(lockToken);
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public String[] getLockTokens() {
        if (!this.isLive()) {
            return new String[0];
        }
        return this.lockManager().getLockTokens();
    }

    public void removeLockToken(String lockToken) {
        CheckArg.isNotNull((Object)lockToken, (String)"lockToken");
        try {
            this.lockManager().removeLockToken(lockToken);
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public AccessControlManager getAccessControlManager() {
        return this.acm;
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    Path getPathForCorrespondingNode(String workspaceName, NodeKey key, Path relativePath) throws NoSuchWorkspaceException, AccessDeniedException, ItemNotFoundException, RepositoryException {
        assert (key != null);
        try {
            WorkspaceCache cache = this.repository.repositoryCache().getWorkspaceCache(workspaceName);
            CachedNode node = cache.getNode(key);
            if (node == null) {
                throw new ItemNotFoundException(JcrI18n.itemNotFoundWithUuid.text(new Object[]{key.toString(), workspaceName}));
            }
            if (relativePath != null) {
                for (Path.Segment segment : relativePath) {
                    ChildReference child = node.getChildReferences(cache).getChild(segment);
                    if (child == null) {
                        Path path = this.pathFactory().create(node.getPath(cache), segment);
                        throw new ItemNotFoundException(JcrI18n.itemNotFoundAtPath.text(new Object[]{path.getString(this.namespaces()), this.workspaceName()}));
                    }
                    CachedNode childNode = cache.getNode(child);
                    if (childNode == null) {
                        Path path = this.pathFactory().create(node.getPath(cache), segment);
                        throw new ItemNotFoundException(JcrI18n.itemNotFoundAtPath.text(new Object[]{path.getString(this.namespaces()), this.workspaceName()}));
                    }
                    node = childNode;
                }
            }
            return node.getPath(cache);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        catch (WorkspaceNotFoundException e) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.repository().repositoryName(), workspaceName}));
        }
    }

    public static NodeKey createNodeKeyFromIdentifier(String identifier, NodeKey rootKey) {
        if (NodeKey.isValidRandomIdentifier(identifier)) {
            return rootKey.withId(identifier);
        }
        return new NodeKey(identifier);
    }

    public static boolean isForeignKey(NodeKey key, NodeKey rootKey) {
        if (key == null) {
            return false;
        }
        String nodeWorkspaceKey = key.getWorkspaceKey();
        boolean sameWorkspace = rootKey.getWorkspaceKey().equals(nodeWorkspaceKey);
        boolean sameSource = rootKey.getSourceKey().equalsIgnoreCase(key.getSourceKey());
        return !sameWorkspace || !sameSource;
    }

    public static String nodeIdentifier(NodeKey key, NodeKey rootKey) {
        return JcrSession.isForeignKey(key, rootKey) ? key.toString() : key.getIdentifier();
    }

    protected final boolean isForeignKey(NodeKey key) {
        return JcrSession.isForeignKey(key, this.cache.getRootKey());
    }

    protected final String nodeIdentifier(NodeKey key) {
        return JcrSession.nodeIdentifier(key, this.cache.getRootKey());
    }

    public boolean sequence(String sequencerName, javax.jcr.Property inputProperty, Node outputNode) throws RepositoryException {
        CheckArg.isSame((Object)inputProperty.getSession(), (String)"inputProperty", (Object)this, (String)"this session");
        CheckArg.isSame((Object)outputNode.getSession(), (String)"outputNode", (Object)this, (String)"this session");
        Sequencer sequencer = this.repository().runningState().sequencers().getSequencer(sequencerName);
        if (sequencer == null) {
            return false;
        }
        final JcrValueFactory values = this.getValueFactory();
        final DateTime now = this.dateFactory().create();
        Sequencer.Context context = new Sequencer.Context(){

            public ValueFactory valueFactory() {
                return values;
            }

            public Calendar getTimestamp() {
                return now.toCalendar();
            }
        };
        try {
            String mimeType;
            if (sequencer.hasAcceptedMimeTypes() && (mimeType = SequencingRunner.getInputMimeType(inputProperty)) != null && !sequencer.isAccepted(mimeType)) {
                Logger.getLogger(this.getClass()).debug("Skipping sequencing because input's MIME type '{0}' is not accepted by the '{1}' sequencer", new Object[]{mimeType, sequencerName});
                return false;
            }
            return sequencer.execute(inputProperty, outputNode, context);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String toString() {
        return this.cache.toString();
    }

    public String decode(String localName) {
        return Path.JSR283_DECODER.decode(localName);
    }

    public String encode(String localName) {
        return Path.JSR283_ENCODER.encode(localName);
    }

    protected class SystemSessionCache
    extends SessionCacheWrapper {
        protected SystemSessionCache(SessionCache delegate) {
            super(delegate);
        }

        @Override
        public void save() {
            super.save();
            this.signalSaveOfSystemChanges();
        }

        @Override
        public void save(SessionCache otherSession, SessionCache.PreSave preSaveOperation) {
            super.save(otherSession, preSaveOperation);
            this.signalSaveOfSystemChanges();
        }

        @Override
        public void save(Set<NodeKey> toBeSaved, SessionCache otherSession, SessionCache.PreSave preSaveOperation) {
            super.save(toBeSaved, otherSession, preSaveOperation);
            this.signalSaveOfSystemChanges();
        }

        private void signalSaveOfSystemChanges() {
            JcrSession.this.cache().checkForTransaction();
        }
    }

    protected final class JcrPreSave
    implements SessionCache.PreSave {
        private final SessionCache cache;
        private final SessionCache systemCache;
        private final RepositoryNodeTypeManager nodeTypeMgr;
        private final NodeTypes nodeTypeCapabilities;
        private final SystemContent systemContent;
        private final Map<NodeKey, NodeKey> baseVersionKeys;
        private final Map<NodeKey, NodeKey> originalVersionKeys;
        private boolean initialized = false;
        private PropertyFactory propertyFactory;
        private ReferenceFactory referenceFactory;
        private JcrVersionManager versionManager;

        protected JcrPreSave(SystemContent content, Map<NodeKey, NodeKey> baseVersionKeys, Map<NodeKey, NodeKey> originalVersionKeys, long aclChangesCount) {
            assert (content != null);
            this.cache = JcrSession.this.cache();
            this.systemContent = content;
            this.systemCache = content.cache();
            this.baseVersionKeys = baseVersionKeys;
            this.originalVersionKeys = originalVersionKeys;
            this.nodeTypeMgr = JcrSession.this.repository().nodeTypeManager();
            this.nodeTypeCapabilities = this.nodeTypeMgr.getNodeTypes();
            if (aclChangesCount != 0L) {
                this.aclMetadataRefresh(aclChangesCount);
            }
        }

        private void aclMetadataRefresh(long aclChangesCount) {
            MutableCachedNode systemNode = this.systemContent.mutableSystemNode();
            Property aclCount = systemNode.getProperty(ModeShapeLexicon.ACL_COUNT, this.systemCache);
            if (aclCount == null && aclChangesCount > 0L) {
                systemNode.setProperty(this.systemCache, JcrSession.this.propertyFactory().create(ModeShapeLexicon.ACL_COUNT, aclChangesCount));
                JcrSession.this.repository().repositoryCache().setAccessControlEnabled(true);
            } else if (aclCount != null) {
                long newCount = Long.valueOf(aclCount.getFirstValue().toString()) + aclChangesCount;
                if (newCount < 0L) {
                    newCount = 0L;
                }
                if (newCount == 0L) {
                    JcrSession.this.repository().repositoryCache().setAccessControlEnabled(false);
                }
                systemNode.setProperty(this.systemCache, JcrSession.this.propertyFactory().create(ModeShapeLexicon.ACL_COUNT, newCount));
            }
        }

        @Override
        public void process(MutableCachedNode node, SessionCache.SaveContext context) throws Exception {
            Object dataValue;
            Property dataProp;
            Set<Name> mixinTypes;
            Name primaryType = node.getPrimaryType(this.cache);
            if (this.nodeTypeCapabilities.isFullyDefinedType(primaryType, mixinTypes = node.getMixinTypes(this.cache))) {
                return;
            }
            if (!this.initialized) {
                this.initialized = true;
                this.versionManager = JcrSession.this.versionManager();
                this.propertyFactory = JcrSession.this.propertyFactory();
                this.referenceFactory = JcrSession.this.referenceFactory();
            }
            AbstractJcrNode jcrNode = null;
            boolean initializeVersionHistory = false;
            if (node.isNew()) {
                if (this.nodeTypeCapabilities.isCreated(primaryType, mixinTypes)) {
                    node.setPropertyIfUnchanged(this.cache, this.propertyFactory.create(JcrLexicon.CREATED, context.getTime()));
                    node.setPropertyIfUnchanged(this.cache, this.propertyFactory.create(JcrLexicon.CREATED_BY, context.getUserId()));
                }
                initializeVersionHistory = this.nodeTypeCapabilities.isVersionable(primaryType, mixinTypes);
            } else if (node.hasChangedPrimaryType() || !node.getAddedMixins(this.cache).isEmpty()) {
                initializeVersionHistory = this.nodeTypeCapabilities.isVersionable(primaryType, mixinTypes);
            }
            if (this.nodeTypeCapabilities.isLastModified(primaryType, mixinTypes)) {
                node.setPropertyIfUnchanged(this.cache, this.propertyFactory.create(JcrLexicon.LAST_MODIFIED, context.getTime()));
                node.setPropertyIfUnchanged(this.cache, this.propertyFactory.create(JcrLexicon.LAST_MODIFIED_BY, context.getUserId()));
            }
            if (initializeVersionHistory) {
                Reference baseVersionRef;
                NodeKey versionableKey = node.getKey();
                if (!this.systemContent.hasVersionHistory(versionableKey)) {
                    CachedNode baseVersionNode;
                    NodeKey historyKey = this.systemContent.versionHistoryNodeKeyFor(versionableKey);
                    NodeKey baseVersionKey = this.baseVersionKeys == null ? null : this.baseVersionKeys.get(versionableKey);
                    boolean shouldCreateNewVersionHistory = true;
                    if (baseVersionKey != null && (baseVersionNode = this.systemCache.getNode(baseVersionKey)) != null) {
                        historyKey = baseVersionNode.getParentKey(this.systemCache);
                        boolean bl = shouldCreateNewVersionHistory = historyKey == null;
                    }
                    if (shouldCreateNewVersionHistory) {
                        assert (historyKey != null);
                        if (baseVersionKey == null) {
                            baseVersionKey = historyKey.withRandomId();
                        }
                        NodeKey originalVersionKey = this.originalVersionKeys != null ? this.originalVersionKeys.get(versionableKey) : null;
                        Path versionHistoryPath = this.versionManager.versionHistoryPathFor(versionableKey);
                        this.systemContent.initializeVersionStorage(versionableKey, historyKey, baseVersionKey, primaryType, mixinTypes, versionHistoryPath, originalVersionKey, context.getTime());
                    }
                    Reference historyRef = this.referenceFactory.create(historyKey, true);
                    baseVersionRef = this.referenceFactory.create(baseVersionKey, true);
                    node.setProperty(this.cache, this.propertyFactory.create(JcrLexicon.IS_CHECKED_OUT, Boolean.TRUE));
                    node.setReference(this.cache, this.propertyFactory.create(JcrLexicon.VERSION_HISTORY, historyRef), this.systemCache);
                    node.setReference(this.cache, this.propertyFactory.create(JcrLexicon.BASE_VERSION, baseVersionRef), this.systemCache);
                    node.setReference(this.cache, this.propertyFactory.create(JcrLexicon.PREDECESSORS, new Object[]{baseVersionRef}), this.systemCache);
                } else {
                    boolean hasVersioningProperties;
                    boolean bl = hasVersioningProperties = node.hasProperty(JcrLexicon.IS_CHECKED_OUT, this.cache) || node.hasProperty(JcrLexicon.VERSION_HISTORY, this.cache) || node.hasProperty(JcrLexicon.BASE_VERSION, this.cache) || node.hasProperty(JcrLexicon.PREDECESSORS, this.cache);
                    if (!hasVersioningProperties) {
                        node.setProperty(this.cache, this.propertyFactory.create(JcrLexicon.IS_CHECKED_OUT, Boolean.TRUE));
                        JcrVersionHistoryNode versionHistoryNode = JcrSession.this.versionManager().getVersionHistory(JcrSession.this.node(node.getKey(), null));
                        Reference historyRef = this.referenceFactory.create(versionHistoryNode.key(), true);
                        node.setReference(this.cache, this.propertyFactory.create(JcrLexicon.VERSION_HISTORY, historyRef), this.systemCache);
                        AbstractJcrNode baseVersion = null;
                        VersionIterator versionIterator = versionHistoryNode.getAllVersions();
                        while (versionIterator.hasNext()) {
                            JcrVersionNode version = (JcrVersionNode)versionIterator.nextVersion();
                            if (baseVersion != null && !version.isLinearSuccessorOf((JcrVersionNode)baseVersion)) continue;
                            baseVersion = version;
                        }
                        assert (baseVersion != null);
                        baseVersionRef = this.referenceFactory.create(baseVersion.key(), true);
                        node.setReference(this.cache, this.propertyFactory.create(JcrLexicon.BASE_VERSION, baseVersionRef), this.systemCache);
                        Version[] baseVersionPredecessors = ((JcrVersionNode)baseVersion).getPredecessors();
                        Object[] predecessors = new Reference[baseVersionPredecessors.length];
                        for (int i = 0; i < baseVersionPredecessors.length; ++i) {
                            predecessors[i] = this.referenceFactory.create(((JcrVersionNode)baseVersionPredecessors[i]).key(), true);
                        }
                        node.setReference(this.cache, this.propertyFactory.create(JcrLexicon.PREDECESSORS, predecessors), this.systemCache);
                    }
                }
            }
            if (this.nodeTypeCapabilities.isNtResource(primaryType) && !node.hasProperty(JcrLexicon.MIMETYPE, this.cache) && (dataProp = node.getProperty(JcrLexicon.DATA, this.cache)) != null && (dataValue = dataProp.getFirstValue()) instanceof Binary) {
                String mimeType;
                Binary binaryValue = (Binary)dataValue;
                String fileName = null;
                NodeKey parentKey = node.getParentKey(this.cache);
                if (parentKey != null) {
                    CachedNode parent = this.cache.getNode(parentKey);
                    Name parentName = parent.getName(this.cache);
                    fileName = (String)JcrSession.this.stringFactory().create(parentName);
                }
                if ((mimeType = binaryValue.getMimeType(fileName)) != null) {
                    node.setProperty(this.cache, this.propertyFactory.create(JcrLexicon.MIMETYPE, mimeType));
                }
            }
            Collection<JcrPropertyDefinition> mandatoryPropDefns = null;
            mandatoryPropDefns = this.nodeTypeCapabilities.getMandatoryPropertyDefinitions(primaryType, mixinTypes);
            if (!mandatoryPropDefns.isEmpty()) {
                for (JcrPropertyDefinition defn : mandatoryPropDefns) {
                    Name propName = defn.getInternalName();
                    if (!node.hasProperty(propName, this.cache)) {
                        if (defn.hasDefaultValues()) {
                            if (jcrNode == null) {
                                jcrNode = JcrSession.this.node(node, (AbstractJcrNode.Type)null, null);
                            }
                            Value[] defaultValues = defn.getDefaultValues();
                            if (defn.isMultiple()) {
                                jcrNode.setProperty(propName, defaultValues, defn.getRequiredType(), false);
                                continue;
                            }
                            jcrNode.setProperty(propName, defaultValues[0], false, false, false, false);
                            continue;
                        }
                        String pName = defn.getName();
                        String typeName = defn.getDeclaringNodeType().getName();
                        String loc = JcrSession.this.readableLocation(node);
                        throw new ConstraintViolationException(JcrI18n.missingMandatoryProperty.text(new Object[]{pName, typeName, loc}));
                    }
                    if (jcrNode == null) {
                        jcrNode = JcrSession.this.node(node, (AbstractJcrNode.Type)null, null);
                    }
                    AbstractJcrProperty jcrProperty = jcrNode.getProperty(propName);
                    PropertyDefinitionId defnId = jcrProperty.propertyDefinitionId();
                    if (defn.getId().equals(defnId)) continue;
                    jcrProperty.releasePropertyDefinitionId();
                    defnId = jcrProperty.propertyDefinitionId();
                    if (defn.getId().equals(defnId)) continue;
                    String pName = defn.getName();
                    String typeName = defn.getDeclaringNodeType().getName();
                    String loc = JcrSession.this.readableLocation(node);
                    I18n msg = JcrI18n.propertyNoLongerSatisfiesConstraints;
                    throw new ConstraintViolationException(msg.text(new Object[]{pName, loc, defn.getName(), typeName}));
                }
            }
            Collection<JcrNodeDefinition> mandatoryChildDefns = null;
            mandatoryChildDefns = this.nodeTypeCapabilities.getMandatoryChildNodeDefinitions(primaryType, mixinTypes);
            if (!mandatoryChildDefns.isEmpty()) {
                HashSet<Name> childrenNames = new HashSet<Name>();
                for (ChildReference childRef : node.getChildReferences(JcrSession.this.cache())) {
                    childrenNames.add(childRef.getName());
                }
                for (JcrNodeDefinition defn : mandatoryChildDefns) {
                    Name childName = defn.getInternalName();
                    if (childrenNames.contains(childName)) continue;
                    throw new ConstraintViolationException(JcrI18n.propertyNoLongerSatisfiesConstraints.text(new Object[]{childName, JcrSession.this.readableLocation(node), defn.getName(), defn.getDeclaringNodeType().getName()}));
                }
            }
            if (this.nodeTypeCapabilities.isETag(primaryType, mixinTypes)) {
                String etagValue = node.getEtag(this.cache);
                node.setProperty(this.cache, this.propertyFactory.create(JcrLexicon.ETAG, etagValue));
            }
        }

        @Override
        public void processAfterLocking(MutableCachedNode modifiedNode, SessionCache.SaveContext context, NodeCache persistentNodeCache) throws RepositoryException {
            Set<Name> mixinTypes;
            Name primaryType = modifiedNode.getPrimaryType(this.cache);
            if (!this.nodeTypeCapabilities.disallowsSameNameSiblings(primaryType, mixinTypes = modifiedNode.getMixinTypes(this.cache))) {
                return;
            }
            MutableCachedNode.NodeChanges changes = modifiedNode.getNodeChanges();
            LinkedHashMap<NodeKey, Name> appendedChildren = changes.appendedChildren();
            Map<NodeKey, Name> renamedChildren = changes.renamedChildren();
            Set<NodeKey> removedChildren = changes.removedChildren();
            if (!appendedChildren.isEmpty() || !renamedChildren.isEmpty()) {
                LinkedListMultimap appendedOrRenamedChildrenByName = LinkedListMultimap.create();
                for (Map.Entry entry : appendedChildren.entrySet()) {
                    appendedOrRenamedChildrenByName.put(entry.getValue(), entry.getKey());
                }
                for (Map.Entry<Object, Object> entry : renamedChildren.entrySet()) {
                    appendedOrRenamedChildrenByName.put(entry.getValue(), entry.getKey());
                }
                assert (!appendedOrRenamedChildrenByName.isEmpty());
                CachedNode persistentNode = persistentNodeCache.getNode(modifiedNode.getKey());
                ChildReferences childReferences = persistentNode.getChildReferences(persistentNodeCache);
                SiblingCounter siblingCounter = SiblingCounter.create(childReferences);
                for (Name childName : appendedOrRenamedChildrenByName.keySet()) {
                    NodeKey persistedChildKey;
                    NodeTypes.NodeDefinitionSet childDefns;
                    JcrNodeDefinition childNodeDefinition;
                    NodeKey persistedChildKey2;
                    int existingChildrenWithSameName = childReferences.getChildCount(childName);
                    if (existingChildrenWithSameName == 0 || existingChildrenWithSameName == 1 && removedChildren.contains(persistedChildKey2 = childReferences.getChild(childName).getKey()) || (childNodeDefinition = (childDefns = this.nodeTypeCapabilities.findChildNodeDefinitions(primaryType, mixinTypes)).findBestDefinitionForChild(childName, null, true, siblingCounter)) != null || appendedChildren.containsKey(persistedChildKey = childReferences.getChild(childName).getKey()) || renamedChildren.containsKey(persistedChildKey)) continue;
                    SessionCache session = JcrSession.this.cache();
                    for (NodeKey appendedOrRenamedKey : appendedOrRenamedChildrenByName.get((Object)childName)) {
                        CachedNode appendedOrRenamedChild = session.getNode(appendedOrRenamedKey);
                        if (appendedOrRenamedChild == null) continue;
                        Name childPrimaryType = appendedOrRenamedChild.getPrimaryType(session);
                        childDefns = this.nodeTypeCapabilities.findChildNodeDefinitions(primaryType, mixinTypes);
                        childNodeDefinition = childDefns.findBestDefinitionForChild(childName, childPrimaryType, true, siblingCounter);
                        if (childNodeDefinition != null) continue;
                        throw new ItemExistsException(JcrI18n.noSnsDefinitionForNode.text(new Object[]{childName, JcrSession.this.workspaceName()}));
                    }
                }
            }
        }
    }

    private static interface PathSupplier {
        public Path getAbsolutePath() throws ItemNotFoundException;
    }
}

