/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.clustering;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.bus.BusI18n;
import org.modeshape.jcr.clustering.ChannelProvider;

public class DefaultChannelProvider
implements ChannelProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultChannelProvider.class);

    @Override
    public JChannel getChannel(RepositoryConfiguration.Clustering clusteringConfig) throws Exception {
        String channelConfiguration = clusteringConfig.getChannelConfiguration();
        if (channelConfiguration == null || channelConfiguration.trim().length() == 0) {
            return new JChannel();
        }
        ProtocolStackConfigurator configurator = this.createConfigurator(channelConfiguration);
        if (configurator == null) {
            throw new RepositoryException(BusI18n.channelConfigurationError.text(new Object[]{channelConfiguration}));
        }
        return new JChannel(configurator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtocolStackConfigurator createConfigurator(String channelConfiguration) {
        XmlConfigurator configurator = null;
        InputStream stream = DefaultChannelProvider.class.getClassLoader().getResourceAsStream(channelConfiguration);
        try {
            configurator = XmlConfigurator.getInstance((InputStream)stream);
        }
        catch (IOException e) {
            LOGGER.debug((Throwable)e, "Channel configuration is not a classpath resource", new Object[0]);
            stream = new ByteArrayInputStream(channelConfiguration.getBytes());
            try {
                configurator = XmlConfigurator.getInstance((InputStream)stream);
            }
            catch (IOException e1) {
                LOGGER.debug((Throwable)e, "Channel configuration is not valid XML content", new Object[0]);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return configurator;
    }
}

