/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.internal.SchematicExternalizer;

@Immutable
@SerializeWith(value=Externalizer.class)
public final class Symbol
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String symbol;

    public Symbol(String symbol) {
        this.symbol = symbol;
        assert (this.symbol != null);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Symbol) {
            Symbol that = (Symbol)obj;
            return this.getSymbol().equals(that.getSymbol());
        }
        if (obj instanceof String) {
            String that = (String)obj;
            return that.equals(this.getSymbol());
        }
        return false;
    }

    public String toString() {
        return this.symbol;
    }

    public static class Externalizer
    extends SchematicExternalizer<Symbol> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, Symbol symbol) throws IOException {
            output.writeUTF(symbol.getSymbol());
        }

        public Symbol readObject(ObjectInput input) throws IOException {
            return new Symbol(input.readUTF());
        }

        @Override
        public Integer getId() {
            return 1615;
        }

        @Override
        public Set<Class<? extends Symbol>> getTypeClasses() {
            return Collections.singleton(Symbol.class);
        }
    }
}

