/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.HashCode;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;

@Immutable
@SerializeWith(value=Externalizer.class)
public class ClearOperation
extends ArrayOperation {
    private transient List<?> removedValues;

    public ClearOperation(Path path) {
        super(path, HashCode.compute(path));
    }

    @Override
    public ClearOperation clone() {
        return this;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        if (!array.isEmpty()) {
            this.removedValues = new ArrayList<Object>(array);
            array.clear();
        } else {
            this.removedValues = Collections.emptyList();
        }
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.removedValues != null) {
            MutableArray array = this.mutableParent(delegate);
            array.clear();
            array.addAll(this.removedValues);
            this.removedValues = null;
        }
    }

    public String toString() {
        return "Clear at '" + this.parentPath + "' the existing values";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClearOperation) {
            ClearOperation that = (ClearOperation)obj;
            return this.equalsIfNotNull(this.getParentPath(), that.getParentPath());
        }
        return false;
    }

    public static final class Externalizer
    extends SchematicExternalizer<ClearOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, ClearOperation remove) throws IOException {
            output.writeObject(remove.parentPath);
        }

        public ClearOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            return new ClearOperation(path);
        }

        @Override
        public Integer getId() {
            return 1607;
        }

        @Override
        public Set<Class<? extends ClearOperation>> getTypeClasses() {
            return Collections.singleton(ClearOperation.class);
        }
    }
}

