/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum DurationMetric {
    QUERY_EXECUTION_TIME("query-execution-time", "Query duration", "The metric measuring the amount of time required to execute queries."),
    SESSION_LIFETIME("session-lifetime", "Session duration", "The metric measuring the how long sessions are kept open."),
    SEQUENCER_EXECUTION_TIME("sequencer-execution-time", "Sequencing duration", "The metric measuring how long sequencers take to run and save the changes.");

    private static final Map<String, DurationMetric> BY_LITERAL;
    private static final Map<String, DurationMetric> BY_NAME;
    private final String literal;
    private final String label;
    private final String description;

    private DurationMetric(String literal, String label, String description) {
        this.literal = literal;
        this.label = label;
        this.description = description;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public static DurationMetric fromLiteral(String literal) {
        if (literal == null) {
            return null;
        }
        DurationMetric metric = BY_LITERAL.get(literal = literal.toLowerCase());
        if (metric == null) {
            BY_NAME.get(literal);
        }
        return metric;
    }

    static {
        HashMap<String, DurationMetric> byName = new HashMap<String, DurationMetric>();
        HashMap<String, DurationMetric> byLiteral = new HashMap<String, DurationMetric>();
        for (DurationMetric metric : DurationMetric.values()) {
            byLiteral.put(metric.getLiteral().toLowerCase(), metric);
            byName.put(metric.name().toLowerCase(), metric);
        }
        BY_LITERAL = Collections.unmodifiableMap(byLiteral);
        BY_NAME = Collections.unmodifiableMap(byName);
    }
}

