/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import java.io.UnsupportedEncodingException;
import java.text.StringCharacterIterator;
import java.util.BitSet;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;

@Immutable
public class UrlEncoder
implements TextEncoder,
TextDecoder {
    public static final char ESCAPE_CHARACTER = '%';
    private static final BitSet RFC2396_UNRESERVED_CHARACTERS = new BitSet(256);
    private static final BitSet RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS;
    private static final byte[] BYTES_PER_CHAR;
    private boolean slashEncoded = true;

    @Override
    public String encode(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return text;
        }
        return this.encode(text, this.isSlashEncoded() ? RFC2396_UNRESERVED_CHARACTERS : RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS);
    }

    protected String encode(String text, BitSet safeChars) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char c = iter.first();
        while (c != '\uffff') {
            if (safeChars.get(c)) {
                result.append(c);
            } else {
                try {
                    byte[] utf8Bytes;
                    for (byte utf8Byte : utf8Bytes = Character.toString(c).getBytes("UTF-8")) {
                        result.append('%');
                        int high = (utf8Byte & 0xF0) >> 4;
                        int low = utf8Byte & 0xF;
                        result.append(Integer.toHexString(high));
                        result.append(Integer.toHexString(low));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            c = iter.next();
        }
        return result.toString();
    }

    @Override
    public String decode(String encodedText) {
        if (encodedText == null) {
            return null;
        }
        if (encodedText.length() == 0) {
            return encodedText;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(encodedText);
        byte[] escapedCharBytes = new byte[4];
        int byteIdx = 0;
        int bytesPerChar = -1;
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char hexChar2;
                boolean foundEscapedCharacter = false;
                char hexChar1 = iter.next();
                char c2 = hexChar2 = hexChar1 != '\uffff' ? (char)iter.next() : (char)'\uffff';
                if (hexChar2 != '\uffff') {
                    int hexNum1 = Character.digit(hexChar1, 16);
                    int hexNum2 = Character.digit(hexChar2, 16);
                    if (hexNum1 > -1 && hexNum2 > -1) {
                        foundEscapedCharacter = true;
                        if (bytesPerChar == -1) {
                            bytesPerChar = BYTES_PER_CHAR[hexNum1];
                        }
                        escapedCharBytes[byteIdx++] = (byte)(hexNum1 * 16 + hexNum2);
                        if (byteIdx == bytesPerChar) {
                            try {
                                result.append(new String(escapedCharBytes, 0, bytesPerChar, "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new IllegalStateException(e);
                            }
                            byteIdx = 0;
                            bytesPerChar = -1;
                        }
                    }
                }
                if (!foundEscapedCharacter) {
                    result.append(c);
                    if (hexChar1 != '\uffff') {
                        result.append(hexChar1);
                    }
                    if (hexChar2 != '\uffff') {
                        result.append(hexChar2);
                    }
                }
            } else {
                result.append(c);
            }
            c = iter.next();
        }
        return result.toString();
    }

    public boolean isSlashEncoded() {
        return this.slashEncoded;
    }

    public UrlEncoder setSlashEncoded(boolean slashEncoded) {
        this.slashEncoded = slashEncoded;
        return this;
    }

    static {
        BYTES_PER_CHAR = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 4};
        RFC2396_UNRESERVED_CHARACTERS.set(97, 123);
        RFC2396_UNRESERVED_CHARACTERS.set(65, 91);
        RFC2396_UNRESERVED_CHARACTERS.set(48, 58);
        RFC2396_UNRESERVED_CHARACTERS.set(45);
        RFC2396_UNRESERVED_CHARACTERS.set(95);
        RFC2396_UNRESERVED_CHARACTERS.set(46);
        RFC2396_UNRESERVED_CHARACTERS.set(33);
        RFC2396_UNRESERVED_CHARACTERS.set(126);
        RFC2396_UNRESERVED_CHARACTERS.set(42);
        RFC2396_UNRESERVED_CHARACTERS.set(39);
        RFC2396_UNRESERVED_CHARACTERS.set(40);
        RFC2396_UNRESERVED_CHARACTERS.set(41);
        RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS = (BitSet)RFC2396_UNRESERVED_CHARACTERS.clone();
        RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS.set(47);
    }
}

