CREATE FOREIGN TABLE "Products.brokercustomer" (
    BrokerId string(15) OPTIONS (ANNOTATION '', NAMEINSOURCE '"BrokerId"', NATIVE_TYPE 'VARCHAR'),
    CustomerID string(15) OPTIONS (ANNOTATION '', NAMEINSOURCE '"CustomerID"', NATIVE_TYPE 'VARCHAR')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '"Products"."brokercustomer"', UPDATABLE TRUE);

CREATE FOREIGN TABLE "Products.brokerinformation" (
    BrokerId string(15) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"BrokerId"', NATIVE_TYPE 'VARCHAR'),
    BrokerLastName string(25) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"BrokerLastName"', NATIVE_TYPE 'VARCHAR'),
    BrokerFirstName string(10) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"BrokerFirstName"', NATIVE_TYPE 'VARCHAR')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '"Products"."brokerinformation"', UPDATABLE TRUE);

CREATE FOREIGN TABLE "Products.currencyconversion" (
    ROW_NUM long NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '"ROW_NUM"', NATIVE_TYPE 'INT'),
    EFF_DATE date OPTIONS (ANNOTATION '', NAMEINSOURCE '"EFF_DATE"', NATIVE_TYPE 'DATE'),
    CAN_CAD double NOT NULL DEFAULT '0.00000000' OPTIONS (ANNOTATION '', NAMEINSOURCE '"CAN_CAD"', NATIVE_TYPE 'DOUBLE'),
    UK_GRP double NOT NULL DEFAULT '0.00000000' OPTIONS (ANNOTATION '', NAMEINSOURCE '"UK_GRP"', NATIVE_TYPE 'DOUBLE'),
    EURO double NOT NULL DEFAULT '0.00000000' OPTIONS (ANNOTATION '', NAMEINSOURCE '"EURO"', NATIVE_TYPE 'DOUBLE'),
    JAP_JPY double NOT NULL DEFAULT '0.00000000' OPTIONS (ANNOTATION '', NAMEINSOURCE '"JAP_JPY"', NATIVE_TYPE 'DOUBLE')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '"Products"."currencyconversion"', UPDATABLE TRUE);

CREATE FOREIGN TABLE "Products.product:info" (
    "PRODUCT:ID" bigdecimal(10,2147483647) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"PRODUCT:ID"', NATIVE_TYPE 'DECIMAL'),
    "PRODUCT:NAME" string(250) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"PRODUCT:NAME"', NATIVE_TYPE 'VARCHAR'),
    "PRODUCT:DESCRIPTION" string(80) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"PRODUCT:DESCRIPTION"', NATIVE_TYPE 'VARCHAR')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '"Products"."product:info"', UPDATABLE TRUE);

CREATE FOREIGN TABLE "Products.productdata" (
    INSTR_ID string(10) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"INSTR_ID"', NATIVE_TYPE 'VARCHAR'),
    NAME string(60) OPTIONS (ANNOTATION '', NAMEINSOURCE '"NAME"', NATIVE_TYPE 'VARCHAR'),
    TYPE string(15) OPTIONS (ANNOTATION '', NAMEINSOURCE '"TYPE"', NATIVE_TYPE 'VARCHAR'),
    ISSUER string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '"ISSUER"', NATIVE_TYPE 'VARCHAR'),
    EXCHANGE string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '"EXCHANGE"', NATIVE_TYPE 'VARCHAR'),
    ISDJI bigdecimal(1,2147483647) NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '"ISDJI"', NATIVE_TYPE 'DECIMAL'),
    ISSP500 bigdecimal(1,2147483647) NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '"ISSP500"', NATIVE_TYPE 'DECIMAL'),
    ISNAS100 bigdecimal(1,2147483647) NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '"ISNAS100"', NATIVE_TYPE 'DECIMAL'),
    ISAMEXINT bigdecimal(1,2147483647) NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '"ISAMEXINT"', NATIVE_TYPE 'DECIMAL'),
    PRIBUSINESS string(30) OPTIONS (ANNOTATION '', NAMEINSOURCE '"PRIBUSINESS"', NATIVE_TYPE 'VARCHAR')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '"Products"."productdata"', UPDATABLE TRUE);

CREATE FOREIGN TABLE "Products.productsymbols" (
    INSTR_ID string(10) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"INSTR_ID"', NATIVE_TYPE 'VARCHAR'),
    SYMBOL_TYPE long OPTIONS (ANNOTATION '', NAMEINSOURCE '"SYMBOL_TYPE"', NATIVE_TYPE 'INT'),
    SYMBOL string(10) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '"SYMBOL"', NATIVE_TYPE 'VARCHAR'),
    CUSIP string(20) OPTIONS (ANNOTATION '', NAMEINSOURCE '"CUSIP"', NATIVE_TYPE 'VARCHAR')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '"Products"."productsymbols"', UPDATABLE TRUE);