import java.util.jar.JarEntry
import java.util.jar.JarFile
import java.util.regex.Matcher
import java.util.regex.Pattern

/**
 * Created by jianpli on 6/14/17.
 */

private static void findGAVInJar(File file, String fileName, ArrayList<String> GAV)
{
    if (!file.isDirectory())
    {
        if (file.getName().equals("pom.properties"))
        {
            Properties pomProperties = new Properties()
            pomProperties.load(new BufferedInputStream(new FileInputStream(file)))
            String groupId = pomProperties.getProperty("groupId")
            String artifactId = pomProperties.getProperty("artifactId")
            String version = pomProperties.getProperty("version")

            if (fileName.contains(artifactId))
            {
                GAV.add(groupId)
                GAV.add(artifactId)
                GAV.add(version)
            }
        }
    }else {
        File[] filesInDir = file.listFiles()
        if (filesInDir.length<1)
        {
            return
        }
        for (File aFile : filesInDir)
        {
            findGAVInJar(aFile,fileName,GAV)
        }
    }
}

private static void findGAVInWhiteList(Properties whiteList, String jarName, ArrayList<String> GAV)
{
    /*find GAV by jar name in the white list first*/
    String GAVStr
    GAVStr = whiteList.getProperty(jarName)

    String patternStr = "(<dependency><groupId>)(.*)"
    patternStr += "(</groupId><artifactId>)(.*)"
    patternStr += "(</artifactId><version>)(.*)"
    patternStr += "(</version>)(<classifier>(.*)</classifier>)?"
    patternStr += "(<exclusions><exclusion><groupId>\\*</groupId><artifactId>\\*</artifactId></exclusion></exclusions></dependency>)(.*)"

    if (GAVStr != null)
    {
        Pattern xmlPattern = Pattern.compile(patternStr)
        Matcher xmlMatcher = xmlPattern.matcher(GAVStr)

        if (xmlMatcher.find())
        {
            GAV.add(xmlMatcher.group(2))
            GAV.add(xmlMatcher.group(4))
            GAV.add(xmlMatcher.group(6))
            if (xmlMatcher.group(8)!=null)
            {
                GAV.add(xmlMatcher.group(8))
            }
        }
    }
}

private static void parseGAVByJarName(Properties A_VList, String jarName, ArrayList<String> GAV)
{
    Pattern AVPattern_1 = Pattern.compile("(.+)(-)((\\d+\\.)+\\d+.*)(\\.jar)")
    Pattern AVPattern_2 = Pattern.compile("(.+)(-)(\\d+.*)(\\.jar)")
    Matcher AVMatcher_1 = AVPattern_1.matcher(jarName)
    Matcher AVMatcher_2 = AVPattern_2.matcher(jarName)

    Matcher AVMatcher
    if (AVMatcher_1.find())
    {
        AVMatcher = AVMatcher_1
    }else if(AVMatcher_2.find())
    {
        AVMatcher = AVMatcher_2
    }else {
        AVMatcher = null
    }

    if (AVMatcher != null)
    {
        String groupId
        String artifactId = AVMatcher.group(1)
        String version = AVMatcher.group(3)

        GAV.add("")
        GAV.add(artifactId)
        GAV.add(version)

        try {
            groupId = A_VList.getProperty(artifactId)
        } catch (MissingPropertyException e2) {
            println "can not find artifactId '" + artifactId + "' in white list for --> " + jarName
        }
        if (groupId != null)
        {
            GAV.set(0,groupId)
        }
    } else {
        println "can not parse artifactId and version by jar name for --> " + jarName
    }
}

private static void decompress(JarFile jarFile, File targetFile)
{
    for (Enumeration<JarEntry> jarEntries = jarFile.entries();jarEntries.hasMoreElements();)
    {
        JarEntry aJarEntry = (JarEntry)jarEntries.nextElement()
        File aJarEntryFile = new File(targetFile.getPath()+"/"+aJarEntry.getName())
        if (aJarEntry.isDirectory())
        {
            aJarEntryFile.mkdirs()
        }else{
            aJarEntryFile.getParentFile().mkdirs()
            aJarEntryFile.createNewFile()
            InputStream inputStream = jarFile.getInputStream(aJarEntry)
            OutputStream outputStream = new BufferedOutputStream(new FileOutputStream(aJarEntryFile))
            byte[] buffer = new byte[2048]
            int nBytes
            while ((nBytes = inputStream.read(buffer)) > 0)
            {
                outputStream.write(buffer,0,nBytes)
            }
            outputStream.flush()
            outputStream.close()
            inputStream.close()
        }
    }
}


private static void deleteFiles(File file)
{
    if (!file.isDirectory())
    {
        file.delete()
    }else
    {
        File[] filesInDir = file.listFiles()
        if (filesInDir.length>0)
        {
            for (File aFile : filesInDir)
            {
                deleteFiles(aFile)
            }
        }
        file.delete()
    }
}

println "************************************* Start to Jar Analyzer *****************************************************"

String jarsPath = project.build.directory + "/" + project.properties['unzip.dir']

Properties whiteList = new Properties()
whiteList.load(new FileInputStream("src/main/resources/special_situations_white_list.properties"))

Properties excludeList = new Properties()
excludeList.load(new FileInputStream("src/main/resources/exclude_list.properties"))


Properties A_GList = new Properties()
A_GList.load(new FileInputStream("src/main/resources/A_G_relation_white_list.properties"))

ArrayList<String> GAVList = new ArrayList<>()
ArrayList<String> jarListOrigin = new ArrayList<>()
ArrayList<String> runtimeGAVList = new ArrayList<>()
ArrayList<String> jarListNonMaven = new ArrayList<>()
ArrayList<String> jarListNoGAV = new ArrayList<>()
ArrayList<String> artifactListNoGAV = new ArrayList<>()
ArrayList<String> jarListNameCannotParse = new ArrayList<>()
HashSet<String> GAVSet = new HashSet<>()
HashMap<Integer,ArrayList<Integer>> dupGAVMap = new HashMap<>()

File jarsDir = new File(jarsPath)
if (jarsDir.isDirectory())
{
    File[] jars = jarsDir.listFiles(new FilenameFilter() {
        @Override
        boolean accept(File dir, String name) {
            return name.endsWith(".jar")
        }
    })

    for (int i=0;i<jars.length;i++)
    {
        if (i == (jars.size()/4 as int))
        {
            println "info ---> finished 25% ..."
        }else if (i == (jars.size()/2 as int))
        {
            println "info ---> finished 50% ..."
        }else if (i == (jars.size()*3/4 as int))
        {
            println "info ---> finished 75% ..."
        }

        File jar = jars[i]

        jarListOrigin.add(jar.getName())

        File unzipFile = new File(jarsPath+"/temp/"+jar.getName()+"_unzip")
        if (!unzipFile.exists())
        {
            unzipFile.mkdir()
        }
        decompress(new JarFile(jar),unzipFile)

        /*thisGAV record this jar's GroupId, ArtifactId, Version, for some special situation, it still can record the classifier
        * thisGAV.get(0) record the GroupId
        * thisGAV.get(1) record the ArtifactId
        * thisGAV.get(2) record the Version
        * thisGAV.get(3) record the classifier
        * */
        ArrayList<String> thisGAV = new ArrayList<>()

        findGAVInWhiteList(whiteList,jar.getName(),thisGAV)
        if (thisGAV.size()!=0)
        {
            ArrayList<String> tempGAV = new ArrayList<>()
            findGAVInJar(unzipFile,jar.getName(),tempGAV)
            if (tempGAV.size()==0)
            {
                jarListNonMaven.add(jar.getName())
            }
        }else {
            findGAVInJar(unzipFile,jar.getName(),thisGAV)
            if (thisGAV.size()==0) {
                jarListNonMaven.add(jar.getName())
                parseGAVByJarName(A_GList, jar.getName(), thisGAV)
                if (thisGAV.size() == 0){
                    jarListNameCannotParse.add(jar.getName())
                    jarListNoGAV.add(jar.getName())
                }else if (thisGAV.get(0).equals("")){
                    artifactListNoGAV.add(thisGAV.get(1))
                    jarListNoGAV.add(jar.getName())
                }
            }
        }

        if (thisGAV.size()>0 && !thisGAV.get(0).equals(""))
        {
	    if (excludeList.containsKey(thisGAV.get(1)) )
		{
			String GRPStr
    			GRPStr = excludeList.getProperty(thisGAV.get(1))

			if (GRPStr != null && GRPStr.equals(thisGAV.get(0)))
			{
				 println "=== EXCLUDING groupID:" + GRPStr + "  artifactID: " + thisGAV.get(1)
				GAVList.add("")
				continue
			}


		} 

            String GAVXmlStr = "<dependency><groupId>" + thisGAV.get(0) + "</groupId><artifactId>"+ thisGAV.get(1) + "</artifactId><version>"+ thisGAV.get(2)
            GAVXmlStr += "</version><exclusions><exclusion><groupId>*</groupId><artifactId>*</artifactId></exclusion></exclusions></dependency>"
            GAVList.add(GAVXmlStr)

            if (thisGAV.size()==3)
            {
                runtimeGAVList.add(thisGAV.get(0)+":"+thisGAV.get(1)+":"+thisGAV.get(2)+":jar")
            }else if (thisGAV.size()==4)
            {
                runtimeGAVList.add(thisGAV.get(0)+":"+thisGAV.get(1)+":"+thisGAV.get(2)+":"+thisGAV.get(3)+":jar")
            }
        }else {
            GAVList.add("")
        }
    }

    for (int i=0;i<GAVList.size();i++)
    {
        String aGAV = GAVList.get(i)
        if (!aGAV.equals(""))
        {
            if (GAVSet.contains(aGAV))
            {
                if (dupGAVMap.containsKey(GAVList.indexOf(aGAV)))
                {
                    dupGAVMap.get(GAVList.indexOf(aGAV)).add(i)
                }else {
                    ArrayList<Integer> temp = new ArrayList<>()
                    temp.add(i)
                    dupGAVMap.put(GAVList.indexOf(aGAV),temp)
                }
            }
            GAVSet.add(aGAV)
        }
    }

    StringBuilder the_list = new StringBuilder()
    for (String gav : GAVSet)
    {
        the_list.append(gav);
    }
    project.properties['jdv_dependency_list'] = the_list.toString();

    File jar_list_origin = new File(jarsPath+"/../record/jar_list_origin")
    if (!jar_list_origin.getParentFile().exists())
    {
        jar_list_origin.getParentFile().mkdirs()
    }
    jar_list_origin.createNewFile()
    FileWriter jar_list_origin_writer = new FileWriter(jar_list_origin)
	Collections.sort(jarListOrigin)
    for (String ajarName : jarListOrigin)
    {
        jar_list_origin_writer.write(ajarName+"\n")
    }
    jar_list_origin_writer.flush()
    jar_list_origin_writer.close()

    File runtime_GAV_list = new File(jarsPath+"/../record/jboss-jdv-"+project.version+"-runtime-GAVs.txt")
    runtime_GAV_list.createNewFile()
    Collections.sort(runtimeGAVList)
    FileWriter runtime_GAV_list_writer = new FileWriter(runtime_GAV_list)
    for (String aRuntimeGAV : runtimeGAVList)
    {
        runtime_GAV_list_writer.write(aRuntimeGAV+"\n")
    }
    runtime_GAV_list_writer.flush()
    runtime_GAV_list_writer.close()

    File jar_list_non_maven = new File(jarsPath+"/../record/jar_list_non_maven")
    jar_list_non_maven.createNewFile()
    FileWriter jar_list_non_maven_writer = new FileWriter(jar_list_non_maven)
    Collections.sort(jarListNonMaven)
    for (String aJarName : jarListNonMaven)
    {
        jar_list_non_maven_writer.write(aJarName+"\n")
    }
    jar_list_non_maven_writer.flush()
    jar_list_non_maven_writer.close()

    File jar_list_no_GAV = new File(jarsPath+"/../record/jar_list_no_GAV")
    jar_list_no_GAV.createNewFile()
    FileWriter jar_list_no_GAV_writer = new FileWriter(jar_list_no_GAV)
    Collections.sort(jarListNoGAV)
    for (String aJarName : jarListNoGAV)
    {
        jar_list_no_GAV_writer.write(aJarName+"\n")
    }
    jar_list_no_GAV_writer.flush()
    jar_list_no_GAV_writer.close()

    File artifact_list_no_GAV = new File(jarsPath+"/../record/artifact_list_no_GAV")
    artifact_list_no_GAV.createNewFile()
    FileWriter artifact_list_no_GAV_writer = new FileWriter(artifact_list_no_GAV)
    Collections.sort(artifactListNoGAV)
    for (String aArtifact : artifactListNoGAV)
    {
        artifact_list_no_GAV_writer.write(aArtifact+"\n")
    }
    artifact_list_no_GAV_writer.flush()
    artifact_list_no_GAV_writer.close()

    File jar_list_name_cannot_parse = new File(jarsPath+"/../record/jar_list_name_cannot_parse")
    jar_list_name_cannot_parse.createNewFile()
    FileWriter jar_list_name_cannot_parse_writer = new FileWriter(jar_list_name_cannot_parse)
    Collections.sort(jarListNameCannotParse)
    for(String aJarName : jarListNameCannotParse)
    {
        jar_list_name_cannot_parse_writer.write(aJarName+"\n")
    }
    jar_list_name_cannot_parse_writer.flush()
    jar_list_name_cannot_parse_writer.close()

    File jar_list_duplicate_GAV = new File(jarsPath+"/../record/jar_list_duplicate_GAV")
    jar_list_duplicate_GAV.createNewFile()
    FileWriter jar_list_duplicate_GAV_writer = new FileWriter(jar_list_duplicate_GAV)
    for (Map.Entry entry : dupGAVMap.entrySet())
    {
        jar_list_duplicate_GAV_writer.write("#duplicate GAV with \""+jars[Integer.parseInt(entry.getKey().toString())].getName()+"\":\n")
        for (Integer aIndex : (ArrayList<Integer>)entry.getValue())
        {
            jar_list_duplicate_GAV_writer.write(jars[aIndex].getName()+"\n")
        }
        jar_list_duplicate_GAV_writer.write("\n")
    }
    jar_list_duplicate_GAV_writer.flush()
    jar_list_duplicate_GAV_writer.close()


    File info_for_junit = new File(jarsPath+"/../record/info_for_junit")
    info_for_junit.createNewFile()
    FileWriter info_for_junit_writer = new FileWriter(info_for_junit)
    info_for_junit_writer.write("jarsCount=" + GAVSet.size() + "\n")
    info_for_junit_writer.flush()
    info_for_junit_writer.close()
}

println "-------------------------------------------"

println "total of dependencies: " + jarListOrigin.size()
println "parse unsuccessfully: " + jarListNoGAV.size()
println "count of GAV: " + GAVSet.size()
println "count of jars have duplicate GAV: " + (GAVList.size()-GAVSet.size())
println "count of dependencies non maven: " + jarListNonMaven.size()
println "count of dependencies name cannot parse: "+ jarListNameCannotParse.size()

println "-------------------------------------------"

println "************************************* End of parsing jar *****************************************************"
