#!/bin/bash

# Absolute path to this script, e.g. /home/user/xxx/infoRlease.sh
SCRIPT="$(cd $(dirname "$0") && pwd)/$(basename "$0")"
# Absolute path this script is in, thus /home/user/xxx
scriptDir=$(dirname "$SCRIPT")


if [ $# != 3 ] ; then
    echo
    echo "Usage:"
    echo "  $0 tagName targetProdBuild cutOffDate"
    echo "For example:"
    echo "  $0 3.8.x-prod-ip6.2-ER1 2015-04-27"
    echo
    exit 1
fi

productTag=$1
targetProdBuild=$2
cutOffDate=$3

echo "The tag name is: $productTag"
echo "The target product build is: $targetProdBuild"
echo "The cutoff date is: $cutOffDate"
echo -n "Is this ok? (Hit control-c if is not): "
read ok

cd $scriptDir

if [ ! -d "../reports" ]; then
	mkdir ../reports
fi

# name of file to be written and pushed  
fileToWrite=reports/$productTag.txt

#COMPILE_DEPS=$(mvn -f ../modeshape-distribution/pom.xml dependency:tree | grep -v "test" | grep "INFO")
VERSION=$(head ../pom.xml | grep version | tr -d ' \t\n<version/>')
CONTACTS="modeshape                 hchiorea@redhat.com"
REPOSITORIES="https://github.com/jboss-integration/modeshape/tree/"$(echo $productTag) 
MAVEN=$(mvn -version | head -1)
BLDCOMMAND="mvn -s ./settings.xml clean install -Passembly -DskipTests"
# JAVA version as it needs a workaround
java -version 2>>javaVersion.txt
JAVAV=$(cat javaVersion.txt)
rm javaVersion.txt
DATETIME=`date +%F-%H:%M`

cat <<EOF >../$fileToWrite

------------------------------------------------------------------------
          ModeShape (DV) Engineering to Productization Handoff Report
------------------------------------------------------------------------
Report Date: $DATETIME
Code Cutoff Date: $cutOffDate
Target Product Build: $targetProdBuild
Source Product Tag: $productTag

Product Page: 
https://pp.engineering.redhat.com/pp/product/eds/overview

-----------------------------------------------------------------------  
                     Component owners contacts                           
------------------------------------------------------------------------
$CONTACTS

------------------------------------------------------------------------
                          Build Tools                               
------------------------------------------------------------------------
JAVA: 
$JAVAV

MAVEN: 
$MAVEN

------------------------------------------------------------------------
                       Environment variables
------------------------------------------------------------------------ 

MAVEN_OPTS:
-Xmx1524m

------------------------------------------------------------------------
                        Sources to build                         
------------------------------------------------------------------------
$REPOSITORIES

------------------------------------------------------------------------
                          Build Commands
------------------------------------------------------------------------

$BLDCOMMAND

------------------------------------------------------------------------  
             Build artifacts for product (based on EAP 6.4.4)                       
------------------------------------------------------------------------

- (Rest Client & JDBC Driver) modeshape-client/target/modeshape-client-$VERSION.zip
  
  should be unpacked into the dataVirtualization folder on the server
   
  includes:

    -	jdbc
    -	rest-client
	
- (DV Kit)  modeshape-distribution/target/modeshape-$VERSION-jbosseap-dist.zip
	 
  includes:

    -	cli-scripts
    -	docs
    -	modules
		
- (JavaDoc) modeshape-distribution/target/modeshape-$VERSION-javadoc.zip
  	
  delivered as part of DV javadocs 

------------------------------------------------------------------------  
                               Notes                       
------------------------------------------------------------------------

************
ER2
************

ModeShape now delivers as part of its kit 2 CLI scripts: ModeShape-standalone.cli and ModeShape-domain.cli for installing
ModeShape into DV.

These scripts will only install the ModeShape related bits, so any Teiid bits that use ModeShape (for example 
deploy dataVirtualization/vdb/ModeShape.vdb) should be run after running these scripts first

************
JDV 6.3.4
************

Starting with this patch, ModeShape delivers a tool for publishing artifacts. This tool is comprised of a couple of scripts
together with a JAR that calls the ModeShape REST service deployed on the server. The entire tool is delivered via modeshape-client
alongside the JDBC driver

EOF