/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.dna.common.util.CheckArg;

public class SecureHash {
    public static byte[] getHash(Algorithm algorithm, byte[] content) throws NoSuchAlgorithmException {
        CheckArg.isNotNull((Object)algorithm, "algorithm");
        return SecureHash.getHash(algorithm.digestName(), content);
    }

    public static byte[] getHash(Algorithm algorithm, File file) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull((Object)algorithm, "algorithm");
        return SecureHash.getHash(algorithm.digestName(), file);
    }

    public static byte[] getHash(Algorithm algorithm, InputStream stream) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull((Object)algorithm, "algorithm");
        return SecureHash.getHash(algorithm.digestName(), stream);
    }

    public static byte[] getHash(String digestName, byte[] content) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(digestName);
        assert (digest != null);
        return digest.digest(content);
    }

    public static byte[] getHash(String digestName, File file) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull(file, "file");
        MessageDigest digest = MessageDigest.getInstance(digestName);
        assert (digest != null);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        boolean error = false;
        try {
            int bufSize = 1024;
            byte[] buffer = new byte[bufSize];
            int n = ((InputStream)in).read(buffer, 0, bufSize);
            int count = 0;
            while (n != -1) {
                count += n;
                digest.update(buffer, 0, n);
                n = ((InputStream)in).read(buffer, 0, bufSize);
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        finally {
            block12: {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    if (error) break block12;
                    throw e;
                }
            }
        }
        return digest.digest();
    }

    public static byte[] getHash(String digestName, InputStream stream) throws NoSuchAlgorithmException, IOException {
        CheckArg.isNotNull(stream, "stream");
        MessageDigest digest = MessageDigest.getInstance(digestName);
        assert (digest != null);
        int bufSize = 1024;
        byte[] buffer = new byte[bufSize];
        int n = stream.read(buffer, 0, bufSize);
        int count = 0;
        while (n != -1) {
            count += n;
            digest.update(buffer, 0, n);
            n = stream.read(buffer, 0, bufSize);
        }
        return digest.digest();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        MD2("MD2", "The MD2 message digest algorithm as defined in RFC 1319"),
        MD5("MD5", "The MD5 message digest algorithm as defined in RFC 1321"),
        SHA_1("SHA-1", "The Secure Hash Algorithm, as defined in Secure Hash Standard, NIST FIPS 180-1"),
        SHA_256("SHA-256", "New hash algorithms for which the draft Federal Information Processing Standard 180-2, Secure Hash Standard (SHS) is now available.  SHA-256 is a 256-bit hash function intended to provide 128 bits of security against collision attacks."),
        SHA_384("SHA-384", "New hash algorithms for which the draft Federal Information Processing Standard 180-2, Secure Hash Standard (SHS) is now available.  A 384-bit hash may be obtained by truncating the SHA-512 output."),
        SHA_512("SHA-512", "New hash algorithms for which the draft Federal Information Processing Standard 180-2, Secure Hash Standard (SHS) is now available.  SHA-512 is a 512-bit hash function intended to provide 256 bits of security.");

        private String name;
        private String description;

        private Algorithm(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String digestName() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public String toString() {
            return this.digestName();
        }
    }
}

