/*
 * ModeShape (http://www.modeshape.org)
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * See the AUTHORS.txt file in the distribution for a full listing of 
 * individual contributors.
 *
 * ModeShape is free software. Unless otherwise indicated, all code in ModeShape
 * is licensed to you under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * ModeShape is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.modeshape.jcr.cache.change;

import java.util.Set;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

/**
 * 
 */
public class NodeRemoved extends AbstractNodeChange {

    private static final long serialVersionUID = 1L;

    private final NodeKey parentKey;
    private final Name parentPrimaryType;
    private final Set<Name> parentMixinTypes;

    public NodeRemoved( NodeKey key,
                        NodeKey parentKey,
                        Path path,
                        Name parentPrimaryType,
                        Set<Name> parentMixinTypes) {
        super(key, path);
        this.parentKey = parentKey;
        this.parentPrimaryType = parentPrimaryType;
        this.parentMixinTypes = parentMixinTypes;
    }

    /**
     * Get the key for the parent under which the new node was added.
     *
     * @return the key for the parent; never null
     */
    public NodeKey getParentKey() {
        return parentKey;
    }

    /**
     * Get the name of the primary type of the parent node.
     *
     * @return either the {@link Name} of the parent node or {@code null} if this information was not available.
     */
    public Name getParentPrimaryType() {
        return parentPrimaryType;
    }

    /**
     * Get the mixin names of the parent node.
     *
     * @return either the {@link Set} of mixins or {@code null} if this information was not available.
     */
    public Set<Name> getParentMixinTypes() {
        return parentMixinTypes;
    }

    @Override
    public String toString() {
        return "Removed node '" + this.getKey() + "' at \"" + path + "\" from under " + parentKey;
    }
}
