"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const Listrq = require("listr");
const che_1 = require("../../api/che");
const common_flags_1 = require("../../common-flags");
const che_2 = require("../../tasks/che");
const api_1 = require("../../tasks/platforms/api");
class List extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(List);
            const ctx = {};
            ctx.workspaces = [];
            const apiTasks = new api_1.ApiTasks();
            const cheTasks = new che_2.CheTasks(flags);
            const tasks = new Listrq(undefined, { renderer: 'silent' });
            tasks.add(apiTasks.testApiTasks(flags, this));
            tasks.add(cheTasks.verifyCheNamespaceExistsTask(flags, this));
            tasks.add(cheTasks.retrieveEclipseCheUrl(flags));
            tasks.add(cheTasks.checkEclipseCheStatus());
            tasks.add({
                title: 'Get workspaces',
                task: (ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const cheHelper = new che_1.CheHelper(flags);
                    ctx.workspaces = yield cheHelper.getAllWorkspaces(ctx.cheURL, flags['access-token']);
                    task.title = `${task.title}... done`;
                })
            });
            try {
                yield tasks.run(ctx);
                this.printWorkspaces(ctx.workspaces);
            }
            catch (error) {
                this.error(error.message);
            }
        });
    }
    printWorkspaces(workspaces) {
        const data = [];
        workspaces.forEach((workspace) => {
            data.push({
                id: workspace.id,
                name: workspace.devfile.metadata.name,
                namespace: workspace.attributes.infrastructureNamespace,
                status: workspace.status,
                created: new Date(parseInt(workspace.attributes.created, 10)).toISOString(),
                updated: workspace.attributes.updated ? new Date(parseInt(workspace.attributes.updated, 10)).toISOString() : ''
            });
        });
        cli_ux_1.cli.table(data, { id: {}, name: {}, namespace: {}, status: {}, created: {}, updated: {} });
    }
}
exports.default = List;
List.description = 'list workspaces';
List.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    'access-token': common_flags_1.accessToken,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck
};
//# sourceMappingURL=list.js.map