package org.jbpm.gd.jpdl.model;


public class Node extends AbstractNode {

	private AbstractJpdlElement actionElement;

	public void setAction(Action newActionElement) {
		AbstractJpdlElement oldActionElement = actionElement;
		actionElement = newActionElement;
		firePropertyChange("action", oldActionElement, newActionElement);
	}
	
	public Action getAction() {
		if (actionElement instanceof Action) {
			return (Action)actionElement;
		}
		return null;
	}
	
	public void setScript(Script newActionElement) {
		AbstractJpdlElement oldActionElement = actionElement;
		actionElement = newActionElement;
		firePropertyChange("script", oldActionElement, newActionElement);
	}
	
	public Script getScript() {
		if (actionElement instanceof Script) {
			return (Script)actionElement;
		}
		return null;
	}

	public void setCreateTimer(CreateTimer newActionElement) {
		AbstractJpdlElement oldActionElement = actionElement;
		actionElement = newActionElement;
		firePropertyChange("createTimer", oldActionElement, newActionElement);
	}
	
	public CreateTimer getCreateTimer() {
		if (actionElement instanceof CreateTimer) {
			return (CreateTimer)actionElement;
		}
		return null;
	}

	public void setCancelTimer(CancelTimer newActionElement) {
		AbstractJpdlElement oldActionElement = actionElement;
		actionElement = newActionElement;
		firePropertyChange("cancelTimer", oldActionElement, newActionElement);
	}
	
	public CancelTimer getCancelTimer() {
		if (actionElement instanceof CancelTimer) {
			return (CancelTimer)actionElement;
		}
		return null;
	}

	public void setMail(Mail newActionElement) {
		AbstractJpdlElement oldActionElement = actionElement;
		actionElement = newActionElement;
		firePropertyChange("mail", oldActionElement, newActionElement);
	}
	
	public Mail getMail() {
		if (actionElement instanceof Mail) {
			return (Mail)actionElement;
		}
		return null;
	}

}
