package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.TaskNode;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.Transition;

public class TaskNodeDomAdapter extends JpdlElementDomAdapter {
	
	private static final String[] CHILD_ELEMENTS = {"task", "event", "exception-handler", "timer", "transition"};
	private static HashMap NODE_TYPES = null;
	
	protected String[] getChildElements() {
		return CHILD_ELEMENTS;
	}
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("task", "task");
			NODE_TYPES.put("event", "event");
			NODE_TYPES.put("exception-handler", "exception-handler");
			NODE_TYPES.put("timer", "timer");
			NODE_TYPES.put("transition", "transition");
		}
		return NODE_TYPES;
	}
	
	protected void initialize() {
		super.initialize();
		TaskNode taskNode = (TaskNode)getJpdlElement();
		if (taskNode != null) {
			setAttribute("async", taskNode.getAsync());
			setAttribute("name", taskNode.getName());
			setAttribute("signal", taskNode.getSignal());
			setAttribute("create-tasks", taskNode.getCreateTasks());
			setAttribute("end-tasks", taskNode.getEndTasks());
			addElements(taskNode.getTasks());
			addElements(taskNode.getEvents());
			addElements(taskNode.getExceptionHandlers());
			addElements(taskNode.getTimers());
			addElements(taskNode.getTransitions());
		}
	}

	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		TaskNode taskNode = (TaskNode)jpdlElement;
		taskNode.setAsync(getAttribute("async"));
		taskNode.setName(getAttribute("name"));
		taskNode.setSignal(getAttribute("signal"));
		taskNode.setCreateTasks(getAttribute("create-tasks"));
		taskNode.setEndTasks(getAttribute("end-tasks"));
		taskNode.addPropertyChangeListener(this);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("taskAdd".equals(evt.getPropertyName())) {
			addElement((Task)evt.getNewValue());
		} else if ("taskRemove".equals(evt.getPropertyName())) {
			removeElement((Task)evt.getOldValue());
		} else if ("timerAdd".equals(evt.getPropertyName())) {
			addElement((Event)evt.getNewValue());
		} else if ("timerRemove".equals(evt.getPropertyName())) {
			removeElement((Timer)evt.getOldValue());
		} else if ("eventAdd".equals(evt.getPropertyName())) {
			addElement((Event)evt.getNewValue());
		} else if ("eventRemove".equals(evt.getPropertyName())) {
			removeElement((Event)evt.getOldValue());
		} else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
			addElement((ExceptionHandler)evt.getNewValue());
		} else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
			removeElement((ExceptionHandler)evt.getOldValue());
		} else if ("transitionAdd".equals(evt.getPropertyName())) {
			addElement((Transition)evt.getNewValue());
		} else if ("transitionRemove".equals(evt.getPropertyName())) {
			removeElement((Transition)evt.getOldValue());
		} else if ("createTasks".equals(evt.getPropertyName())) {
			setAttribute("create-tasks", (String)evt.getNewValue()); 
		} else if ("endTasks".equals(evt.getPropertyName())) {
			setAttribute("end-tasks", (String)evt.getNewValue());
		} else if ("signal".equals(evt.getPropertyName())) {
			setAttribute("signal", (String)evt.getNewValue());
		} else if ("async".equals(evt.getPropertyName())) {
			setAttribute("async", (String)evt.getNewValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		}
	}

	protected void doModelUpdate(String name, String newValue) {
		TaskNode taskNode = (TaskNode)getJpdlElement();
		if ("name".equals(name)) {
			taskNode.setName(newValue);
		} else if ("async".equals(name)) {
			taskNode.setAsync(newValue);
		} else if ("signal".equals(name)) {
			taskNode.setSignal(newValue);
		} else if ("end-tasks".equals(name)) {
			taskNode.setEndTasks(newValue);
		} else if ("create-tasks".equals(name)) {
			taskNode.setCreateTasks(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		TaskNode taskNode = (TaskNode)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(type);
		child.initialize(jpdlElement);
//		child.register();
		if ("event".equals(type)) {
			taskNode.addEvent((Event)jpdlElement);
		} else if ("exception-handler".equals(type)) {
			taskNode.addExceptionHandler((ExceptionHandler)jpdlElement);
		} else if ("timer".equals(type)) {
			taskNode.addTimer((Timer)jpdlElement);
		} else if ("transition".equals(type)) {
			taskNode.addTransition((Transition)jpdlElement);
		} else if ("task".equals(type)) {
			taskNode.addTask((Task)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		TaskNode taskNode = (TaskNode)getJpdlElement();
		if ("event".equals(type)) {
			taskNode.removeEvent((Event)child.getJpdlElement());
		} else if ("exception-handler".equals(type)) {
			taskNode.removeExceptionHandler((ExceptionHandler)child.getJpdlElement());
		} else if ("timer".equals(type)) {
			taskNode.removeTimer((Timer)child.getJpdlElement());
		} else if ("transition".equals(type)) {
			taskNode.removeTransition((Transition)child.getJpdlElement());
		} else if ("task".equals(type)) {
			taskNode.removeTask((Task)child.getJpdlElement());
		}
	}

}