/******************************************************************************* 
 * Copyright (c) 2007 Red Hat, Inc. 
 * Distributed under license by Red Hat, Inc. All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 ******************************************************************************/ 

package com.jboss.jbds.installer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import junit.framework.TestCase;

import com.jboss.jbds.installer.ServerListPanel.ValidationResult;
import com.jboss.jbds.installer.ServerListPanel.Validator;
import com.jboss.jbds.installer.bean.ServerBean;
import com.jboss.jbds.installer.bean.ServerBeanLoader;
import com.jboss.jbds.installer.bean.ServerType;

/**
 * @author eskimo
 *
 */
public class ValidatorTest extends TestCase {
	Validator validator = new Validator();
	ServerBeanLoader loader = new ServerBeanLoader(); 
	/**
	 * Test method for {@link com.jboss.jbds.installer.ServerListPanel.Validator#validate(com.jboss.jbds.installer.bean.ServerBean, java.util.List)}.
	 */
	public void testValidate() {
		ServerBean defaultBean = loader.loadFromLoaction(CommonTestData.AS_3_2_8_SP1);
		ServerBean bean = loader.loadFromLoaction(CommonTestData.AS_3_2_8_SP1);
		bean.setType(ServerType.EAP);
		bean.setVersion(ServerType.EAP.getVersions()[0]);
		ValidationResult result = validator.validate(defaultBean,bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.WARNING);
		assertTrue(result.getMessageKey().equals(Validator.WARN_SERVER_TYPE_VERSION_DONT_MATCH));
		
		bean.setType(defaultBean.getType());
		bean.setVersion(ServerType.EAP.getVersions()[0]);
		result = validator.validate(defaultBean,bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.WARNING);
		assertTrue(result.getMessageKey().equals(Validator.WARN_SERVER_VERSION_DONT_MATCH));
		
		bean.setType(ServerType.EAP);
		bean.setVersion(defaultBean.getVersion());
		result = validator.validate(defaultBean,bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.ERROR);
		assertTrue(result.getMessageKey().equals(Validator.ERR_SERVER_VERSION_IS_NOT_SUPPORTED));

		
		defaultBean = loader.loadFromLoaction(CommonTestData.SOAP_4_3_0_GA);
		bean = loader.loadFromLoaction(CommonTestData.EAP_4_3_0_GA_CP1);
		bean.setType(ServerType.SOAP);
		result = validator.validate(defaultBean, bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.WARNING);
		assertTrue(result.getMessageKey().equals(Validator.WARN_SERVER_TYPE_DONT_MATCH));
		
		defaultBean = loader.loadFromLoaction(CommonTestData.UNKNOWN_SERVER);
		bean = loader.loadFromLoaction(CommonTestData.UNKNOWN_SERVER);
		result = validator.validate(defaultBean,bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.OK);
		assertTrue(result.getMessageKey().equals(Validator.OK_EDIT_DEFAULT));
		
		bean.setType(ServerType.SOAP);
		result = validator.validate(defaultBean,bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.ERROR);
		assertTrue(result.getMessageKey().equals(Validator.ERR_SERVER_VERSION_IS_NOT_SELECTED));
		
		bean.setVersion(ServerType.AS.getVersions()[0]);
		result = validator.validate(defaultBean,bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.ERROR);
		assertTrue(result.getMessageKey().equals(Validator.ERR_SERVER_VERSION_IS_NOT_SUPPORTED));
		
		bean.setVersion(ServerType.SOAP.getVersions()[0]);
		result = validator.validate(defaultBean,bean, Collections.EMPTY_LIST);
		assertTrue(result.getSeverety()==ValidationResult.WARNING);
		assertTrue(result.getMessageKey().equals(Validator.WARN_SERVER_UNKNOWN));
		
		List<ServerBean> servers = new ArrayList<ServerBean>();
		bean = loader.loadFromLoaction(CommonTestData.AS_3_2_8_SP1);
		servers.add(bean);
		result = validator.validate(defaultBean,bean, servers);
		assertTrue(result.getSeverety()==ValidationResult.ERROR);
		assertTrue(result.getMessageKey().equals(Validator.ERR_SERVER_NAME_IS_ALREADY_USED));
	}

}
