/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.jst.jsp.editor.ITextFormatter;
import org.jboss.tools.jst.jsp.selection.SourceSelection;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.dnd.VpeDnDHelper;
import org.jboss.tools.vpe.editor.VpeSourceDropInfo;
import org.jboss.tools.vpe.editor.VpeSourceInnerDragInfo;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeBreackerHelper;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeDefaultPseudoContentCreator;
import org.jboss.tools.vpe.editor.template.VpeEmptyPseudoContentCreator;
import org.jboss.tools.vpe.editor.template.VpeHtmlPseudoContentCreator;
import org.jboss.tools.vpe.editor.template.VpePseudoContentCreator;
import org.jboss.tools.vpe.editor.template.VpeTagDescription;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTextPseudoContentCreator;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.resize.VpeResizer;
import org.jboss.tools.vpe.editor.template.textformating.TextFormatingData;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.VpeNodesManagingUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class VpeAbstractTemplate
implements VpeTemplate {
    protected boolean caseSensitive;
    protected boolean children;
    protected boolean modify;
    protected boolean hasImaginaryBorder;
    protected boolean invisible;
    private VpeResizer resizer;
    private VpeDnDHelper dragger;
    private TextFormatingData textFormatingData;
    private VpePseudoContentCreator pseudoContentCreator;
    private static final String TAG_BREAKER = "vpe:breaker";
    private static final String ATTR_BREAKER_TYPE = "type";
    private static final String ATTR_BREAKER_TYPE_IGNORE = "ignore";
    private static final String ATTR_BREAKER_TYPE_SELECTITEM = "selectItem";
    private static final int BREAKER_TYPE_NONE = 0;
    private static final int BREAKER_TYPE_IGNORE = 1;
    private static final int BREAKER_TYPE_SELECTITEM = 2;
    private static final String TAG_PSEUDOCONTENT = "vpe:pseudoContent";
    private static final String ATTR_PSEUDOCONTENT_DEFAULTTEXT = "defaultText";
    private static final String ATTR_PSEUDOCONTENT_ATTRNAME = "attrName";
    private int breakerType = 0;
    private static HashSet<String> inlineTags = new HashSet();
    private static HashMap<String, Integer> tagResizeConstrans;
    private static HashSet<String> breakWithParagraphTags;
    private static HashSet<String> breakWithoutParagraphTags;
    IRegion fCurrentRegionToFormat = null;

    static {
        inlineTags.add("b");
        inlineTags.add("i");
        inlineTags.add("u");
        inlineTags.add("img");
        inlineTags.add("sub");
        inlineTags.add("sup");
        inlineTags.add("strike");
        inlineTags.add("font");
        inlineTags.add("a");
        inlineTags.add("input");
        inlineTags.add("textarea");
        inlineTags.add("span");
        inlineTags.add("button");
        inlineTags.add("label");
        tagResizeConstrans = new HashMap();
        tagResizeConstrans.put("table", 255);
        tagResizeConstrans.put("tr", 255);
        tagResizeConstrans.put("br", 0);
        tagResizeConstrans.put("b", 0);
        tagResizeConstrans.put("i", 0);
        tagResizeConstrans.put("u", 0);
        tagResizeConstrans.put("sub", 0);
        tagResizeConstrans.put("sup", 0);
        tagResizeConstrans.put("strike", 0);
        tagResizeConstrans.put("font", 0);
        tagResizeConstrans.put("a", 0);
        breakWithParagraphTags = new HashSet();
        breakWithParagraphTags.add("b");
        breakWithParagraphTags.add("a");
        breakWithParagraphTags.add("abbr");
        breakWithParagraphTags.add("acronym");
        breakWithParagraphTags.add("b");
        breakWithParagraphTags.add("bdo");
        breakWithParagraphTags.add("big");
        breakWithParagraphTags.add("blink");
        breakWithParagraphTags.add("cite");
        breakWithParagraphTags.add("code");
        breakWithParagraphTags.add("del");
        breakWithParagraphTags.add("dfn");
        breakWithParagraphTags.add("em");
        breakWithParagraphTags.add("font");
        breakWithParagraphTags.add("ins");
        breakWithParagraphTags.add("kbd");
        breakWithParagraphTags.add("nobr");
        breakWithParagraphTags.add("q");
        breakWithParagraphTags.add("s");
        breakWithParagraphTags.add("samp");
        breakWithParagraphTags.add("small");
        breakWithParagraphTags.add("span");
        breakWithParagraphTags.add("strike");
        breakWithParagraphTags.add("strong");
        breakWithParagraphTags.add("tt");
        breakWithParagraphTags.add("u");
        breakWithParagraphTags.add("var");
        breakWithoutParagraphTags = new HashSet();
        breakWithoutParagraphTags.add("p");
        breakWithoutParagraphTags.add("address");
        breakWithoutParagraphTags.add("blockquote");
        breakWithoutParagraphTags.add("center");
        breakWithoutParagraphTags.add("div");
        breakWithoutParagraphTags.add("h1");
        breakWithoutParagraphTags.add("h2");
        breakWithoutParagraphTags.add("h3");
        breakWithoutParagraphTags.add("h4");
        breakWithoutParagraphTags.add("h5");
        breakWithoutParagraphTags.add("h6");
        breakWithoutParagraphTags.add("p");
        breakWithoutParagraphTags.add("pre");
    }

    @Override
    public void init(Element templateElement, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.children = "yes".equals(templateElement.getAttribute("children"));
        this.modify = "yes".equals(templateElement.getAttribute("modify"));
        this.invisible = "yes".equals(templateElement.getAttribute("invisible"));
        String strHasImaginaryBorder = templateElement.getAttribute("hasImaginaryBorder");
        this.hasImaginaryBorder = strHasImaginaryBorder != null && strHasImaginaryBorder.length() != 0 ? "yes".equalsIgnoreCase(strHasImaginaryBorder) : false;
        this.init(templateElement);
    }

    protected void init(Element templateElement) {
        this.initTemplateSections(templateElement, true, true, true, true, true);
    }

    protected void initTemplateSections(Element templateElement, boolean resizeHandler, boolean dndHandler, boolean textFormatingHandler, boolean breakHandler, boolean pseudoContentHandler) {
        NodeList children = templateElement.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                Node section = children.item(i);
                if (section.getNodeType() == 1) {
                    String sectionName = section.getNodeName();
                    if (resizeHandler && "vpe:resize".equals(sectionName)) {
                        this.initResizeHandler((Element)section);
                    } else if (dndHandler && "vpe:dnd".equals(sectionName)) {
                        this.initDndHandler((Element)section);
                    } else if (textFormatingHandler && "vpe:textFormatting".equals(sectionName)) {
                        this.initTextFormatingHandler((Element)section);
                    } else if (breakHandler && TAG_BREAKER.equals(sectionName)) {
                        this.initBreakHandler((Element)section);
                    } else if (pseudoContentHandler && TAG_PSEUDOCONTENT.equals(sectionName)) {
                        this.initPseudoContentHandler((Element)section);
                    } else {
                        this.initTemplateSection((Element)section);
                    }
                }
                ++i;
            }
        }
    }

    private void initResizeHandler(Element templateSection) {
        if (this.resizer == null) {
            this.resizer = new VpeResizer();
            this.resizer.setResizeData(templateSection);
        }
    }

    private void initDndHandler(Element templateSection) {
        if (this.getDragger() == null) {
            this.setDragger(new VpeDnDHelper());
            this.getDragger().setDndData(templateSection);
        }
    }

    private void initTextFormatingHandler(Element templateSection) {
        if (this.textFormatingData == null) {
            this.textFormatingData = new TextFormatingData(templateSection);
        }
    }

    private void initBreakHandler(Element templateSection) {
        if (this.breakerType == 0 && templateSection.hasAttribute(ATTR_BREAKER_TYPE)) {
            String typeValue = templateSection.getAttribute(ATTR_BREAKER_TYPE);
            if (ATTR_BREAKER_TYPE_IGNORE.equalsIgnoreCase(typeValue)) {
                this.breakerType = 1;
            } else if (ATTR_BREAKER_TYPE_SELECTITEM.equalsIgnoreCase(typeValue)) {
                this.breakerType = 2;
            }
        }
    }

    private void initPseudoContentHandler(Element templateSection) {
        if (this.pseudoContentCreator == null) {
            if ("yes".equalsIgnoreCase(templateSection.getAttribute(ATTR_PSEUDOCONTENT_DEFAULTTEXT))) {
                this.pseudoContentCreator = new VpeTextPseudoContentCreator(null, templateSection.getAttribute(ATTR_PSEUDOCONTENT_ATTRNAME));
            } else {
                NodeList children = templateSection.getChildNodes();
                if (children != null) {
                    Node child;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        child = children.item(i);
                        if (child.getNodeType() == 1) {
                            this.pseudoContentCreator = new VpeHtmlPseudoContentCreator((Element)child);
                            return;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < len) {
                        String text;
                        child = children.item(i);
                        if (child.getNodeType() == 3 && (text = child.getNodeValue().trim()).length() > 0) {
                            this.pseudoContentCreator = new VpeTextPseudoContentCreator(text, null);
                            return;
                        }
                        ++i;
                    }
                }
                this.pseudoContentCreator = VpeEmptyPseudoContentCreator.getInstance();
            }
        }
    }

    protected void initTemplateSection(Element templateSection) {
    }

    @Override
    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
    }

    private IRegion getRegionToFormat() {
        return this.fCurrentRegionToFormat;
    }

    private void clearRegionToFormat() {
        this.fCurrentRegionToFormat = null;
    }

    private void updateRegionToFormat(Node node) {
        if (node instanceof IndexedRegion) {
            IndexedRegion region = (IndexedRegion)node;
            int start = region.getStartOffset();
            int end = region.getEndOffset();
            if (this.fCurrentRegionToFormat == null) {
                this.fCurrentRegionToFormat = new Region(start, end - start);
            } else {
                int cStart = this.fCurrentRegionToFormat.getOffset();
                int cEnd = this.fCurrentRegionToFormat.getOffset() + this.fCurrentRegionToFormat.getLength();
                if (start < cStart) {
                    cStart = start;
                }
                if (end > cEnd) {
                    cEnd = end;
                }
                this.fCurrentRegionToFormat = new Region(cStart, cEnd - cStart);
            }
        }
    }

    private void reformatCallback(VpePageContext pageContext) {
        try {
            StructuredTextEditor editor = pageContext.getEditPart().getSourceEditor();
            StructuredTextViewer viewer = editor.getTextViewer();
            if (this.getRegionToFormat() != null && editor instanceof ITextFormatter) {
                ((ITextFormatter)editor).formatTextRegion(viewer.getDocument(), this.getRegionToFormat());
            }
        }
        finally {
            this.clearRegionToFormat();
        }
    }

    @Override
    public boolean nonctrlKeyPressHandler(VpePageContext pageContext, Document sourceDocument, Node sourceNode, nsIDOMNode visualNode, Object data, long charCode, SourceSelection selection, ITextFormatter formatter) {
        switch (this.breakerType) {
            case 1: {
                return true;
            }
            case 2: {
                return VpeBreackerHelper.selectItem(pageContext, sourceDocument, sourceNode, visualNode, data, charCode, selection);
            }
        }
        return this.nonctrlKeyPressHandlerImpl(pageContext, sourceDocument, sourceNode, visualNode, data, charCode, selection, formatter);
    }

    private boolean nonctrlKeyPressHandlerImpl(VpePageContext pageContext, Document sourceDocument, Node sourceNode, nsIDOMNode visualNode, Object data, long charCode, SourceSelection selection, ITextFormatter formatter) {
        this.clearRegionToFormat();
        Node focusNode = selection.getFocusNode();
        short focusNodeType = focusNode.getNodeType();
        if (sourceNode.getNodeName().equalsIgnoreCase("li")) {
            Node where = null;
            where = selection.getFocusOffset() == 0 ? sourceNode : sourceNode.getNextSibling();
            Node newLi = sourceNode.cloneNode(false);
            newLi = sourceNode.getParentNode().insertBefore(newLi, where);
            if (focusNodeType == 3 || focusNodeType == 1 && sourceNode != focusNode) {
                Node newText;
                Node parent = focusNode.getParentNode();
                Node node1 = newText = focusNode.cloneNode(false);
                if (focusNodeType == 3) {
                    String value1 = focusNode.getNodeValue().substring(0, selection.getFocusOffset());
                    String value2 = node1.getNodeValue().substring(selection.getFocusOffset());
                    if (where != sourceNode) {
                        focusNode.setNodeValue(value1);
                        node1.setNodeValue(value2);
                    } else {
                        focusNode.setNodeValue(value2);
                        node1.setNodeValue(value1);
                    }
                }
                Node newParent = null;
                while (parent != sourceNode) {
                    newParent = parent.cloneNode(false);
                    newParent.appendChild(node1);
                    node1 = newParent;
                    parent = parent.getParentNode();
                }
                node1 = newLi.appendChild(node1);
                Node next = focusNode.getNextSibling();
                if (next != null) {
                    while (next != null) {
                        Node next1 = next.getNextSibling();
                        newText.getParentNode().appendChild(next);
                        next = next1;
                    }
                }
                if (selection.getFocusOffset() == 0) {
                    focusNode.getParentNode().removeChild(focusNode);
                }
                this.setCursor(pageContext, newText);
            } else {
                this.setCursor(pageContext, newLi);
            }
            this.updateRegionToFormat(sourceNode);
            this.updateRegionToFormat(newLi);
            this.reformatCallback(pageContext);
            return true;
        }
        if (focusNodeType == 1 && focusNode.getNodeName().equalsIgnoreCase("br")) {
            Node newNode = focusNode.getParentNode().insertBefore(focusNode.getOwnerDocument().createElement("br"), focusNode);
            this.updateRegionToFormat(focusNode);
            this.updateRegionToFormat(newNode);
            this.reformatCallback(pageContext);
            return true;
        }
        if (focusNodeType == 1 && focusNode.getNodeName().equalsIgnoreCase("p")) {
            Node nextElement = focusNode.getNextSibling();
            Node parent = focusNode.getParentNode();
            if (parent != null) {
                Node newP = null;
                newP = nextElement != null ? focusNode.getParentNode().insertBefore(focusNode.cloneNode(false), nextElement) : focusNode.getParentNode().appendChild(focusNode.cloneNode(false));
                this.setCursor(pageContext, newP);
                this.updateRegionToFormat(newP);
            }
            this.updateRegionToFormat(focusNode);
            this.reformatCallback(pageContext);
            return true;
        }
        if (focusNodeType == 3 && focusNode.getParentNode().getNodeName().equalsIgnoreCase("td")) {
            Text newNode = ((Text)focusNode).splitText(selection.getFocusOffset());
            this.setCursor(pageContext, newNode);
            this.updateRegionToFormat(focusNode);
            this.updateRegionToFormat(newNode);
            this.reformatCallback(pageContext);
            return true;
        }
        if (sourceNode.getNodeType() == 1 && sourceNode.getNodeName().equalsIgnoreCase("tr")) {
            return true;
        }
        if (focusNodeType == 3 && !focusNode.getParentNode().getNodeName().equalsIgnoreCase("body")) {
            Node parent = focusNode.getParentNode();
            if (parent != null) {
                String parentName = parent.getNodeName();
                if (breakWithParagraphTags.contains(parentName)) {
                    Node p1 = null;
                    Node p2 = null;
                    Node parentParent = parent.getParentNode();
                    if (parentParent != null) {
                        if (!parentParent.getNodeName().equalsIgnoreCase("p")) {
                            if (parentParent.getNodeType() != 9) {
                                p1 = parentParent.getOwnerDocument().createElement("p");
                                parentParent.insertBefore(p1, parent);
                                parent = parentParent.removeChild(parent);
                                p1.appendChild(parent);
                            } else {
                                p1 = ((Document)parentParent).createElement("p");
                                parentParent.insertBefore(p1, parent);
                                parent = parentParent.removeChild(parent);
                                p1.appendChild(parent);
                            }
                        } else {
                            p1 = parentParent;
                        }
                        Text newNode = ((Text)focusNode).splitText(selection.getFocusOffset());
                        p2 = p1.getParentNode().insertBefore(p1.cloneNode(false), p1.getNextSibling());
                        Node newParent = p2.appendChild(parent.cloneNode(false));
                        Node currentNode = newNode;
                        while (currentNode != null) {
                            Node currentNode1 = currentNode.getNextSibling();
                            currentNode = parent.removeChild(currentNode);
                            newParent.appendChild(currentNode);
                            currentNode = currentNode1;
                        }
                        this.setCursor(pageContext, newNode);
                        this.updateRegionToFormat(p1);
                        this.updateRegionToFormat(p2);
                        this.reformatCallback(pageContext);
                        return true;
                    }
                } else if (breakWithoutParagraphTags.contains(parentName)) {
                    Text newNode = ((Text)focusNode).splitText(selection.getFocusOffset());
                    Node parentParent = parent.getParentNode();
                    if (parentParent != null) {
                        boolean clone = newNode.getNodeValue().trim().length() > 0;
                        Node newParent = parentParent.insertBefore(this.makeNewParent(parent, clone), parent.getNextSibling());
                        Node currentNode = newNode;
                        while (currentNode != null) {
                            Node currentNode1 = currentNode.getNextSibling();
                            currentNode = parent.removeChild(currentNode);
                            newParent.appendChild(currentNode);
                            currentNode = currentNode1;
                        }
                        this.setCursor(pageContext, newNode);
                        this.updateRegionToFormat(sourceNode);
                        this.updateRegionToFormat(newParent);
                        this.reformatCallback(pageContext);
                        return true;
                    }
                }
            }
        } else if (focusNodeType == 1 && selection.getFocusOffset() == 2) {
            Node parentParent;
            Node parent = focusNode;
            String parentName = parent.getNodeName();
            if (breakWithParagraphTags.contains(parentName)) {
                Node p1 = null;
                Node p2 = null;
                Node parentParent2 = parent.getParentNode();
                if (parentParent2 != null) {
                    if (!parentParent2.getNodeName().equalsIgnoreCase("p")) {
                        if (parentParent2.getNodeType() != 9) {
                            p1 = parentParent2.getOwnerDocument().createElement("p");
                            parentParent2.insertBefore(p1, parent);
                            parent = parentParent2.removeChild(parent);
                            p1.appendChild(parent);
                        } else {
                            p1 = ((Document)parentParent2).createElement("p");
                            parentParent2.insertBefore(p1, parent);
                            parent = parentParent2.removeChild(parent);
                            p1.appendChild(parent);
                        }
                    } else {
                        p1 = parentParent2;
                    }
                    p2 = p1.getParentNode().insertBefore(p1.cloneNode(false), p1.getNextSibling());
                    Node newParent = p2.appendChild(parent.cloneNode(false));
                    this.setCursor(pageContext, newParent);
                    this.updateRegionToFormat(p1);
                    this.updateRegionToFormat(p2);
                    this.updateRegionToFormat(newParent);
                    this.reformatCallback(pageContext);
                    return true;
                }
            } else if (breakWithoutParagraphTags.contains(parentName) && (parentParent = parent.getParentNode()) != null) {
                Node newParent = parentParent.insertBefore(this.makeNewParent(parent, false), parent.getNextSibling());
                this.setCursor(pageContext, newParent);
                this.updateRegionToFormat(newParent);
                this.reformatCallback(pageContext);
                return true;
            }
        } else {
            if (focusNodeType == 3 && focusNode.getParentNode().getNodeName().equalsIgnoreCase("body")) {
                Element p1 = focusNode.getOwnerDocument().createElement("p");
                Element p2 = focusNode.getOwnerDocument().createElement("p");
                Text newNode = ((Text)focusNode).splitText(selection.getFocusOffset());
                focusNode.getParentNode().insertBefore(p1, focusNode);
                focusNode.getParentNode().insertBefore(p2, newNode);
                focusNode = focusNode.getParentNode().removeChild(focusNode);
                newNode = (Text)newNode.getParentNode().removeChild(newNode);
                p1.appendChild(focusNode);
                p2.appendChild(newNode);
                this.setCursor(pageContext, newNode);
                this.updateRegionToFormat(p1);
                this.updateRegionToFormat(p2);
                this.updateRegionToFormat(newNode);
                this.reformatCallback(pageContext);
                return true;
            }
            if (focusNodeType == 1 && selection.getFocusOffset() == 0) {
                Node newNode = focusNode.getParentNode().insertBefore(focusNode.getOwnerDocument().createElement("br"), focusNode);
                this.updateRegionToFormat(focusNode);
                this.updateRegionToFormat(newNode);
                this.reformatCallback(pageContext);
                return true;
            }
        }
        return false;
    }

    private Node makeNewParent(Node parent, boolean clone) {
        Node newParent = null;
        if (parent != null) {
            boolean isH = false;
            int i = 1;
            while (i < 7 && !isH) {
                isH = parent.getNodeName().equalsIgnoreCase("h" + i);
                ++i;
            }
            newParent = !isH || clone ? parent.cloneNode(false) : parent.getOwnerDocument().createElement("p");
        }
        return newParent;
    }

    private void setCursor(VpePageContext pageContext, Node node) {
        int nodeOffset = ((IndexedRegion)node).getStartOffset();
        if (node.getNodeType() == 1) {
            ElementImpl element = (ElementImpl)node;
            nodeOffset = element.getStartEndOffset();
        }
        pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(nodeOffset, 0);
        pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(nodeOffset, 0);
    }

    @Override
    public void beforeRemove(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
    }

    @Override
    public Node getNodeForUpdate(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        return null;
    }

    @Override
    public void resize(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Object data, int resizerConstrains, int top, int left, int width, int height) {
        if (this.resizer != null) {
            this.resizer.resize(pageContext, sourceElement, visualDocument, visualElement, data, resizerConstrains, top, left, width, height);
        }
    }

    @Override
    public boolean canInnerDrag(VpePageContext pageContext, Element sourceElement) {
        if (this.getDragger() != null) {
            return this.getDragger().isDragEnabled();
        }
        return true;
    }

    @Override
    public boolean canInnerDrop(VpePageContext pageContext, Node container, Node sourceDragNode) {
        if (this.dragger != null) {
            return this.dragger.isDropEnabled(pageContext, container, sourceDragNode);
        }
        return false;
    }

    @Override
    public void innerDrop(VpePageContext pageContext, VpeSourceInnerDragInfo dragInfo, VpeSourceDropInfo dropInfo) {
    }

    protected String deleteFromString(String data, String begin, String end) {
        int startPosition = data.indexOf(begin);
        if (startPosition < 0) {
            return data;
        }
        int endPosition = data.indexOf(end, startPosition);
        String result = data.substring(0, startPosition).trim();
        if (endPosition > 0) {
            result = String.valueOf(result) + data.substring(endPosition + 1, data.length()).trim();
        }
        return result;
    }

    @Override
    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return this.children;
    }

    @Override
    public boolean canModify() {
        return this.modify;
    }

    @Override
    public void setModify(boolean modify) {
        this.modify = modify;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public TextFormatingData getTextFormattingData() {
        return this.textFormatingData;
    }

    @Override
    public VpeTagDescription getTagDescription(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Object data) {
        VpeTagDescription tagDescription = new VpeTagDescription();
        if (inlineTags.contains(visualElement.getNodeName().toLowerCase())) {
            tagDescription.setDisplayType(2);
        }
        if (this.resizer != null) {
            this.resizer.modifyTagDescription(tagDescription);
        }
        return tagDescription;
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name) {
    }

    @Override
    public String[] getOutputAttributeNames() {
        return null;
    }

    @Override
    public nsIDOMText getOutputTextNode(VpePageContext pageContext, Element sourceElement, Object data) {
        return null;
    }

    @Override
    public boolean isOutputAttributes() {
        return false;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public VpeAnyData getAnyData() {
        return null;
    }

    @Override
    public void setSourceAttributeSelection(VpePageContext pageContext, Element sourceElement, int offset, int length, Object data) {
    }

    @Override
    public void setSourceAttributeValue(VpePageContext pageContext, Element sourceElement, Object data) {
    }

    @Override
    public void refreshBundleValues(VpePageContext pageContext, Element sourceElement, Object data) {
    }

    @Override
    public void setPseudoContent(VpePageContext pageContext, Node sourceContainer, nsIDOMNode visualContainer, nsIDOMDocument visualDocument) {
        try {
            if (this.pseudoContentCreator != null) {
                this.pseudoContentCreator.setPseudoContent(pageContext, sourceContainer, visualContainer, visualDocument);
            } else {
                VpeDefaultPseudoContentCreator.getInstance().setPseudoContent(pageContext, sourceContainer, visualContainer, visualDocument);
            }
        }
        catch (VpeExpressionException ex) {
            VpeExpressionException exception = new VpeExpressionException(sourceContainer + " ", ex);
            VpePlugin.reportProblem(exception);
        }
    }

    @Override
    public boolean containsText() {
        return true;
    }

    @Override
    public boolean hasImaginaryBorder() {
        return this.hasImaginaryBorder;
    }

    public VpeDnDHelper getDragger() {
        return this.dragger;
    }

    public void setDragger(VpeDnDHelper dragger) {
        this.dragger = dragger;
    }

    @Override
    public NodeData getNodeData(nsIDOMNode node, VpeElementData elementData, VpeDomMapping domMapping) {
        if (node != null && elementData != null && elementData.getNodesData() != null) {
            List<NodeData> nodesData = elementData.getNodesData();
            for (NodeData nodeData : nodesData) {
                if (!node.equals(nodeData.getVisualNode())) continue;
                return nodeData;
            }
        }
        return null;
    }

    @Override
    public nsIDOMNode getVisualNodeBySourcePosition(VpeElementMapping elementMapping, int focusPosition, int anchorPosition, VpeDomMapping domMapping) {
        nsIDOMNode focusNode = this.findNodeByPosition(elementMapping.getElementData(), focusPosition);
        nsIDOMNode anchorNode = this.findNodeByPosition(elementMapping.getElementData(), anchorPosition);
        if (focusNode != null && focusNode == anchorNode) {
            return focusNode;
        }
        return elementMapping.getVisualNode();
    }

    private nsIDOMNode findNodeByPosition(VpeElementData elementData, int position) {
        if (elementData != null && elementData.getNodesData() != null) {
            List<NodeData> attributesMapping = elementData.getNodesData();
            for (NodeData attributeData : attributesMapping) {
                if (position < NodesManagingUtil.getStartOffsetNode((Node)attributeData.getSourceNode()) || position > NodesManagingUtil.getEndOffsetNode((Node)attributeData.getSourceNode())) continue;
                return attributeData.getVisualNode();
            }
        }
        return null;
    }

    @Override
    public boolean openBundle(VpePageContext pageContext, nsIDOMNode visualNode, VpeElementMapping elementMapping) {
        nsIDOMNode lastSelectedNode = SelectionUtil.getLastSelectedNode(pageContext);
        if (elementMapping == null) {
            return false;
        }
        NodeData nodeData = this.getNodeData(lastSelectedNode, elementMapping.getElementData(), pageContext.getDomMapping());
        if (nodeData != null && nodeData.getSourceNode() != null && nodeData.getSourceNode().getNodeValue() != null) {
            return pageContext.getBundle().openBundle(nodeData.getSourceNode().getNodeValue(), VpeNodesManagingUtil.getPageLocale(pageContext, nodeData.getSourceNode()));
        }
        return false;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    @Override
    public IRegion getSourceRegionForOpenOn(VpePageContext pageContext, Node sourceNode, nsIDOMNode domNode) {
        int offset = NodesManagingUtil.getStartOffsetNode((Node)sourceNode);
        return new Region(offset += sourceNode.getPrefix().length() + 1 + 1, 0);
    }
}

