/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.util.CheckArg;

public class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Pattern PARAMETER_COUNT_PATTERN = Pattern.compile("\\{(\\d+)\\}");

    public static String createString(String pattern, Object ... parameters) {
        CheckArg.isNotNull(pattern, "pattern");
        if (parameters == null) {
            parameters = EMPTY_STRING_ARRAY;
        }
        Matcher matcher = PARAMETER_COUNT_PATTERN.matcher(pattern);
        StringBuffer text = new StringBuffer();
        int requiredParameterCount = 0;
        boolean err = false;
        while (matcher.find()) {
            int ndx = Integer.valueOf(matcher.group(1));
            if (requiredParameterCount <= ndx) {
                requiredParameterCount = ndx + 1;
            }
            if (ndx >= parameters.length) {
                err = true;
                matcher.appendReplacement(text, matcher.group());
                continue;
            }
            List<Object> parameter = parameters[ndx];
            if (parameter != null && parameter.getClass().isArray()) {
                parameter = Arrays.asList((Object[])parameter);
            }
            matcher.appendReplacement(text, Matcher.quoteReplacement(parameter == null ? "null" : parameter.toString()));
        }
        if (err || requiredParameterCount < parameters.length) {
            throw new IllegalArgumentException(JdbcI18n.i18nRequiredToSuppliedParameterMismatch.text(parameters.length, parameters.length == 1 ? "" : "s", requiredParameterCount, requiredParameterCount == 1 ? "" : "s", pattern, text.toString()));
        }
        matcher.appendTail(text);
        return text.toString();
    }

    public static String createString(char charToRepeat, int numberOfRepeats) {
        assert (numberOfRepeats >= 0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfRepeats; ++i) {
            sb.append(charToRepeat);
        }
        return sb.toString();
    }

    private StringUtil() {
    }
}

