/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.domain.IModeShapeObject;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;

@Immutable
public class Workspace
implements IModeShapeObject {
    private final String name;
    private final Repository repository;

    public Workspace(String name, Repository repository) {
        assert (name != null);
        assert (repository != null);
        this.name = name;
        this.repository = repository;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Workspace otherWorkspace = (Workspace)obj;
        return this.name.equals(otherWorkspace.name) && this.repository.equals(otherWorkspace.repository);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Server getServer() {
        return this.repository.getServer();
    }

    @Override
    public String getShortDescription() {
        return RestClientI18n.workspaceShortDescription.text(this.name, this.repository.getName());
    }

    public int hashCode() {
        return HashCode.compute(this.name, this.repository);
    }

    public String toString() {
        return this.getShortDescription();
    }
}

