/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.observe;

import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;

@ThreadSafe
public abstract class ChangeObserver
implements Observer {
    private final CopyOnWriteArraySet<ChangeSourceReference> sources = new CopyOnWriteArraySet();

    protected ChangeObserver() {
    }

    final void registeredWith(Observable source) {
        this.sources.add(new ChangeSourceReference(source));
    }

    final void unregisteredWith(Observable source) {
        this.sources.remove(new ChangeSourceReference(source));
    }

    public void unregister() {
        this.doUnregister();
    }

    protected final void doUnregister() {
        for (ChangeSourceReference sourceReference : this.sources) {
            Observable source = (Observable)sourceReference.get();
            if (source == null) continue;
            try {
                source.unregister(this);
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).debug(t, "Error while unregistering {0} from {1}", new Object[]{this, source});
            }
        }
    }

    public boolean isRegistered() {
        for (ChangeSourceReference reference : this.sources) {
            if (reference.get() == null) continue;
            return true;
        }
        return false;
    }

    public abstract void notify(Changes var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ChangeSourceReference
    extends WeakReference<Observable> {
        final int hc;

        protected ChangeSourceReference(Observable source) {
            super(source);
            this.hc = source.hashCode();
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ChangeSourceReference) {
                Observable thatSource;
                ChangeSourceReference that = (ChangeSourceReference)obj;
                Observable thisSource = (Observable)this.get();
                return thisSource == (thatSource = (Observable)that.get());
            }
            if (obj instanceof Observable) {
                Observable that = (Observable)obj;
                return this.get() == that;
            }
            return false;
        }
    }
}

