/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.SecureHash;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.ValueComparators;

@Immutable
public abstract class AbstractBinary
implements Binary {
    protected static final Set<String> ALGORITHMS_NOT_FOUND_AND_LOGGED = new CopyOnWriteArraySet<String>();
    private static final SecureHash.Algorithm ALGORITHM = SecureHash.Algorithm.SHA_1;
    private static final byte[] NO_HASH = new byte[0];
    protected static final byte[] EMPTY_CONTENT = new byte[0];
    private static final long serialVersionUID = 1L;

    protected AbstractBinary() {
    }

    protected byte[] computeHash(byte[] content) {
        try {
            return SecureHash.getHash((SecureHash.Algorithm)ALGORITHM, (byte[])content);
        }
        catch (NoSuchAlgorithmException e) {
            if (ALGORITHMS_NOT_FOUND_AND_LOGGED.add(ALGORITHM.digestName())) {
                Logger.getLogger(this.getClass()).error((Throwable)e, GraphI18n.messageDigestNotFound, new Object[]{ALGORITHM.digestName()});
            }
            return NO_HASH;
        }
    }

    protected byte[] computeHash(File file) {
        try {
            return SecureHash.getHash((SecureHash.Algorithm)ALGORITHM, (File)file);
        }
        catch (NoSuchAlgorithmException e) {
            if (ALGORITHMS_NOT_FOUND_AND_LOGGED.add(ALGORITHM.digestName())) {
                Logger.getLogger(this.getClass()).error((Throwable)e, GraphI18n.messageDigestNotFound, new Object[]{ALGORITHM.digestName()});
            }
            return NO_HASH;
        }
        catch (IOException e) {
            if (ALGORITHMS_NOT_FOUND_AND_LOGGED.add(ALGORITHM.digestName())) {
                Logger.getLogger(this.getClass()).error((Throwable)e, GraphI18n.messageDigestNotFound, new Object[]{ALGORITHM.digestName()});
            }
            return NO_HASH;
        }
    }

    protected byte[] computeHash(InputStream stream) {
        try {
            return SecureHash.getHash((SecureHash.Algorithm)ALGORITHM, (InputStream)stream);
        }
        catch (NoSuchAlgorithmException e) {
            if (ALGORITHMS_NOT_FOUND_AND_LOGGED.add(ALGORITHM.digestName())) {
                Logger.getLogger(this.getClass()).error((Throwable)e, GraphI18n.messageDigestNotFound, new Object[]{ALGORITHM.digestName()});
            }
            return NO_HASH;
        }
        catch (IOException e) {
            if (ALGORITHMS_NOT_FOUND_AND_LOGGED.add(ALGORITHM.digestName())) {
                Logger.getLogger(this.getClass()).error((Throwable)e, GraphI18n.messageDigestNotFound, new Object[]{ALGORITHM.digestName()});
            }
            return NO_HASH;
        }
    }

    public int compareTo(Binary o) {
        return ValueComparators.BINARY_COMPARATOR.compare(this, o);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Binary) {
            Binary that = (Binary)obj;
            if (this.getSize() != that.getSize()) {
                return false;
            }
            return ValueComparators.BINARY_COMPARATOR.compare(this, that) == 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            this.acquire();
            StringBuilder sb = new StringBuilder();
            sb.append("binary (");
            sb.append(this.getReadableSize());
            sb.append(", SHA1=");
            sb.append(SecureHash.asHexString((byte[])this.getHash()));
            sb.append(')');
            String string = sb.toString();
            return string;
        }
        finally {
            this.release();
        }
    }

    public String getReadableSize() {
        long size = this.getSize();
        float decimalInKb = (float)size / 1024.0f;
        if (decimalInKb < 1.0f) {
            return Long.toString(size) + "B";
        }
        float decimalInMb = decimalInKb / 1024.0f;
        if (decimalInMb < 1.0f) {
            return new DecimalFormat("#,##0.00").format(decimalInKb) + "KB";
        }
        float decimalInGb = decimalInMb / 1024.0f;
        if (decimalInGb < 1.0f) {
            return new DecimalFormat("#,##0.00").format(decimalInMb) + "MB";
        }
        float decimalInTb = decimalInGb / 1024.0f;
        if (decimalInTb < 1.0f) {
            return new DecimalFormat("#,##0.00").format(decimalInGb) + "GB";
        }
        return new DecimalFormat("#,##0.00").format(decimalInTb) + "TB";
    }
}

