/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class PropertyValue
implements DynamicOperand {
    private static final long serialVersionUID = 1L;
    private final Set<SelectorName> selectorNames;
    private final String propertyName;
    private final int hc;

    public PropertyValue(SelectorName selectorName, String propertyName) {
        this.selectorNames = SelectorName.nameSetFrom(selectorName);
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        this.propertyName = propertyName;
        this.hc = HashCode.compute((Object[])new Object[]{selectorName, this.propertyName});
    }

    public SelectorName selectorName() {
        return this.selectorNames().iterator().next();
    }

    @Override
    public Set<SelectorName> selectorNames() {
        return this.selectorNames;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyValue) {
            PropertyValue that = (PropertyValue)obj;
            if (this.hc != that.hc) {
                return false;
            }
            return ((Object)this.selectorNames()).equals(that.selectorNames()) && this.propertyName.equals(that.propertyName);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

