/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.WrapperImpl;
import org.teiid.jdbc.XAConnectionImpl;

public abstract class BaseDataSource
extends WrapperImpl
implements DataSource,
XADataSource,
ConnectionPoolDataSource,
Serializable {
    public static final String DEFAULT_APP_NAME = "JDBC";
    public static final String VDB_NAME = "VirtualDatabaseName";
    public static final String VDB_VERSION = "VirtualDatabaseVersion";
    public static final String VERSION = "version";
    public static final String APP_NAME = "ApplicationName";
    public static final String USER_NAME = "user";
    public static final String PASSWORD = "password";
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final int DEFAULT_LOG_LEVEL = 0;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String user;
    private String password;
    private String databaseVersion;
    private String applicationName;
    private String partialResultsMode;
    private int fetchSize = 2048;
    private String resultSetCacheMode;
    private int loginTimeout = 0;
    private String showPlan;
    private boolean noExec;
    private String disableLocalTxn;
    private String transactionAutoWrap;
    private boolean ansiQuotedIdentifiers = true;
    private transient PrintWriter logWriter;
    public static final String JDBC = "jdbc:";
    protected static final int DEFAULT_FETCH_SIZE = 2048;
    protected static final String DEFAULT_PARTIAL_RESULTS_MODE = "FALSE";
    protected static final String DEFAULT_RESULT_SET_CACHE_MODE = "FALSE";
    public static final String TXN_WRAP_OFF = "OFF";
    public static final String TXN_WRAP_ON = "ON";
    public static final String TXN_WRAP_AUTO = "DETECT";
    private String additionalProperties;

    protected Properties buildProperties(String userName, String password) {
        Properties props = new Properties();
        props.setProperty(VDB_NAME, this.getDatabaseName());
        if (this.getDatabaseVersion() != null && this.getDatabaseVersion().trim().length() != 0) {
            props.setProperty(VDB_VERSION, this.getDatabaseVersion());
        }
        if (userName != null && userName.trim().length() != 0) {
            props.setProperty(USER_NAME, userName);
        } else if (this.getUser() != null && this.getUser().trim().length() != 0) {
            props.setProperty(USER_NAME, this.getUser());
        }
        if (password != null && password.trim().length() != 0) {
            props.setProperty(PASSWORD, password);
        } else if (this.getPassword() != null && this.getPassword().trim().length() != 0) {
            props.setProperty(PASSWORD, this.getPassword());
        }
        if (this.getApplicationName() != null && this.getApplicationName().trim().length() != 0) {
            props.setProperty(APP_NAME, this.getApplicationName());
        }
        if (this.getPartialResultsMode() != null && this.getPartialResultsMode().trim().length() != 0) {
            props.setProperty("partialResultsMode", this.getPartialResultsMode());
        }
        if (this.getFetchSize() > 0) {
            props.setProperty("fetchSize", String.valueOf(this.getFetchSize()));
        }
        if (this.getResultSetCacheMode() != null && this.getResultSetCacheMode().trim().length() != 0) {
            props.setProperty("resultSetCacheMode", this.getResultSetCacheMode());
        }
        if (this.getShowPlan() != null) {
            props.setProperty("SHOWPLAN", this.getShowPlan());
        }
        if (this.isNoExec()) {
            props.setProperty("NOEXEC", String.valueOf(this.isNoExec()));
        }
        if (this.getTransactionAutoWrap() != null && this.getTransactionAutoWrap().trim().length() != 0) {
            props.setProperty("autoCommitTxn", this.getTransactionAutoWrap());
        }
        if (this.getDisableLocalTxn() != null) {
            props.setProperty("disableLocalTxn", this.getDisableLocalTxn());
        }
        if (this.additionalProperties != null) {
            JDBCURL.parseConnectionProperties(this.additionalProperties, props);
        }
        return props;
    }

    protected void validateProperties(String userName, String password) throws SQLException {
        String reason = BaseDataSource.reasonWhyInvalidApplicationName(this.applicationName);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDatabaseName(this.databaseName);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDatabaseVersion(this.databaseVersion);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDataSourceName(this.dataSourceName);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDescription(this.description);
        if (reason != null) {
            throw new SQLException(reason);
        }
        String pwd = password != null ? password : this.getPassword();
        reason = BaseDataSource.reasonWhyInvalidPassword(pwd);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidPartialResultsMode(this.partialResultsMode);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidFetchSize(this.fetchSize);
        if (reason != null) {
            throw new SQLException(reason);
        }
        String user = userName != null ? userName : this.getUser();
        reason = BaseDataSource.reasonWhyInvalidUser(user);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidTransactionAutoWrap(this.transactionAutoWrap);
        if (reason != null) {
            throw new SQLException(reason);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(null, null);
    }

    @Override
    public XAConnection getXAConnection(final String userName, final String password) throws SQLException {
        return XAConnectionImpl.newInstance(new XAConnectionImpl.ConnectionSource(){

            @Override
            public ConnectionImpl createConnection() throws SQLException {
                return (ConnectionImpl)BaseDataSource.this.getConnection(userName, password);
            }
        });
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    @Override
    public PooledConnection getPooledConnection(String userName, String password) throws SQLException {
        return this.getXAConnection(userName, password);
    }

    public String getDisableLocalTxn() {
        return this.disableLocalTxn;
    }

    public void setDisableLocalTxn(String disableLocalTxn) {
        this.disableLocalTxn = disableLocalTxn;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.logWriter = writer;
    }

    @Override
    public void setLoginTimeout(int timeOut) throws SQLException {
        this.loginTimeout = timeOut;
    }

    public String getApplicationName() {
        return this.applicationName != null ? this.applicationName : DEFAULT_APP_NAME;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPartialResultsMode(String partialResultsMode) {
        this.partialResultsMode = partialResultsMode;
    }

    public String getPartialResultsMode() {
        return this.partialResultsMode;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setResultSetCacheMode(String resultSetCacheMode) {
        this.resultSetCacheMode = resultSetCacheMode;
    }

    public String getResultSetCacheMode() {
        return this.resultSetCacheMode;
    }

    public String getShowPlan() {
        return this.showPlan;
    }

    public void setShowPlan(String showPlan) {
        this.showPlan = showPlan;
    }

    public void setNoExec(boolean noExec) {
        this.noExec = noExec;
    }

    public boolean isNoExec() {
        return this.noExec;
    }

    public String getTransactionAutoWrap() {
        return this.transactionAutoWrap;
    }

    public void setTransactionAutoWrap(String transactionAutoWrap) {
        this.transactionAutoWrap = transactionAutoWrap;
    }

    public String getAutoCommitTxn() {
        return this.transactionAutoWrap;
    }

    public void setAutoCommitTxn(String transactionAutoWrap) {
        this.transactionAutoWrap = transactionAutoWrap;
    }

    public static String reasonWhyInvalidApplicationName(String applicationName) {
        return null;
    }

    public static String reasonWhyInvalidDatabaseName(String databaseName) {
        if (databaseName == null || databaseName.trim().length() == 0) {
            return JDBCPlugin.Util.getString("MMDataSource.Virtual_database_name_must_be_specified");
        }
        return null;
    }

    public static String reasonWhyInvalidUser(String userName) {
        return null;
    }

    public static String reasonWhyInvalidTransactionAutoWrap(String autoWrap) {
        if (autoWrap == null || autoWrap.trim().length() == 0) {
            return null;
        }
        String trimmedAutoWrap = autoWrap.trim();
        if (TXN_WRAP_ON.equals(trimmedAutoWrap)) {
            return null;
        }
        if (TXN_WRAP_OFF.equals(trimmedAutoWrap)) {
            return null;
        }
        if (TXN_WRAP_AUTO.equals(trimmedAutoWrap)) {
            return null;
        }
        Object[] params = new Object[]{TXN_WRAP_ON, TXN_WRAP_OFF, TXN_WRAP_AUTO};
        return JDBCPlugin.Util.getString("MMDataSource.Invalid_trans_auto_wrap_mode", params);
    }

    public static String reasonWhyInvalidDatabaseVersion(String databaseVersion) {
        return null;
    }

    public static String reasonWhyInvalidDataSourceName(String dataSourceName) {
        return null;
    }

    public static String reasonWhyInvalidPassword(String pwd) {
        return null;
    }

    public static String reasonWhyInvalidDescription(String description) {
        return null;
    }

    public static String reasonWhyInvalidPartialResultsMode(String partialMode) {
        if (partialMode != null) {
            if (partialMode.equalsIgnoreCase("true") || partialMode.equalsIgnoreCase("false")) {
                return null;
            }
            return JDBCPlugin.Util.getString("MMDataSource.The_partial_mode_must_be_boolean._47");
        }
        return null;
    }

    public static String reasonWhyInvalidFetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            return JDBCPlugin.Util.getString("MMDataSource.The_fetch_size_must_be_greater_than_zero");
        }
        return null;
    }

    public void setAdditionalProperties(String additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAnsiQuotedIdentifiers(boolean ansiQuotedIdentifiers) {
        this.ansiQuotedIdentifiers = ansiQuotedIdentifiers;
    }

    public boolean isAnsiQuotedIdentifiers() {
        return this.ansiQuotedIdentifiers;
    }
}

