/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.teiid.jdbc.BaseDataSource;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.TeiidURL;

public class TeiidDataSource
extends BaseDataSource {
    private static final long serialVersionUID = -5170316154373144878L;
    private int portNumber;
    private String serverName;
    private boolean secure = false;
    private String alternateServers;
    private String autoFailover;
    private String discoveryStrategy;
    private boolean passthroughAuthentication = false;

    @Override
    protected Properties buildProperties(String userName, String password) {
        Properties props = super.buildProperties(userName, password);
        if (this.getAutoFailover() != null) {
            props.setProperty("autoFailover", this.getAutoFailover());
        }
        if (this.getDiscoveryStrategy() != null) {
            props.setProperty("discoveryStategy", this.getDiscoveryStrategy());
        }
        return props;
    }

    private Properties buildServerProperties(String userName, String password) {
        Properties props = this.buildProperties(userName, password);
        props.setProperty("serverURL", this.buildServerURL());
        return props;
    }

    protected String buildServerURL() {
        if (this.alternateServers == null) {
            return new TeiidURL(this.serverName, this.portNumber, this.secure).getAppServerURL();
        }
        String serverURL = "";
        serverURL = "" + (this.secure ? "mms://" : "mm://");
        if (this.serverName.indexOf(58) != -1) {
            serverURL = serverURL + "[";
        }
        serverURL = serverURL + "" + this.serverName;
        if (this.serverName.indexOf(58) != -1) {
            serverURL = serverURL + "]";
        }
        if (this.portNumber != 0) {
            serverURL = serverURL + ":" + this.portNumber;
        }
        if (this.alternateServers.length() > 0) {
            String[] as = this.alternateServers.split(",");
            for (int i = 0; i < as.length; ++i) {
                if (as[i].startsWith("[") && as[i].endsWith("]:")) {
                    serverURL = serverURL + "," + as[i];
                    continue;
                }
                if (as[i].startsWith("[") && as[i].endsWith("]")) {
                    serverURL = serverURL + "," + as[i] + ":" + this.portNumber;
                    continue;
                }
                String[] server = as[i].split(":");
                if (server.length <= 0) continue;
                serverURL = serverURL + "," + server[0];
                serverURL = server.length > 1 ? serverURL + ":" + server[1] : serverURL + ":" + this.portNumber;
            }
        }
        return new TeiidURL(serverURL).getAppServerURL();
    }

    protected String buildURL() {
        return new JDBCURL(this.getDatabaseName(), this.buildServerURL(), this.buildProperties(this.getUser(), this.getPassword())).getJDBCURL();
    }

    @Override
    protected void validateProperties(String userName, String password) throws SQLException {
        super.validateProperties(userName, password);
        String reason = TeiidDataSource.reasonWhyInvalidPortNumber(this.portNumber);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = TeiidDataSource.reasonWhyInvalidServerName(this.serverName);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = TeiidDataSource.reasonWhyInvalidAlternateServers(this.alternateServers);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
    }

    private TeiidSQLException createConnectionError(String reason) {
        String msg = JDBCPlugin.Util.getString("MMDataSource.Err_connecting", reason);
        return new TeiidSQLException(msg);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        TeiidDriver driver = new TeiidDriver();
        if (this.getServerName() == null) {
            super.validateProperties(userName, password);
            Properties props = this.buildEmbeddedProperties(userName, password);
            String url = new JDBCURL(this.getDatabaseName(), null, props).getJDBCURL();
            return driver.connect(url, props);
        }
        this.validateProperties(userName, password);
        Properties props = this.buildServerProperties(userName, password);
        return driver.connect(this.buildURL(), props);
    }

    private Properties buildEmbeddedProperties(String userName, String password) {
        Properties props = this.buildProperties(userName, password);
        props.setProperty("PassthroughAuthentication", Boolean.toString(this.passthroughAuthentication));
        return props;
    }

    public String toString() {
        return this.buildURL();
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getAlternateServers() {
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            return null;
        }
        return this.alternateServers;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setAlternateServers(String servers) {
        this.alternateServers = servers;
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            this.alternateServers = null;
        }
    }

    public static String reasonWhyInvalidPortNumber(int portNumber) {
        if (portNumber == 0) {
            return null;
        }
        if (portNumber < 1) {
            return JDBCPlugin.Util.getString("MMDataSource.Port_number_must_be_positive");
        }
        return null;
    }

    public static String reasonWhyInvalidServerName(String serverName) {
        if (serverName == null || serverName.trim().length() == 0) {
            return JDBCPlugin.Util.getString("MMDataSource.Server_name_required");
        }
        return null;
    }

    public static String reasonWhyInvalidSocketsPerVM(String socketsPerVM) {
        if (socketsPerVM != null) {
            int value = -1;
            try {
                value = Integer.parseInt(socketsPerVM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value <= 0) {
                return JDBCPlugin.Util.getString("MMDataSource.Sockets_per_vm_invalid");
            }
        }
        return null;
    }

    public static String reasonWhyInvalidStickyConnections(String stickyConnections) {
        if (stickyConnections != null && !stickyConnections.equalsIgnoreCase("true") && !stickyConnections.equalsIgnoreCase("false")) {
            return JDBCPlugin.Util.getString("MMDataSource.Sticky_connections_invalid");
        }
        return null;
    }

    public static String reasonWhyInvalidAlternateServers(String alternateServers) {
        if (alternateServers == null || alternateServers.trim().length() < 1) {
            return null;
        }
        String[] as = alternateServers.split(",");
        String sReason = null;
        String reason = "";
        int reasonCount = 0;
        String newline = System.getProperty("line.separator");
        for (int i = 0; i < as.length; ++i) {
            String[] server = as[i].split(":");
            if (server.length < 1 || server.length > 2) {
                return JDBCPlugin.Util.getString("MMDataSource.Alternate_Servers_format");
            }
            sReason = TeiidDataSource.reasonWhyInvalidServerName(server[0]);
            if (sReason != null) {
                reason = reason + (reason.length() > 0 ? newline : "") + sReason;
                ++reasonCount;
                sReason = null;
            }
            if (server.length <= 1) continue;
            int port = 0;
            try {
                port = Integer.parseInt(server[1]);
            }
            catch (NumberFormatException e) {
                reason = reason + (reason.length() > 0 ? newline : "") + JDBCPlugin.Util.getString("MMDataSource.serverPort_must_be_a_number");
                ++reasonCount;
            }
            sReason = TeiidDataSource.reasonWhyInvalidPortNumber(port);
            if (sReason == null) continue;
            reason = reason + (reason.length() > 0 ? newline : "") + sReason;
            ++reasonCount;
            sReason = null;
        }
        if (reasonCount < 1) {
            return null;
        }
        return JDBCPlugin.Util.getString("MMDataSource.alternateServer_is_invalid", String.valueOf(reasonCount), reason);
    }

    public String getAutoFailover() {
        return this.autoFailover;
    }

    public void setAutoFailover(String autoFailover) {
        this.autoFailover = autoFailover;
    }

    public String getDiscoveryStrategy() {
        return this.discoveryStrategy;
    }

    public void setDiscoveryStrategy(String discoveryStrategy) {
        this.discoveryStrategy = discoveryStrategy;
    }

    public boolean isPassthroughAuthentication() {
        return this.passthroughAuthentication;
    }

    public boolean getPassthroughAuthentication() {
        return this.passthroughAuthentication;
    }

    public void setPassthroughAuthentication(boolean passthroughAuthentication) {
        this.passthroughAuthentication = passthroughAuthentication;
    }
}

