/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.netty.handler.codec.serialization;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.List;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoderInputStream
extends ObjectInputStream {
    private final InputStream in;
    private final ClassLoader classLoader;
    private final int maxObjectSize;
    private boolean foundLength;
    private byte[] buffer;
    private int count;
    private Object result;
    private int streamIndex;
    private OutputStream stream;
    private List<InputStreamFactory.StreamFactoryReference> streams;

    public ObjectDecoderInputStream(InputStream in, ClassLoader classLoader, int maxObjectSize) throws SecurityException, IOException {
        this.in = in;
        this.classLoader = classLoader;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected final Object readObjectOverride() throws IOException, ClassNotFoundException {
        if (this.result == null) {
            if (!this.foundLength) {
                int dataLen = this.findLength(4);
                if (dataLen <= 0) {
                    throw new StreamCorruptedException("invalid data length: " + dataLen);
                }
                if (dataLen > this.maxObjectSize) {
                    throw new StreamCorruptedException("data length too big: " + dataLen + " (max: " + this.maxObjectSize + ')');
                }
            }
            this.fillBuffer();
            this.foundLength = false;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer);
            this.buffer = null;
            CompactObjectInputStream cois = new CompactObjectInputStream(bais, this.classLoader);
            this.result = cois.readObject();
            this.streams = ExternalizeUtil.readList(cois, InputStreamFactory.StreamFactoryReference.class);
            this.streamIndex = 0;
        }
        while (this.streamIndex < this.streams.size()) {
            if (!this.foundLength) {
                this.findLength(2);
            }
            if (this.stream == null) {
                final File f = File.createTempFile("teiid", null);
                InputStreamFactory.StreamFactoryReference sfr = this.streams.get(this.streamIndex);
                sfr.setStreamFactory(new InputStreamFactory(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return new BufferedInputStream(new FileInputStream(f)){

                            protected void finalize() throws Throwable {
                                super.finalize();
                                f.delete();
                            }
                        };
                    }
                });
                this.stream = new BufferedOutputStream(new FileOutputStream(f));
            }
            if (this.buffer.length == 0) {
                this.stream.close();
                this.stream = null;
                ++this.streamIndex;
                this.foundLength = false;
                this.buffer = null;
                continue;
            }
            this.fillBuffer();
            this.foundLength = false;
            this.stream.write(this.buffer);
            this.buffer = null;
        }
        Object toReturn = this.result;
        this.result = null;
        this.streams = null;
        this.stream = null;
        return toReturn;
    }

    private int findLength(int bytes) throws IOException, EOFException, StreamCorruptedException {
        if (this.buffer == null) {
            this.buffer = new byte[bytes];
        }
        this.fillBuffer();
        int dataLen = ObjectDecoderInputStream.getIntFromBytes(this.buffer);
        this.buffer = new byte[dataLen];
        this.foundLength = true;
        return dataLen;
    }

    static int getIntFromBytes(byte[] buffer) {
        int result = 0;
        for (int i = 0; i < buffer.length; ++i) {
            result += (buffer[i] & 0xFF) << (buffer.length - i - 1) * 8;
        }
        return result;
    }

    private void fillBuffer() throws IOException, EOFException {
        while (this.count < this.buffer.length) {
            int read = this.in.read(this.buffer, this.count, this.buffer.length - this.count);
            if (read == -1) {
                throw new EOFException();
            }
            this.count += read;
        }
        this.count = 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

