/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.RequestMessage;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.id.IntegerIDFactory;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.AuthorizationValidationVisitor;
import org.teiid.dqp.internal.process.CachedFinder;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.QueryProcessorFactoryImpl;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.multisource.MultiSourceCapabilitiesFinder;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.dqp.internal.process.multisource.MultiSourcePlanToProcessConverter;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.SecurityFunctionEvaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempCapabilitiesFinder;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.ValidationVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class Request {
    protected RequestMessage requestMsg;
    private String vdbName;
    private int vdbVersion;
    private BufferManager bufferManager;
    private ProcessorDataManager processorDataManager;
    private TransactionService transactionService;
    private TempTableStore tempTableStore;
    protected IDGenerator idGenerator = new IDGenerator();
    DQPWorkContext workContext;
    RequestID requestId;
    protected CapabilitiesFinder capabilitiesFinder;
    protected QueryMetadataInterface metadata;
    private Set<String> multiSourceModels;
    protected boolean addedLimit;
    protected ProcessorPlan processPlan;
    protected AnalysisRecord analysisRecord;
    protected CommandContext context;
    protected QueryProcessor processor;
    protected TransactionContext transactionContext;
    protected ConnectorManagerRepository connectorManagerRepo;
    protected Command userCommand;
    protected boolean returnsUpdateCount;
    protected boolean useEntitlements;
    private TempTableStore globalTables;
    private SessionAwareCache<PreparedPlan> planCache;
    private boolean resultSetCacheEnabled = true;

    void initialize(RequestMessage requestMsg, BufferManager bufferManager, ProcessorDataManager processorDataManager, TransactionService transactionService, TempTableStore tempTableStore, DQPWorkContext workContext, boolean useEntitlements, SessionAwareCache<PreparedPlan> planCache) {
        this.requestMsg = requestMsg;
        this.vdbName = workContext.getVdbName();
        this.vdbVersion = workContext.getVdbVersion();
        this.bufferManager = bufferManager;
        this.processorDataManager = processorDataManager;
        this.transactionService = transactionService;
        this.tempTableStore = tempTableStore;
        this.idGenerator.setDefaultFactory(new IntegerIDFactory());
        this.workContext = workContext;
        this.requestId = workContext.getRequestID(this.requestMsg.getExecutionId());
        this.connectorManagerRepo = (ConnectorManagerRepository)workContext.getVDB().getAttachment(ConnectorManagerRepository.class);
        this.useEntitlements = useEntitlements && !workContext.getVDB().getDataPolicies().isEmpty();
        this.planCache = planCache;
    }

    void setMetadata(CapabilitiesFinder capabilitiesFinder, QueryMetadataInterface metadata, Set multiSourceModels) {
        this.capabilitiesFinder = capabilitiesFinder;
        this.metadata = metadata;
        this.multiSourceModels = multiSourceModels;
    }

    public void setResultSetCacheEnabled(boolean resultSetCacheEnabled) {
        this.resultSetCacheEnabled = resultSetCacheEnabled;
    }

    protected void initMetadata() throws TeiidComponentException {
        if (this.metadata != null) {
            return;
        }
        this.capabilitiesFinder = new CachedFinder(this.connectorManagerRepo, this.workContext.getVDB());
        this.capabilitiesFinder = new TempCapabilitiesFinder(this.capabilitiesFinder);
        VDBMetaData vdbMetadata = this.workContext.getVDB();
        this.metadata = (QueryMetadataInterface)vdbMetadata.getAttachment(QueryMetadataInterface.class);
        this.globalTables = (TempTableStore)vdbMetadata.getAttachment(TempTableStore.class);
        if (this.metadata == null) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("DQPCore.Unable_to_load_metadata_for_VDB_name__{0},_version__{1}", new Object[]{this.vdbName, this.vdbVersion}));
        }
        this.metadata = new TempMetadataAdapter(this.metadata, new TempMetadataStore());
        Set multiSourceModelList = this.workContext.getVDB().getMultiSourceModelNames();
        if (multiSourceModelList != null && multiSourceModelList.size() > 0) {
            this.multiSourceModels = multiSourceModelList;
            this.metadata = new MultiSourceMetadataWrapper(this.metadata, this.multiSourceModels);
        }
    }

    protected void createCommandContext() throws QueryValidatorException {
        boolean returnsResultSet = this.userCommand.returnsResultSet();
        boolean bl = this.returnsUpdateCount = !(this.userCommand instanceof StoredProcedure) && !returnsResultSet;
        if (this.requestMsg.getResultsMode() == RequestMessage.ResultsMode.UPDATECOUNT && !this.returnsUpdateCount || this.requestMsg.getResultsMode() == RequestMessage.ResultsMode.RESULTSET && !returnsResultSet) {
            throw new QueryValidatorException(QueryPlugin.Util.getString(this.requestMsg.getResultsMode() == RequestMessage.ResultsMode.RESULTSET ? "Request.no_result_set" : "Request.result_set"));
        }
        String groupName = this.workContext.getSessionId();
        RequestID reqID = this.workContext.getRequestID(this.requestMsg.getExecutionId());
        Properties props = new Properties();
        props.setProperty("sessionid", this.workContext.getSessionId());
        this.context = new CommandContext(reqID, groupName, this.workContext.getUserName(), this.requestMsg.getExecutionPayload(), this.workContext.getVdbName(), this.workContext.getVdbVersion(), props, this.requestMsg.getShowPlan() != RequestMessage.ShowPlan.OFF);
        this.context.setProcessorBatchSize(this.bufferManager.getProcessorBatchSize());
        this.context.setConnectorBatchSize(this.bufferManager.getConnectorBatchSize());
        this.context.setGlobalTableStore(this.globalTables);
        if (this.multiSourceModels != null) {
            MultiSourcePlanToProcessConverter modifier = new MultiSourcePlanToProcessConverter(this.metadata, this.idGenerator, this.analysisRecord, this.capabilitiesFinder, this.multiSourceModels, this.workContext, this.context);
            this.context.setPlanToProcessConverter(modifier);
        }
        this.context.setSecurityFunctionEvaluator(new SecurityFunctionEvaluator(){

            @Override
            public boolean hasRole(String roleType, String roleName) throws TeiidComponentException {
                if (!Request.this.useEntitlements) {
                    return true;
                }
                if (!"data".equalsIgnoreCase(roleType)) {
                    return false;
                }
                return Request.this.workContext.getAllowedDataPolicies().containsKey(roleName);
            }
        });
        this.context.setTempTableStore(this.tempTableStore);
        this.context.setQueryProcessorFactory(new QueryProcessorFactoryImpl(this.bufferManager, this.processorDataManager, this.capabilitiesFinder, this.idGenerator, this.metadata));
        this.context.setMetadata(this.metadata);
        this.context.setBufferManager(this.bufferManager);
        this.context.setPreparedPlanCache(this.planCache);
        this.context.setResultSetCacheEnabled(this.resultSetCacheEnabled);
    }

    protected void checkReferences(List<Reference> references) throws QueryValidatorException {
        Request.referenceCheck(references);
    }

    static void referenceCheck(List<Reference> references) throws QueryValidatorException {
        if (references != null && !references.isEmpty()) {
            throw new QueryValidatorException(QueryPlugin.Util.getString("Request.Invalid_character_in_query"));
        }
    }

    protected void resolveCommand(Command command) throws QueryResolverException, TeiidComponentException {
        if (this.tempTableStore != null) {
            QueryResolver.setChildMetadata(command, this.tempTableStore.getMetadataStore().getData(), null);
        }
        QueryResolver.resolveCommand(command, this.metadata, this.analysisRecord);
        this.userCommand = (Command)command.clone();
    }

    private void validateQuery(Command command) throws QueryValidatorException, TeiidComponentException {
        ValidationVisitor visitor = new ValidationVisitor();
        Request.validateWithVisitor(visitor, this.metadata, command);
    }

    private Command parseCommand() throws QueryParserException {
        String[] commands = this.requestMsg.getCommands();
        ParseInfo parseInfo = Request.createParseInfo(this.requestMsg);
        if (this.requestMsg.isPreparedStatement() || this.requestMsg.isCallableStatement() || !this.requestMsg.isBatchedUpdate()) {
            String commandStr = commands[0];
            return QueryParser.getQueryParser().parseCommand(commandStr, parseInfo);
        }
        ArrayList<Command> parsedCommands = new ArrayList<Command>(commands.length);
        for (int i = 0; i < commands.length; ++i) {
            String updateCommand = commands[i];
            parsedCommands.add(QueryParser.getQueryParser().parseCommand(updateCommand, parseInfo));
        }
        return new BatchedUpdateCommand(parsedCommands);
    }

    public static ParseInfo createParseInfo(RequestMessage requestMsg) {
        ParseInfo parseInfo = new ParseInfo();
        parseInfo.ansiQuotedIdentifiers = requestMsg.isAnsiQuotedIdentifiers();
        return parseInfo;
    }

    public static void validateWithVisitor(AbstractValidationVisitor visitor, QueryMetadataInterface metadata, Command command) throws QueryValidatorException, TeiidComponentException {
        ValidatorReport report = Validator.validate(command, metadata, visitor);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
            throw new QueryValidatorException(firstFailure.getMessage());
        }
    }

    private void createProcessor() throws TeiidComponentException {
        TransactionContext tc = this.transactionService.getOrCreateTransactionContext(this.workContext.getSessionId());
        Assertion.assertTrue((tc.getTransactionType() != TransactionContext.Scope.REQUEST ? 1 : 0) != 0, (String)"Transaction already associated with request.");
        if (tc.getTransactionType() == TransactionContext.Scope.NONE) {
            boolean startAutoWrapTxn = false;
            if ("ON".equals(this.requestMsg.getTxnAutoWrapMode())) {
                startAutoWrapTxn = true;
            } else if ("DETECT".equals(this.requestMsg.getTxnAutoWrapMode())) {
                boolean transactionalRead = this.requestMsg.getTransactionIsolation() == 4 || this.requestMsg.getTransactionIsolation() == 8;
                startAutoWrapTxn = this.processPlan.requiresTransaction(transactionalRead);
            }
            if (startAutoWrapTxn) {
                try {
                    tc = this.transactionService.begin(tc);
                }
                catch (XATransactionException err) {
                    throw new TeiidComponentException((Throwable)err);
                }
            }
        }
        this.transactionContext = tc;
        this.processor = new QueryProcessor(this.processPlan, this.context, this.bufferManager, this.processorDataManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generatePlan() throws TeiidComponentException, TeiidProcessingException {
        QueryCommand query;
        Command command = this.parseCommand();
        List<Reference> references = ReferenceCollectorVisitor.getReferences(command);
        this.checkReferences(references);
        this.analysisRecord = new AnalysisRecord(this.requestMsg.getShowPlan() != RequestMessage.ShowPlan.OFF, this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.DEBUG);
        this.resolveCommand(command);
        this.validateAccess(this.userCommand);
        this.createCommandContext();
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)command, true);
        for (GroupSymbol groupSymbol : groups) {
            if (!groupSymbol.isTempTable()) continue;
            this.context.setDeterminismLevel(3);
            break;
        }
        this.validateQuery(command);
        command = QueryRewriter.rewrite(command, this.metadata, this.context);
        if (this.requestMsg.getRowLimit() > 0 && command instanceof QueryCommand && (query = (QueryCommand)command).getLimit() == null) {
            query.setLimit(new Limit(null, new Constant(new Integer(this.requestMsg.getRowLimit()), DataTypeManager.DefaultDataClasses.INTEGER)));
            this.addedLimit = true;
        }
        try {
            block11: {
                String debugLog;
                boolean debug;
                CapabilitiesFinder finder = this.capabilitiesFinder;
                if (this.multiSourceModels != null) {
                    finder = new MultiSourceCapabilitiesFinder(finder, this.multiSourceModels);
                }
                if (debug = this.analysisRecord.recordDebug()) {
                    this.analysisRecord.println("\n============================================================================");
                    this.analysisRecord.println("USER COMMAND:\n" + command);
                }
                try {
                    this.processPlan = QueryOptimizer.optimizePlan(command, this.metadata, this.idGenerator, finder, this.analysisRecord, this.context);
                    debugLog = this.analysisRecord.getDebugLog();
                    if (debugLog == null || debugLog.length() <= 0) break block11;
                }
                catch (Throwable throwable) {
                    String debugLog2 = this.analysisRecord.getDebugLog();
                    if (debugLog2 != null && debugLog2.length() > 0) {
                        LogManager.log((int)(this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.DEBUG ? 4 : 6), (String)"org.teiid.PLANNER", (Object)debugLog2);
                    }
                    if (this.analysisRecord.recordAnnotations() && this.analysisRecord.getAnnotations() != null && !this.analysisRecord.getAnnotations().isEmpty()) {
                        LogManager.logDetail((String)"org.teiid.PLANNER", (Object[])new Object[]{this.analysisRecord.getAnnotations()});
                    }
                    throw throwable;
                }
                LogManager.log((int)(this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.DEBUG ? 4 : 6), (String)"org.teiid.PLANNER", (Object)debugLog);
            }
            if (this.analysisRecord.recordAnnotations() && this.analysisRecord.getAnnotations() != null && !this.analysisRecord.getAnnotations().isEmpty()) {
                LogManager.logDetail((String)"org.teiid.PLANNER", (Object[])new Object[]{this.analysisRecord.getAnnotations()});
            }
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{QueryPlugin.Util.getString("BasicInterceptor.ProcessTree_for__4"), this.requestId, this.processPlan});
        }
        catch (QueryMetadataException e) {
            throw new QueryPlannerException((Throwable)((Object)e), QueryPlugin.Util.getString("DQPCore.Unknown_query_metadata_exception_while_registering_query__{0}.", new Object[]{this.requestId}));
        }
    }

    public void processRequest() throws TeiidComponentException, TeiidProcessingException {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this.requestId, "executing", this.requestMsg.isPreparedStatement() ? "prepared" : "", this.requestMsg.getCommandString()});
        this.initMetadata();
        this.generatePlan();
        this.postProcessXML();
        this.createProcessor();
    }

    private void postProcessXML() {
        if (this.requestMsg.getXMLFormat() != null && this.processPlan instanceof XMLPlan) {
            ((XMLPlan)this.processPlan).setXMLFormat(this.requestMsg.getXMLFormat());
        }
        this.context.setValidateXML(this.requestMsg.getValidationMode());
    }

    protected void validateAccess(Command command) throws QueryValidatorException, TeiidComponentException {
        if (this.useEntitlements) {
            AuthorizationValidationVisitor visitor = new AuthorizationValidationVisitor(this.workContext.getAllowedDataPolicies(), this.workContext.getUserName());
            Request.validateWithVisitor(visitor, this.metadata, command);
        }
    }
}

