/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.cache.Cachable;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCache;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.logging.LogManager;
import org.teiid.query.parser.ParseInfo;
import org.teiid.vdb.runtime.VDBKey;

public class SessionAwareCache<T> {
    public static final int DEFAULT_MAX_SIZE_TOTAL = 512;
    private Cache<CacheID, T> localCache;
    private Cache<CacheID, T> distributedCache;
    private Cache tupleBatchCache;
    private int maxSize = 512;
    private AtomicInteger cacheHit = new AtomicInteger();
    private AtomicInteger totalRequests = new AtomicInteger();
    private BufferManager bufferManager;

    public SessionAwareCache() {
        this(512);
    }

    SessionAwareCache(int maxSize) {
        this(new DefaultCacheFactory(), Type.RESULTSET, new CacheConfiguration(CacheConfiguration.Policy.LRU, 60, maxSize, "default"));
    }

    SessionAwareCache(CacheFactory cacheFactory, Type type, CacheConfiguration config) {
        this.maxSize = config.getMaxEntries();
        if (this.maxSize < 0) {
            this.maxSize = Integer.MAX_VALUE;
        }
        this.localCache = new DefaultCache<CacheID, T>("local", this.maxSize, config.getMaxAgeInSeconds() * 1000);
        if (type == Type.PREPAREDPLAN) {
            this.distributedCache = this.localCache;
        } else {
            String location = config.getLocation() + "/" + type.name();
            this.distributedCache = cacheFactory.get(location, config);
            this.tupleBatchCache = type == Type.RESULTSET ? cacheFactory.get(location + "/batches", config) : this.distributedCache;
        }
    }

    public T get(CacheID id) {
        this.totalRequests.getAndIncrement();
        id.setSessionId(id.originalSessionId);
        T result = this.localCache.get(id);
        if (result == null) {
            Cachable c;
            id.setSessionId(null);
            id.setUserName(id.originalUserName);
            result = this.distributedCache.get(id);
            if (result == null) {
                id.setUserName(null);
                result = this.distributedCache.get(id);
            }
            if (result != null && result instanceof Cachable && !(c = (Cachable)result).restore(this.tupleBatchCache, this.bufferManager)) {
                result = null;
            }
        }
        if (result != null) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Cache hit for", id});
            this.cacheHit.getAndIncrement();
        } else {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Cache miss for", id});
        }
        return result;
    }

    public int getCacheHitCount() {
        return this.cacheHit.get();
    }

    public int getRequestCount() {
        return this.totalRequests.get();
    }

    public int getTotalCacheEntries() {
        if (this.localCache == this.distributedCache) {
            return this.localCache.size();
        }
        return this.localCache.size() + this.distributedCache.size();
    }

    public void put(CacheID id, int determinismLevel, T t, Long ttl) {
        if (determinismLevel >= 3) {
            id.setSessionId(id.originalSessionId);
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Adding to session/local cache", id});
            this.localCache.put(id, t, ttl);
        } else {
            boolean insert = true;
            id.setSessionId(null);
            if (determinismLevel == 2) {
                id.setUserName(id.originalUserName);
            } else {
                id.setUserName(null);
            }
            if (t instanceof Cachable) {
                Cachable c = (Cachable)t;
                insert = c.prepare(this.tupleBatchCache, this.bufferManager);
            }
            if (insert) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Adding to global/distributed cache", id});
                this.distributedCache.put(id, t, ttl);
            }
        }
    }

    public void clearAll() {
        this.localCache.clear();
        this.distributedCache.clear();
        this.totalRequests = new AtomicInteger();
        this.cacheHit = new AtomicInteger();
    }

    public void clearForVDB(String vdbName, int version) {
        this.clearCache(this.localCache, vdbName, version);
        this.clearCache(this.distributedCache, vdbName, version);
    }

    private void clearCache(Cache<CacheID, T> cache, String vdbName, int version) {
        Set<CacheID> keys = cache.keys();
        VDBKey vdbKey = new VDBKey(vdbName, version);
        for (CacheID key : keys) {
            if (!key.vdbInfo.equals(vdbKey)) continue;
            cache.remove(key);
        }
    }

    int getSpaceAllowed() {
        return this.maxSize;
    }

    public void setBufferManager(BufferManager bufferManager) {
        this.bufferManager = bufferManager;
    }

    public static class CacheID
    implements Serializable {
        private static final long serialVersionUID = 8261905111156764744L;
        private String sql;
        private VDBKey vdbInfo;
        private ParseInfo pi;
        private String sessionId;
        private String originalSessionId;
        private List<Serializable> parameters;
        private String userName;
        private String originalUserName;

        public CacheID(DQPWorkContext context, ParseInfo pi, String sql) {
            this(pi, sql, context.getVdbName(), context.getVdbVersion(), context.getSessionId(), context.getUserName());
        }

        public CacheID(ParseInfo pi, String sql, String vdbName, int vdbVersion, String sessionId, String userName) {
            this.sql = sql;
            this.vdbInfo = new VDBKey(vdbName, vdbVersion);
            this.pi = pi;
            this.originalSessionId = sessionId;
            this.originalUserName = userName;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getUserName() {
            return this.userName;
        }

        private void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public boolean setParameters(List<?> parameters) {
            if (parameters != null && !parameters.isEmpty()) {
                this.parameters = new ArrayList<Serializable>();
                for (Object obj : parameters) {
                    if (obj == null) {
                        this.parameters.add(null);
                        continue;
                    }
                    if (!(obj instanceof Serializable)) {
                        return false;
                    }
                    Class type = DataTypeManager.determineDataTypeClass(obj);
                    if (DataTypeManager.isLOB((Class)type) || type == DataTypeManager.DefaultDataClasses.OBJECT) {
                        return false;
                    }
                    this.parameters.add((Serializable)obj);
                }
            }
            return true;
        }

        public String getSql() {
            return this.sql;
        }

        void setUserName(String name) {
            this.userName = name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheID)) {
                return false;
            }
            CacheID that = (CacheID)obj;
            return EquivalenceUtil.areEqual((Object)this.pi, (Object)that.pi) && this.vdbInfo.equals(that.vdbInfo) && this.sql.equals(that.sql) && EquivalenceUtil.areEqual((Object)this.userName, (Object)that.userName) && EquivalenceUtil.areEqual((Object)this.sessionId, (Object)that.sessionId) && EquivalenceUtil.areEqual(this.parameters, that.parameters);
        }

        public int hashCode() {
            return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.vdbInfo, this.sql, this.pi, this.userName, this.sessionId, this.parameters});
        }

        public String toString() {
            return "Cache Entry<" + this.originalSessionId + "=" + this.originalUserName + "> params:" + this.parameters + " sql:" + this.sql;
        }
    }

    public static enum Type {
        RESULTSET,
        PREPAREDPLAN;

    }
}

