/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.TimeValue;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.CharsetUtils;
import org.teiid.query.processor.xml.XMLUtil;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.WSConnection;

public class XMLSystemFunctions {
    private static final String P_OUTPUT_VALIDATE_STRUCTURE = "com.ctc.wstx.outputValidateStructure";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClobType xslTransform(CommandContext context, Object xml, Object styleSheet) throws Exception {
        Source styleSource = null;
        Source xmlSource = null;
        try {
            styleSource = XMLSystemFunctions.convertToSource(styleSheet);
            final Source xmlParam = xmlSource = XMLSystemFunctions.convertToSource(xml);
            TransformerFactory factory = TransformerFactory.newInstance();
            final Transformer transformer = factory.newTransformer(styleSource);
            SQLXMLImpl result = XMLUtil.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

                public void translate(Writer writer) throws TransformerException {
                    transformer.transform(xmlParam, new StreamResult(writer));
                }
            });
            ClobType clobType = new ClobType((Clob)new ClobImpl(result.getStreamFactory(), -1L));
            return clobType;
        }
        finally {
            WSConnection.Util.closeSource((Source)styleSource);
            WSConnection.Util.closeSource((Source)xmlSource);
        }
    }

    public static XMLType xmlForest(CommandContext context, final Evaluator.NameValuePair[] namespaces, final Evaluator.NameValuePair[] values) throws TeiidComponentException, TeiidProcessingException {
        boolean valueExists = false;
        for (Evaluator.NameValuePair nameValuePair : values) {
            if (nameValuePair.value == null) continue;
            valueExists = true;
            break;
        }
        if (!valueExists) {
            return null;
        }
        XMLType result = new XMLType((SQLXML)XMLUtil.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                try {
                    XMLOutputFactory factory = XMLSystemFunctions.getOutputFactory();
                    XMLEventWriter eventWriter = factory.createXMLEventWriter(writer);
                    XMLEventFactory eventFactory = XMLEventFactory.newInstance();
                    for (Evaluator.NameValuePair nameValuePair : values) {
                        if (nameValuePair.value == null) continue;
                        XMLSystemFunctions.addElement(nameValuePair.name, writer, eventWriter, eventFactory, namespaces, null, Collections.singletonList(nameValuePair.value));
                    }
                    eventWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new TransformerException(e);
                }
            }
        }));
        result.setType(XMLType.Type.CONTENT);
        return result;
    }

    public static XMLType xmlElement(CommandContext context, final String name, final Evaluator.NameValuePair<String>[] namespaces, final Evaluator.NameValuePair<?>[] attributes, final List<?> contents) throws TeiidComponentException, TeiidProcessingException {
        XMLType result = new XMLType((SQLXML)XMLUtil.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                try {
                    XMLOutputFactory factory = XMLSystemFunctions.getOutputFactory();
                    XMLEventWriter eventWriter = factory.createXMLEventWriter(writer);
                    XMLEventFactory eventFactory = XMLEventFactory.newInstance();
                    XMLSystemFunctions.addElement(name, writer, eventWriter, eventFactory, namespaces, attributes, contents);
                    eventWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new TransformerException(e);
                }
            }
        }));
        result.setType(XMLType.Type.ELEMENT);
        return result;
    }

    private static void addElement(String name, Writer writer, XMLEventWriter eventWriter, XMLEventFactory eventFactory, Evaluator.NameValuePair<String>[] namespaces, Evaluator.NameValuePair<?>[] attributes, List<?> contents) throws XMLStreamException, IOException, TransformerException {
        eventWriter.add(eventFactory.createStartElement("", null, name));
        if (namespaces != null) {
            for (Evaluator.NameValuePair<String> nameValuePair : namespaces) {
                if (nameValuePair.name == null) {
                    if (nameValuePair.value == null) {
                        eventWriter.add(eventFactory.createNamespace(""));
                        continue;
                    }
                    eventWriter.add(eventFactory.createNamespace((String)nameValuePair.value));
                    continue;
                }
                eventWriter.add(eventFactory.createNamespace(nameValuePair.name, (String)nameValuePair.value));
            }
        }
        if (attributes != null) {
            for (Evaluator.NameValuePair<String> nameValuePair : attributes) {
                if (nameValuePair.value == null) continue;
                eventWriter.add(eventFactory.createAttribute(new QName(nameValuePair.name), XMLSystemFunctions.convertToAtomicValue(nameValuePair.value).getStringValue()));
            }
        }
        eventWriter.add(eventFactory.createCharacters(""));
        for (Object object : contents) {
            XMLSystemFunctions.convertValue(writer, eventWriter, eventFactory, object);
        }
        eventWriter.add(eventFactory.createEndElement("", null, name));
    }

    public static XMLType xmlConcat(CommandContext context, final XMLType xml, final Object ... other) throws TeiidComponentException, TeiidProcessingException {
        XMLType singleValue = xml;
        XMLType.Type type = null;
        for (Object object : other) {
            if (object == null) continue;
            if (singleValue != null) {
                type = XMLType.Type.CONTENT;
                break;
            }
            if (object instanceof XMLType) {
                singleValue = (XMLType)object;
                continue;
            }
            type = XMLType.Type.CONTENT;
            break;
        }
        if (type == null) {
            return singleValue;
        }
        XMLType result = new XMLType((SQLXML)XMLUtil.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                try {
                    XMLOutputFactory factory = XMLSystemFunctions.getOutputFactory();
                    XMLEventWriter eventWriter = factory.createXMLEventWriter(writer);
                    XMLEventFactory eventFactory = XMLEventFactory.newInstance();
                    XMLSystemFunctions.convertValue(writer, eventWriter, eventFactory, xml);
                    for (Object object : other) {
                        XMLSystemFunctions.convertValue(writer, eventWriter, eventFactory, object);
                    }
                    eventWriter.flush();
                }
                catch (XMLStreamException e) {
                    throw new TransformerException(e);
                }
            }
        }));
        result.setType(XMLType.Type.CONTENT);
        return result;
    }

    private static XMLOutputFactory getOutputFactory() throws FactoryConfigurationError {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        if (factory.isPropertySupported(P_OUTPUT_VALIDATE_STRUCTURE)) {
            factory.setProperty(P_OUTPUT_VALIDATE_STRUCTURE, false);
        }
        return factory;
    }

    public static XMLType xmlPi(String name) {
        return XMLSystemFunctions.xmlPi(name, "");
    }

    public static XMLType xmlPi(String name, String content) {
        int start;
        char[] chars = content.toCharArray();
        for (start = 0; start < chars.length && chars[start] == ' '; ++start) {
        }
        XMLType result = new XMLType((SQLXML)new SQLXMLImpl("<?" + name + " " + content.substring(start) + "?>"));
        result.setType(XMLType.Type.PI);
        return result;
    }

    public static AtomicValue convertToAtomicValue(Object value) throws TransformerException {
        if (value instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)value;
            DateTimeValue tdv = DateTimeValue.fromJavaDate((java.util.Date)d);
            if (value instanceof Date) {
                value = new DateValue(tdv.getYear(), tdv.getMonth(), tdv.getDay(), tdv.getTimezoneInMinutes());
            } else if (value instanceof Time) {
                value = new TimeValue(tdv.getHour(), tdv.getMinute(), tdv.getSecond(), tdv.getMicrosecond(), tdv.getTimezoneInMinutes());
            } else if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                value = tdv.add((DurationValue)DayTimeDurationValue.fromMicroseconds((long)(ts.getNanos() / 1000)));
            }
            return (AtomicValue)value;
        }
        JPConverter converter = JPConverter.allocate(value.getClass(), null);
        return (AtomicValue)converter.convert(value, null);
    }

    static void convertValue(Writer writer, XMLEventWriter eventWriter, XMLEventFactory eventFactory, Object object) throws IOException, FactoryConfigurationError, XMLStreamException, TransformerException {
        if (object == null) {
            return;
        }
        Reader r = null;
        try {
            if (object instanceof XMLType) {
                XMLType xml = (XMLType)object;
                r = xml.getCharacterStream();
                XMLType.Type type = xml.getType();
                XMLSystemFunctions.convertReader(writer, eventWriter, r, type);
            } else if (object instanceof Clob) {
                Clob clob = (Clob)object;
                r = clob.getCharacterStream();
                XMLSystemFunctions.convertReader(writer, eventWriter, r, XMLType.Type.TEXT);
            } else {
                String val = XMLSystemFunctions.convertToAtomicValue(object).getStringValue();
                eventWriter.add(eventFactory.createCharacters(val));
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private static void convertReader(Writer writer, XMLEventWriter eventWriter, Reader r, XMLType.Type type) throws XMLStreamException, IOException, FactoryConfigurationError {
        switch (type) {
            case CONTENT: 
            case ELEMENT: 
            case PI: 
            case COMMENT: {
                eventWriter.flush();
                char[] buf = new char[8192];
                int read = -1;
                while ((read = r.read(buf)) != -1) {
                    writer.write(buf, 0, read);
                }
                break;
            }
            case UNKNOWN: 
            case DOCUMENT: {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                if (!(r instanceof BufferedReader)) {
                    r = new BufferedReader(r);
                }
                XMLEventReader eventReader = inputFactory.createXMLEventReader(r);
                eventReader = inputFactory.createFilteredReader(eventReader, new EventFilter(){

                    @Override
                    public boolean accept(XMLEvent event) {
                        return !event.isStartDocument() && !event.isEndDocument();
                    }
                });
                eventWriter.add(eventReader);
                break;
            }
            case TEXT: {
                XMLEventFactory eventFactory = XMLEventFactory.newInstance();
                char[] buf = new char[8192];
                int read = -1;
                while ((read = r.read(buf)) != -1) {
                    eventWriter.add(eventFactory.createCharacters(new String(buf, 0, read)));
                }
                break;
            }
        }
    }

    public static XMLType xmlComment(String comment) {
        return new XMLType((SQLXML)new SQLXMLImpl("<!--" + comment + "-->"));
    }

    public static Source convertToSource(Object value) throws TeiidProcessingException {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof SQLXML) {
                return ((SQLXML)value).getSource(null);
            }
            if (value instanceof Clob) {
                return new StreamSource(((Clob)value).getCharacterStream());
            }
            if (value instanceof Blob) {
                return new StreamSource(((Blob)value).getBinaryStream());
            }
            if (value instanceof String) {
                return new StreamSource(new StringReader((String)value));
            }
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
        throw new AssertionError((Object)"Unknown type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xpathValue(Object doc, String xpath) throws XPathException, TeiidProcessingException {
        Source s = null;
        try {
            s = XMLSystemFunctions.convertToSource(doc);
            XPathEvaluator eval = new XPathEvaluator();
            XPathExpression expr = eval.createExpression(xpath);
            Object o = expr.evaluateSingle(s);
            if (o == null) {
                String string = null;
                return string;
            }
            if (o instanceof Item) {
                String string = ((Item)o).getStringValue();
                return string;
            }
            String string = o.toString();
            return string;
        }
        finally {
            WSConnection.Util.closeSource((Source)s);
        }
    }

    public static void validateXpath(String xpath) throws XPathException {
        if (xpath == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator();
        eval.createExpression(xpath);
    }

    public static String escapeName(String name, boolean fully) {
        StringBuilder sb = new StringBuilder();
        char[] chars = name.toCharArray();
        int i = 0;
        if (fully && name.regionMatches(true, 0, "xml", 0, 3)) {
            sb.append(XMLSystemFunctions.escapeChar(name.charAt(0)));
            sb.append(chars, 1, 2);
            i = 3;
        }
        while (i < chars.length) {
            block8: {
                char chr = chars[i];
                switch (chr) {
                    case ':': {
                        if (!fully && i != 0) break;
                        sb.append(XMLSystemFunctions.escapeChar(chr));
                        break block8;
                    }
                    case '_': {
                        if (chars.length <= i || chars[i + 1] != 'x') break;
                        sb.append(XMLSystemFunctions.escapeChar(chr));
                        break block8;
                    }
                    default: {
                        if (i == 0) {
                            if (Name11Checker.getInstance().isNCNameStartChar((int)chr)) break;
                            sb.append(XMLSystemFunctions.escapeChar(chr));
                        } else {
                            if (Name11Checker.getInstance().isNCNameChar((int)chr)) break;
                            sb.append(XMLSystemFunctions.escapeChar(chr));
                        }
                        break block8;
                    }
                }
                sb.append(chr);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String escapeChar(char chr) {
        CharBuffer cb = CharBuffer.allocate(7);
        cb.append("_u");
        CharsetUtils.toHex(cb, (byte)(chr >> 8));
        CharsetUtils.toHex(cb, (byte)chr);
        return cb.append("_").flip().toString();
    }
}

