/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;

public abstract class MappingBaseNode
extends MappingNode {
    String recursionId;

    protected MappingBaseNode() {
    }

    public MappingBaseNode setMinOccurrs(int cardinality) {
        this.setProperty(MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND, new Integer(cardinality));
        return this;
    }

    public MappingBaseNode setMaxOccurrs(int cardinality) {
        this.setProperty(MappingNodeConstants.Properties.CARDINALITY_MAX_BOUND, new Integer(cardinality));
        return this;
    }

    public MappingBaseNode setSource(String source) {
        if (source != null) {
            this.setProperty(MappingNodeConstants.Properties.RESULT_SET_NAME, source);
        } else {
            this.removeProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        }
        return this;
    }

    public String getSource() {
        return (String)this.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
    }

    public MappingElement addChildElement(MappingElement elem) {
        if (elem.isRecursive()) {
            MappingRecursiveElement recursiveElement = (MappingRecursiveElement)elem;
            MappingBaseNode recursiveRoot = this.getRecursiveRootNode(recursiveElement);
            recursiveRoot.setRootRecursiveNode(true, recursiveElement.getMappingClass().toUpperCase());
            this.addChild(elem);
        } else {
            this.addChild(elem);
        }
        return elem;
    }

    private MappingBaseNode getRecursiveRootNode(MappingRecursiveElement elem) {
        if (this.hasSource(elem.getMappingClass())) {
            return this;
        }
        MappingBaseNode parent = this.getParentNode();
        if (parent != null) {
            return parent.getRecursiveRootNode(elem);
        }
        throw new TeiidRuntimeException(QueryPlugin.Util.getString("invalid_recurive_node", new Object[]{elem}));
    }

    private boolean hasSource(String source) {
        return source.equals(this.getSource());
    }

    public MappingChoiceNode addChoiceNode(MappingChoiceNode elem) {
        this.addChild(elem);
        return elem;
    }

    public MappingSequenceNode addSequenceNode(MappingSequenceNode elem) {
        this.addChild(elem);
        return elem;
    }

    public MappingAllNode addAllNode(MappingAllNode elem) {
        this.addChild(elem);
        return elem;
    }

    public MappingSourceNode addSourceNode(MappingSourceNode elem) {
        this.addChild(elem);
        return elem;
    }

    public MappingCriteriaNode addCriteriaNode(MappingCriteriaNode node) {
        this.addChild(node);
        return node;
    }

    public MappingBaseNode getParentNode() {
        if (this.getParent() instanceof MappingBaseNode) {
            return (MappingBaseNode)this.getParent();
        }
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    public String getCanonicalName() {
        return this.getFullyQualifiedName().toUpperCase();
    }

    public void removeChildNode(MappingBaseNode toRemove) {
        this.getChildren().remove(toRemove);
    }

    public int getMinOccurence() {
        Integer occur = (Integer)this.getProperty(MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND);
        if (occur != null) {
            return occur;
        }
        return 1;
    }

    public int getMaxOccurence() {
        Integer occur = (Integer)this.getProperty(MappingNodeConstants.Properties.CARDINALITY_MAX_BOUND);
        if (occur != null) {
            return occur;
        }
        return 1;
    }

    void setRootRecursiveNode(boolean root, String recursionId) {
        this.setProperty(MappingNodeConstants.Properties.IS_RECURSIVE_ROOT, root);
        this.recursionId = recursionId;
    }

    public String getRecursionId() {
        return this.recursionId;
    }

    public boolean isRootRecursiveNode() {
        return Boolean.TRUE.equals(this.getProperty(MappingNodeConstants.Properties.IS_RECURSIVE_ROOT));
    }

    public MappingDocument getDocument() {
        if (this.isDocumentNode()) {
            return (MappingDocument)this;
        }
        return this.getParentNode().getDocument();
    }

    public boolean isDocumentNode() {
        return false;
    }

    public boolean isTagRoot() {
        return false;
    }

    public List getStagingTables() {
        return (List)this.getProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES);
    }

    public void setStagingTables(List tables) {
        if (tables != null) {
            this.setProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES, tables);
        } else {
            this.removeProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES);
        }
    }

    public void addStagingTable(String tablename) {
        if (tablename == null) {
            return;
        }
        ArrayList<String> tables = this.getStagingTables();
        if (tables == null || tables == Collections.EMPTY_LIST) {
            tables = new ArrayList<String>();
        }
        tables.add(tablename);
        this.setProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES, tables);
    }
}

