/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.icons.impl;

import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.icons.impl.ImageComponent;
import org.jboss.tools.common.model.icons.impl.XModelObjectIcon;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

class ImageComponentWrapper
implements ImageComponent {
    String key;
    String classname;
    ImageComponent imageComponent;

    ImageComponentWrapper(String key, String classname) {
        this.key = key;
        this.classname = classname;
    }

    public int getHash(XModelObject obj) {
        this.validate();
        if (this.imageComponent == null) {
            return 0;
        }
        return this.imageComponent.getHash(obj);
    }

    public Image getImage(XModelObject obj) {
        this.validate();
        if (this.imageComponent == null) {
            return null;
        }
        return this.imageComponent.getImage(obj);
    }

    void validate() {
        try {
            ImageComponent c = (ImageComponent)ModelFeatureFactory.getInstance().createFeatureInstance(this.classname);
            if (c == null) {
                XModelObjectIcon.components.remove(this.key);
            } else {
                XModelObjectIcon.components.put(this.key, c);
            }
            this.imageComponent = c;
        }
        catch (ClassCastException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
            XModelObjectIcon.components.remove(this.key);
        }
    }
}

