/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.editor.NullEditorPart;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.COPWrapper;
import org.jboss.tools.common.model.ui.editor.EditorPartFactory;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapperExtension;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.util.IEditorWrapper;

public class EditorPartWrapper
extends EditorPart
implements IReusableEditor,
IEditorWrapper {
    public static final String EDITOR_ID = "org.jboss.tools.common.model.ui.editor.EditorPartWrapper";
    IEditorPart editor;
    String entity = null;
    static String DEFAULT_ENTITY = "xml";
    Composite parent;
    COPWrapper wrapper = null;

    public IEditorInput getEditorInput() {
        return super.getEditorInput();
    }

    public IEditorSite getEditorSite() {
        return super.getEditorSite();
    }

    public void gotoMarker(IMarker marker) {
        if (this.editor != null) {
            try {
                Class<?> editorClass = this.editor.getClass();
                Method method = editorClass.getMethod("gotoMarker", IMarker.class);
                method.setAccessible(true);
                method.invoke((Object)this.editor, marker);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.ignore();
            }
            catch (IllegalAccessException illegalAccessException) {
                this.ignore();
            }
            catch (InvocationTargetException e3) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e3);
            }
        }
    }

    void ignore() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if ((input = XModelObjectEditorInput.checkInput(input)) instanceof NullEditorInput) {
            this.entity = "";
            this.editor = new NullEditorPart();
            this.editor.init(site, input);
            this.setSite((IWorkbenchPartSite)site);
            super.setInput(input);
            return;
        }
        this.entity = this.computeEntity(input);
        EditorPartWrapperExtension extension = EditorPartWrapperExtension.getInstance();
        EditorPartFactory f = extension.getFactory(this.entity);
        this.editor = f.createEditorPart();
        if (this.editor != null) {
            ((WorkbenchPart)this.editor).setInitializationData(f.getConfigurationElement(), "", null);
        }
        this.editor.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
        this.editor.addPropertyListener((IPropertyListener)new PCL());
        super.setInput(input);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.parent != null && !this.parent.isDisposed()) {
            Control[] cs = this.parent.getChildren();
            int i = 0;
            while (i < cs.length) {
                if (!cs[i].isDisposed()) {
                    cs[i].dispose();
                }
                ++i;
            }
        }
        try {
            this.init((IEditorSite)this.getSite(), input);
        }
        catch (PartInitException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return;
        }
        if (this.parent != null && !this.parent.isDisposed()) {
            this.createPartControl(this.parent);
        }
        if (this.wrapper != null) {
            IContentOutlinePage outline = (IContentOutlinePage)this.editor.getAdapter(IContentOutlinePage.class);
            this.wrapper.setOutline(outline);
            if (outline instanceof Page) {
                ((SubActionBars)this.wrapper.getSite().getActionBars()).dispose();
                ((Page)outline).init(this.wrapper.getSite());
                this.wrapper.getSite().getActionBars().updateActionBars();
                Control[] cs = this.wrapper.control.getChildren();
                int i = 0;
                while (i < cs.length) {
                    if (!cs[i].isDisposed()) {
                        cs[i].dispose();
                    }
                    ++i;
                }
                outline.createControl(this.wrapper.control);
                outline.getControl().setLayoutData((Object)new GridData(1808));
                this.wrapper.control.update();
                this.wrapper.control.layout();
                this.wrapper.control.getParent().update();
                this.wrapper.control.getParent().layout();
                this.wrapper.control.getParent().getParent().update();
                this.wrapper.control.getParent().getParent().layout();
                ((SubActionBars)this.wrapper.getSite().getActionBars()).getToolBarManager().update(true);
            }
        }
    }

    private String computeEntity(IEditorInput input) {
        if (!(input instanceof IModelObjectEditorInput)) {
            return DEFAULT_ENTITY;
        }
        IModelObjectEditorInput i = (IModelObjectEditorInput)input;
        XModelObject o = i.getXModelObject();
        if (o == null) {
            return DEFAULT_ENTITY;
        }
        EditorPartWrapperExtension extension = EditorPartWrapperExtension.getInstance();
        EditorPartFactory f = extension.getFactory(o.getModelEntity().getName());
        if (f == null) {
            return DEFAULT_ENTITY;
        }
        return o.getModelEntity().getName();
    }

    public void addPropertyListener(IPropertyListener l) {
        super.addPropertyListener(l);
        if (this.editor != null) {
            this.editor.addPropertyListener(l);
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        if (this.editor != null) {
            this.editor.createPartControl(parent);
        }
        parent.layout();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        super.dispose();
    }

    public IWorkbenchPartSite getSite() {
        if (this.editor != null) {
            // empty if block
        }
        return super.getSite();
    }

    public String getTitle() {
        if (this.editor != null && !super.getTitle().equals(this.editor.getTitle())) {
            String title = this.editor.getTitle();
            this.setPartName(title);
        }
        return super.getTitle();
    }

    public Image getTitleImage() {
        return this.editor == null ? super.getTitleImage() : this.editor.getTitleImage();
    }

    public String getTitleToolTip() {
        return this.editor == null ? super.getTitleToolTip() : this.editor.getTitleToolTip();
    }

    public void removePropertyListener(IPropertyListener l) {
        super.removePropertyListener(l);
        if (this.editor != null) {
            this.editor.removePropertyListener(l);
        }
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.editor == null) {
            return super.getAdapter(adapter);
        }
        if (adapter != null && adapter.isAssignableFrom(IContentOutlinePage.class)) {
            if (this.wrapper != null) {
                return this.wrapper;
            }
            this.wrapper = new COPWrapper();
            IContentOutlinePage outline = (IContentOutlinePage)this.editor.getAdapter(adapter);
            this.wrapper.setOutline(outline);
            return this.wrapper;
        }
        return this.editor.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editor != null) {
            this.editor.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.editor != null) {
            this.editor.doSaveAs();
        }
    }

    public boolean isDirty() {
        return this.editor != null && this.editor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this.editor != null && this.editor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.editor != null && this.editor.isSaveOnCloseNeeded();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public String getEntity() {
        return this.entity;
    }

    class PCL
    implements IPropertyListener {
        PCL() {
        }

        public void propertyChanged(Object source, int i) {
            if (i == 258 && EditorPartWrapper.this.getEditorInput() != EditorPartWrapper.this.editor.getEditorInput()) {
                EditorPartWrapper.super.setInput(EditorPartWrapper.this.editor.getEditorInput());
            }
            EditorPartWrapper.this.firePropertyChange(i);
        }
    }
}

