/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CPDViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object object, int n) {
        Image image = null;
        TreeNode treeNode = (TreeNode)object;
        Object object2 = treeNode.getValue();
        switch (n) {
            case 1: {
                if (object2 instanceof Match) {
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    break;
                }
                if (!(object2 instanceof TokenEntry)) break;
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER");
            }
        }
        return image;
    }

    public String getColumnText(Object object, int n) {
        TreeNode treeNode = (TreeNode)object;
        Object object2 = treeNode.getValue();
        String string = "";
        switch (n) {
            case 2: {
                if (object2 instanceof Match) {
                    Match match = (Match)object2;
                    StringBuffer stringBuffer = new StringBuffer(50);
                    stringBuffer.append("Found suspect cut & paste (");
                    stringBuffer.append(match.getMarkCount()).append(" matches,");
                    stringBuffer.append(match.getLineCount());
                    if (match.getLineCount() == 1) {
                        stringBuffer.append(" line)");
                    } else {
                        stringBuffer.append(" lines)");
                    }
                    string = stringBuffer.toString();
                    break;
                }
                if (!(object2 instanceof TokenEntry)) break;
                TokenEntry tokenEntry = (TokenEntry)object2;
                Match match = (Match)treeNode.getParent().getValue();
                int n2 = tokenEntry.getBeginLine();
                int n3 = tokenEntry.getBeginLine() + match.getLineCount() - 1;
                IPath iPath = Path.fromOSString((String)tokenEntry.getTokenSrcID());
                StringBuffer stringBuffer = new StringBuffer(100);
                if (n2 == n3) {
                    stringBuffer.append("line ").append(n2);
                } else {
                    stringBuffer.append("lines ").append(n2).append('-').append(n3);
                }
                stringBuffer.append(" in file ").append(iPath.lastSegment());
                string = stringBuffer.toString();
                break;
            }
            case 3: {
                if (!(object2 instanceof TokenEntry)) break;
                TokenEntry tokenEntry = (TokenEntry)object2;
                IPath iPath = Path.fromOSString((String)tokenEntry.getTokenSrcID());
                IContainer iContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(iPath);
                if (iContainer == null) break;
                string = iContainer.getProjectRelativePath().removeFileExtension().toString().replace('/', '.');
            }
        }
        return string;
    }
}

