/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.hibernate.eclipse.hqleditor.HQLEditorInput;
import org.hibernate.eclipse.hqleditor.HQLEditorStorage;

public class HQLEditorInputFactory
implements IElementFactory {
    public static final String ID_FACTORY = "org.hibernate.eclipse.hqleditor.HQLEditorInputFactory";
    public static final String ID_STORAGE_EDITOR_INPUT = "HQLEditorStorageEditorInput";
    public static final String KEY_CONFIGURATION_NAME = "configurationname";
    public static final String KEY_EDITOR_INPUT_TYPE = "editorInputType";
    public static final String KEY_STORAGE_CONTENT = "storageContent";
    public static final String KEY_STORAGE_NAME = "storageName";

    public IAdaptable createElement(IMemento memento) {
        HQLEditorInput hqlStorageInput;
        HQLEditorInput input = null;
        memento.getString(KEY_EDITOR_INPUT_TYPE);
        String contentName = memento.getString(KEY_STORAGE_NAME);
        String contentString = memento.getString(KEY_STORAGE_CONTENT);
        String configurationName = memento.getString(KEY_CONFIGURATION_NAME);
        HQLEditorStorage storage = new HQLEditorStorage(configurationName, contentName, contentString);
        input = hqlStorageInput = new HQLEditorInput(storage);
        return input;
    }

    public static void saveState(IMemento memento, HQLEditorInput input) {
        memento.putString(KEY_EDITOR_INPUT_TYPE, ID_STORAGE_EDITOR_INPUT);
        String storageName = null;
        String storageContent = "";
        String configurationName = "";
        IStorage storage = input.getStorage();
        if (storage != null) {
            storageName = storage.getName();
            if (storage instanceof HQLEditorStorage) {
                HQLEditorStorage sqlEditorStorage = (HQLEditorStorage)storage;
                storageContent = sqlEditorStorage.getContentsString();
                configurationName = sqlEditorStorage.getConfigurationName();
            }
        }
        memento.putString(KEY_STORAGE_NAME, storageName);
        memento.putString(KEY_STORAGE_CONTENT, storageContent);
        memento.putString(KEY_CONFIGURATION_NAME, configurationName);
    }
}

