/*******************************************************************************
 * Copyright (c) 2009 Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributor:
 *     Red Hat, Inc. - initial API and implementation
 ******************************************************************************/

package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;

import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmBaseJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmEntity;
import org.eclipse.jpt.core.internal.jpa2.context.orm.NullOrmCacheable2_0;
import org.eclipse.jpt.core.jpa2.context.CacheableHolder2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCacheable2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedNativeQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit.LocalMessage;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateTable;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;

/**
 * @author Dmitry Geraskov
 *
 */
public class HibernateOrmEntityImpl extends AbstractOrmEntity
implements HibernateOrmEntity {
	
	protected OrmCacheable2_0 cachable;

	public HibernateOrmEntityImpl(OrmPersistentType parent,
			XmlEntity resourceMapping) {
		super(parent, resourceMapping);
		this.cachable = buildOrmCachable();
	}
	
	protected OrmCacheable2_0 buildOrmCachable() {
		return new NullOrmCacheable2_0(this);
	}
	
	public OrmCacheable2_0 getCacheable() {
		return cachable;
	}

	public boolean calculateDefaultCacheable() {
		if (!isMetadataComplete()) {
			CacheableHolder2_0 javaEntity = (CacheableHolder2_0) getJavaEntity();
			if (javaEntity != null) {
				return javaEntity.getCacheable().isCacheable();
			}
		}
		
		CacheableHolder2_0 parentEntity = (CacheableHolder2_0) getParentEntity();
		if (parentEntity != null) {
			return parentEntity.getCacheable().isCacheable();
		}
		return ((PersistenceUnit2_0) getPersistenceUnit()).calculateDefaultCacheable();
	}

	@Override
	public HibernateJpaProject getJpaProject() {
		return (HibernateJpaProject) super.getJpaProject();
	}
	
	@Override
	public String getPrimaryTableName() {
		return this.getTable().getDBTableName();
	}
	
	/**
	 * Convert Table to it's DB name.
	 */
	@Override
	protected Iterator<String> tableNames(Iterator<Table> tables) {
		return new TransformationIterator<Table, String>(tables) {
			@Override
			protected String transform(Table t) {
				if (t instanceof HibernateTable) {
					return ((HibernateTable)t).getDBTableName();					
				} else {
					return t.getName();//What is this???
				}				
			}
		};
	}
	
	@Override
	protected OrmBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
		return new HibernatePrimaryKeyJoinColumnOwner();
	}
	
	// ********** pk join column owner **********

	class HibernatePrimaryKeyJoinColumnOwner implements OrmBaseJoinColumn.Owner
	{
		public TypeMapping getTypeMapping() {
			return HibernateOrmEntityImpl.this;
		}

		public org.eclipse.jpt.db.Table getDbTable(String tableName) {
			return HibernateOrmEntityImpl.this.getDbTable(tableName);
		}

		public org.eclipse.jpt.db.Table getReferencedColumnDbTable() {
			Entity parentEntity = HibernateOrmEntityImpl.this.getParentEntity();
			return (parentEntity == null) ? null : parentEntity.getPrimaryDbTable();
		}

		public int joinColumnsSize() {
			return HibernateOrmEntityImpl.this.primaryKeyJoinColumnsSize();
		}
		
		public boolean isVirtual(BaseJoinColumn joinColumn) {
			return HibernateOrmEntityImpl.this.defaultPrimaryKeyJoinColumns.contains(joinColumn);
		}
		
		public String getDefaultColumnName() {
			if (joinColumnsSize() != 1) {
				return null;
			}
			Entity parentEntity = HibernateOrmEntityImpl.this.getParentEntity();
			String colName = (parentEntity == null)
				? getPrimaryKeyColumnName() : parentEntity.getPrimaryKeyColumnName();
			NamingStrategy ns = HibernateOrmEntityImpl.this.getJpaProject().getNamingStrategy();
			if (getJpaProject().isNamingStrategyEnabled() && ns != null){				
				try {
					String name = ns.joinKeyColumnName(colName,	(parentEntity == null)
								? getTable().getName() : parentEntity.getPrimaryTableName());
					return name;
				} catch (Exception e) {
					Message m = new LocalMessage(IMessage.HIGH_SEVERITY, 
							Messages.NAMING_STRATEGY_EXCEPTION, new String[0], null);
					HibernateJptPlugin.logException(m.getText(), e);
				}
			}
			return colName;
		}
		
		public String getDefaultTableName() {
			//FIXME: use NamingStrategy here
			return HibernateOrmEntityImpl.this.getPrimaryTableName();
		}
		
		public TextRange getValidationTextRange() {
			return null;
		}
		
		public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
			throw new UnsupportedOperationException("validation not supported yet: bug 148262"); //$NON-NLS-1$
		}

		public IMessage buildUnresolvedReferencedColumnNameMessage(BaseJoinColumn column, TextRange textRange) {
			throw new UnsupportedOperationException("validation not supported yet: bug 148262"); //$NON-NLS-1$
		}

		public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
			throw new UnsupportedOperationException("validation not supported yet: bug 148262"); //$NON-NLS-1$
		}
		
		public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
			throw new UnsupportedOperationException("validation not supported yet: bug 148262"); //$NON-NLS-1$
		}
	}
	
	@Override
	public HibernateOrmTable getTable() {
		return (HibernateOrmTable) super.getTable();
	}
	
	//******** TODO **********

	public void removeDiscriminatorFormula() {
		// TODO Auto-generated method stub		
	}

	public GenericGenerator addGenericGenerator(int index) {
		// TODO Auto-generated method stub
		return null;
	}

	public ListIterator<GenericGenerator> genericGenerators() {
		return EmptyListIterator.<GenericGenerator>instance();
	}

	public int genericGeneratorsSize() {
		return 0;
	}

	public void moveGenericGenerator(int targetIndex, int sourceIndex) {
		// TODO Auto-generated method stub		
	}

	public void removeGenericGenerator(int index) {
		// TODO Auto-generated method stub		
	}

	public void removeGenericGenerator(GenericGenerator generator) {
		// TODO Auto-generated method stub		
	}

	public HibernateNamedNativeQuery addHibernateNamedNativeQuery(int index) {
		// TODO Auto-generated method stub
		return null;
	}

	public HibernateNamedQuery addHibernateNamedQuery(int index) {
		// TODO Auto-generated method stub
		return null;
	}

	public ListIterator<HibernateNamedNativeQuery> hibernateNamedNativeQueries() {
		return EmptyListIterator.<HibernateNamedNativeQuery>instance();
	}

	public int hibernateNamedNativeQueriesSize() {
		return 0;
	}

	public ListIterator<HibernateNamedQuery> hibernateNamedQueries() {
		return EmptyListIterator.<HibernateNamedQuery>instance();
	}

	public int hibernateNamedQueriesSize() {
		// TODO Auto-generated method stub
		return 0;
	}


	public void moveHibernateNamedNativeQuery(int targetIndex, int sourceIndex) {
		// TODO Auto-generated method stub		
	}

	public void moveHibernateNamedQuery(int targetIndex, int sourceIndex) {
		// TODO Auto-generated method stub			
	}

	public void removeHibernateNamedNativeQuery(int index) {
		// TODO Auto-generated method stub		
	}

	public void removeHibernateNamedNativeQuery(
			HibernateNamedNativeQuery namedNativeQuery) {
		// TODO Auto-generated method stub		
	}

	public void removeHibernateNamedQuery(int index) {
		// TODO Auto-generated method stub		
	}

	public void removeHibernateNamedQuery(HibernateNamedQuery namedQuery) {
		// TODO Auto-generated method stub		
	}
}
