/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.undo;

import java.text.MessageFormat;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.OrderedObjectImpl;
import org.jboss.tools.common.model.undo.XUndoableImpl;

public class XMoveUndo
extends XUndoableImpl {
    protected XModel model = null;
    protected String path = null;
    protected int from;
    protected int to;
    protected String op;

    public XMoveUndo(XModelObject object, int from, int to) {
        this.model = object.getModel();
        this.path = object.getPath();
        this.from = from;
        this.to = to;
        this.op = String.valueOf(object.getAttributeValue("element type")) + " " + object.getModelEntity().getRenderer().getTitle(object);
        this.resetDescription();
    }

    private void resetDescription() {
        this.description = MessageFormat.format("{0}-th child of {1} moved to {2}-th position", this.from + 1, this.op, this.to + 1);
    }

    public void doUndo() {
        this.execute(this.to, this.from);
    }

    public void doRedo() {
        this.execute(this.from, this.to);
    }

    protected void execute(int f, int t) {
        XModelObject object = this.model.getByPath(this.path);
        if (object == null || !(object instanceof OrderedObjectImpl)) {
            return;
        }
        OrderedObjectImpl oo = (OrderedObjectImpl)object;
        oo.move(f, t, true);
        oo.setModified(true);
    }

    protected String getActionIcon() {
        return "images/actions/undo.gif";
    }

    protected boolean merge(XUndoableImpl u) {
        if (!(u instanceof XMoveUndo)) {
            return false;
        }
        XMoveUndo c = (XMoveUndo)u;
        if (this.path.equals(c.path) && this.to == c.from) {
            this.to = c.to;
            this.resetDescription();
            return true;
        }
        return false;
    }
}

