/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.resources;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.ui.ModelUIMessages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.xml.XMLUtilities;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceLayoutManager {
    public static final String ROOT_TAG = "Layout";
    public static final String RESOURCE_ATTR = "resource";
    public static final String LAYOUT_EXT = "l4t";
    public static final String LAYOUT_PROPERTY = "layout";
    private static ResourceLayoutManager instance;
    private HashMap<String, Document> hashMap = new HashMap();

    private ResourceLayoutManager() {
    }

    public static ResourceLayoutManager getDefault() {
        if (instance == null) {
            instance = new ResourceLayoutManager();
        }
        return instance;
    }

    public Element getLayoutElement(IResource resource, String elementTag) {
        Element element = null;
        Document document = this.getLayoutDocument(resource);
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getElementsByTagName(elementTag);
        if (nodeList == null || nodeList.getLength() == 0 || nodeList.item(0) == null) {
            element = document.createElement(elementTag);
            Node root = document.getFirstChild();
            root.appendChild(element);
        } else {
            element = (Element)nodeList.item(0);
        }
        return element;
    }

    private Document getLayoutDocument(IResource resource) {
        Document document = null;
        if (resource == null) {
            ModelUIPlugin.getPluginLog().logError(ModelUIMessages.ResourceLayoutManager_ERROR_RESOURCE_NULL);
            return null;
        }
        String fullResourceLocation = this.getFullLocation(resource).toString();
        String layoutLocation = null;
        try {
            if (resource.isAccessible()) {
                layoutLocation = resource.getPersistentProperty(new QualifiedName("", LAYOUT_PROPERTY));
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        if (layoutLocation == null) {
            layoutLocation = this.createNewLayoutLocation(resource);
        }
        if ((document = this.hashMap.get(fullResourceLocation)) != null) {
            return document;
        }
        try {
            document = this.loadDocument(resource);
        }
        catch (ParserConfigurationException e) {
            ModelUIPlugin.getPluginLog().logError(ModelUIMessages.ResourceLayoutManager_ERROR_UNKNOWN_EXCEPTION, (Throwable)e);
        }
        catch (SAXException e) {
            ModelUIPlugin.getPluginLog().logError(ModelUIMessages.ResourceLayoutManager_ERROR_UNKNOWN_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError(ModelUIMessages.ResourceLayoutManager_ERROR_UNKNOWN_EXCEPTION, (Throwable)e);
        }
        catch (AnotherResourceException e) {
            ModelUIPlugin.getPluginLog().logError(ModelUIMessages.ResourceLayoutManager_ERROR_ANOTHER_HEAD, (Throwable)e);
        }
        if (document != null) {
            this.hashMap.put(fullResourceLocation, document);
            return document;
        }
        try {
            document = this.createNewDocument(resource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ModelUIPlugin.getPluginLog().logError(NLS.bind((String)ModelUIMessages.ResourceLayoutManager_ERROR_CREATE_DOCUMENT, (Object)layoutLocation, (Object)fullResourceLocation));
        }
        if (document != null) {
            this.hashMap.put(fullResourceLocation, document);
            return document;
        }
        return document;
    }

    private Document createNewDocument(IResource resource) throws ParserConfigurationException {
        Document document = null;
        DocumentBuilder builder = null;
        builder = DocumentBuilderHolder.getInstance();
        document = builder.newDocument();
        this.createRoot(resource, document);
        return document;
    }

    private Document loadDocument(IResource resource) throws AnotherResourceException, ParserConfigurationException, SAXException, IOException {
        NodeList nodeList;
        this.getFullLocation(resource).toString();
        String layoutLocation = null;
        try {
            if (resource != null && resource.isAccessible()) {
                layoutLocation = resource.getPersistentProperty(new QualifiedName("", LAYOUT_PROPERTY));
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        if (layoutLocation == null) {
            layoutLocation = this.createNewLayoutLocation(resource);
        }
        if (!new File(layoutLocation).isFile()) {
            return null;
        }
        Document document = null;
        DocumentBuilder builder = null;
        builder = DocumentBuilderHolder.getInstance();
        document = builder.parse(layoutLocation);
        if (document != null && ((nodeList = document.getElementsByTagName(ROOT_TAG)) == null || nodeList.getLength() == 0 || nodeList.item(0) == null)) {
            ModelUIPlugin.getPluginLog().logInfo(NLS.bind((String)ModelUIMessages.ResourceLayoutManager_WARNING_HEAD_EMPTY, (Object)layoutLocation));
            this.createRoot(resource, document);
        }
        return document;
    }

    private IPath getFullLocation(IResource resource) {
        IProject project = resource.getProject();
        IPath layoutPath = resource.getProjectRelativePath();
        IFile layoutFile = project.getFile(layoutPath);
        return layoutFile.getLocation();
    }

    public void store(IResource resource) {
        String fullResourceLocation;
        Document document;
        String layoutLocation = null;
        try {
            if (resource != null && resource.isAccessible()) {
                layoutLocation = resource.getPersistentProperty(new QualifiedName("", LAYOUT_PROPERTY));
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        if (layoutLocation == null) {
            layoutLocation = this.createNewLayoutLocation(resource);
        }
        if (layoutLocation == null) {
            return;
        }
        File file = new File(layoutLocation);
        if (!file.exists()) {
            layoutLocation = this.createNewLayoutLocation(resource);
        }
        if ((document = this.hashMap.get(fullResourceLocation = this.getFullLocation(resource).toString())) == null) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(layoutLocation);
            XMLSerializer serial = new XMLSerializer((Writer)writer, this.createOutputFormat("UTF-8"));
            serial.asDOMSerializer();
            serial.serialize(document);
            writer.close();
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError(NLS.bind((String)ModelUIMessages.ResourceLayoutManager_ERROR_CREATE_DOCUMENT, (Object)layoutLocation, (Object)fullResourceLocation), (Throwable)e);
        }
    }

    private OutputFormat createOutputFormat(String encoding) {
        if (encoding == null || encoding.length() == 0) {
            encoding = "UTF-8";
        }
        OutputFormat format = new OutputFormat("xml", encoding, true);
        format.setLineSeparator(System.getProperty("line.separator", "\n"));
        format.setIndent(1);
        return format;
    }

    private Element createRoot(IResource resource, Document document) {
        Element element = document.createElement(ROOT_TAG);
        Node oldRoot = document.getFirstChild();
        element.setAttribute(RESOURCE_ATTR, resource.getFullPath().toString());
        if (oldRoot != null) {
            document.removeChild(oldRoot);
        }
        document.appendChild(element);
        return element;
    }

    private IPath getPluginMetadataPath() {
        return Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.jboss.tools.common.model.ui"));
    }

    private String createNewLayoutLocation(IResource resource) {
        String fileName = String.valueOf(resource.getProject().getName()) + "_" + resource.getName() + "_" + System.currentTimeMillis();
        String layoutLocation = this.getPluginMetadataPath().toString();
        String result = String.valueOf(layoutLocation) + "/" + fileName + "." + LAYOUT_EXT;
        try {
            if (resource != null && resource.isAccessible()) {
                resource.setPersistentProperty(new QualifiedName("", LAYOUT_PROPERTY), result);
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return result;
    }

    class AnotherResourceException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AnotherResourceException() {
        }
    }

    static class DocumentBuilderHolder {
        private static DocumentBuilder INSTANCE = XMLUtilities.createDocumentBuilder();

        DocumentBuilderHolder() {
        }

        public static DocumentBuilder getInstance() {
            return INSTANCE;
        }
    }
}

