/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.util.EditDistance;
import edu.umd.cs.findbugs.util.Util;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumberTable;

public class FindSelfComparison
extends OpcodeStackDetector {
    final BugAccumulator bugAccumulator;
    int putFieldPC = Integer.MIN_VALUE;
    OpcodeStack.Item putFieldObj;
    OpcodeStack.Item putFieldValue;
    XField putFieldXField;
    int whichRegister;
    int registerLoadCount;

    public FindSelfComparison(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code obj) {
        this.whichRegister = -1;
        this.registerLoadCount = 0;
        this.resetDoubleAssignmentState();
        super.visit(obj);
        this.resetDoubleAssignmentState();
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private void resetDoubleAssignmentState() {
        this.putFieldPC = Integer.MIN_VALUE;
        this.putFieldXField = null;
        this.putFieldValue = null;
        this.putFieldObj = null;
    }

    public void sawBranchTo(int target) {
        this.resetDoubleAssignmentState();
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item obj;
        if (this.stack.hasIncomingBranches(this.getPC())) {
            this.resetDoubleAssignmentState();
        }
        if (seen == 181) {
            int second;
            int first;
            LineNumberTable table;
            obj = this.stack.getStackItem(1);
            OpcodeStack.Item value = this.stack.getStackItem(0);
            XField f = this.getXFieldOperand();
            XClass x = this.getXClassOperand();
            if (this.putFieldPC + 10 > this.getPC() && f != null && obj != null && f.equals(this.putFieldXField) && !f.isSynthetic() && obj.equals(this.putFieldObj) && x != null && !((table = this.getCode().getLineNumberTable()) != null ? (first = table.getSourceLine(this.putFieldPC)) + 1 != (second = table.getSourceLine(this.getPC())) && first != second : this.putFieldPC + 3 != this.getPC())) {
                boolean storeOfDefaultValue;
                int priority = 2;
                if (value.equals(this.putFieldValue) && this.putFieldPC + 3 != this.getPC()) {
                    ++priority;
                }
                boolean bl = storeOfDefaultValue = this.putFieldValue.isNull() || this.putFieldValue.hasConstantValue(0);
                if (storeOfDefaultValue) {
                    ++priority;
                }
                if (f.isVolatile()) {
                    ++priority;
                }
                XField intendedTarget = null;
                double minimumDistance = 2.0;
                int matches = 0;
                for (XField xField : x.getXFields()) {
                    if (f.equals(xField) || xField.isStatic() || xField.isFinal() || xField.isSynthetic() || !xField.getSignature().equals(f.getSignature())) continue;
                    double distance = EditDistance.editDistanceRatio(f.getName(), xField.getName());
                    ++matches;
                    if (!(minimumDistance > distance)) continue;
                    minimumDistance = distance;
                    intendedTarget = xField;
                }
                if (minimumDistance > 0.6 && (matches > 1 || storeOfDefaultValue)) {
                    intendedTarget = null;
                } else if (intendedTarget != null) {
                    --priority;
                }
                BugInstance bug = new BugInstance(this, "SA_FIELD_DOUBLE_ASSIGNMENT", priority).addClassAndMethod(this).addReferencedField(this);
                if (intendedTarget != null) {
                    bug.addField(intendedTarget).describe("FIELD_DID_YOU_MEAN");
                }
                this.bugAccumulator.accumulateBug(bug, this);
            }
            this.putFieldPC = this.getPC();
            this.putFieldXField = f;
            this.putFieldObj = obj;
            this.putFieldValue = value;
        } else if (this.isReturn(seen)) {
            this.resetDoubleAssignmentState();
        } else if (seen == 180 && Util.nullSafeEquals(this.getXFieldOperand(), this.putFieldXField) && (obj = this.stack.getStackItem(0)).equals(this.putFieldObj)) {
            this.resetDoubleAssignmentState();
        }
        switch (seen) {
            case 182: 
            case 185: {
                String sig;
                SignatureParser parser;
                String name;
                if (this.getClassName().toLowerCase().indexOf("test") >= 0 || this.getMethodName().toLowerCase().indexOf("test") >= 0 || this.getSuperclassName().toLowerCase().indexOf("test") >= 0 || this.getNextOpcode() == 87 || !(name = this.getNameConstantOperand()).equals("equals") && !name.equals("compareTo") || (parser = new SignatureParser(sig = this.getSigConstantOperand())).getNumParameters() != 1 || (!name.equals("equals") || !sig.endsWith(";)Z")) && (!name.equals("compareTo") || !sig.endsWith(";)I"))) break;
                this.checkForSelfOperation(seen, "COMPARISON");
                break;
            }
            case 100: 
            case 101: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                this.checkForSelfOperation(seen, "COMPUTATION");
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                break;
            }
            case 148: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.checkForSelfOperation(seen, "COMPARISON");
            }
        }
        if (this.isRegisterLoad() && seen != 132) {
            if (this.getRegisterOperand() == this.whichRegister) {
                ++this.registerLoadCount;
            } else {
                this.whichRegister = this.getRegisterOperand();
                this.registerLoadCount = 1;
            }
        } else {
            this.whichRegister = -1;
            this.registerLoadCount = 0;
        }
    }

    private void checkForSelfOperation(int opCode, String op) {
        OpcodeStack.Item item0 = this.stack.getStackItem(0);
        OpcodeStack.Item item1 = this.stack.getStackItem(1);
        if (item0.getSignature().equals("D") || item0.getSignature().equals("F")) {
            return;
        }
        if (item1.getSignature().equals("D") || item1.getSignature().equals("F")) {
            return;
        }
        XField field0 = item0.getXField();
        XField field1 = item1.getXField();
        int fr0 = item0.getFieldLoadedFromRegister();
        int fr1 = item1.getFieldLoadedFromRegister();
        if (field0 != null && field0.equals(field1) && fr0 != -1 && fr0 == fr1) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "SA_FIELD_SELF_" + op, 2).addClassAndMethod(this).addField(field0), this);
        } else if (opCode == 130 && item0.equals(item1)) {
            LocalVariableAnnotation localVariableAnnotation = LocalVariableAnnotation.getLocalVariableAnnotation(this, item0);
            if (localVariableAnnotation != null) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "SA_LOCAL_SELF_" + op, 1).addClassAndMethod(this).add(localVariableAnnotation), this);
            }
        } else if (opCode == 100 && this.registerLoadCount >= 2) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "SA_LOCAL_SELF_" + op, opCode == 100 || opCode == 101 || opCode == 185 || opCode == 182 ? 2 : 1).addClassAndMethod(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), this.whichRegister, this.getPC(), this.getPC() - 1)), this);
        }
    }
}

