/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class ClassAnnotation
extends PackageMemberAnnotation {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ROLE = "CLASS_DEFAULT";
    public static final String SUBCLASS_ROLE = "CLASS_SUBCLASS";
    public static final String SUPERCLASS_ROLE = "CLASS_SUPERCLASS";
    public static final String IMPLEMENTED_INTERFACE_ROLE = "CLASS_IMPLEMENTED_INTERFACE";
    public static final String INTERFACE_ROLE = "INTERFACE_TYPE";
    public static final String ANNOTATION_ROLE = "CLASS_ANNOTATION";
    private static final String ELEMENT_NAME = "Class";

    public ClassAnnotation(String className) {
        super(className, DEFAULT_ROLE);
    }

    public boolean isSignificant() {
        return !SUBCLASS_ROLE.equals(this.description);
    }

    public static ClassAnnotation fromClassDescriptor(ClassDescriptor classDescriptor) {
        return new ClassAnnotation(classDescriptor.toDottedClassName());
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitClassAnnotation(this);
    }

    protected String formatPackageMember(String key, ClassAnnotation primaryClass) {
        if (key.equals("") || key.equals("hash")) {
            return this.className;
        }
        if (key.equals("givenClass")) {
            return ClassAnnotation.shorten(primaryClass.getPackageName(), this.className);
        }
        if (key.equals("excludingPackage")) {
            return ClassAnnotation.shorten(this.getPackageName(), this.className);
        }
        throw new IllegalArgumentException("unknown key " + key);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassAnnotation)) {
            return false;
        }
        ClassAnnotation other = (ClassAnnotation)o;
        return this.className.equals(other.className);
    }

    public boolean contains(ClassAnnotation other) {
        return other.className.startsWith(this.className);
    }

    public ClassAnnotation getTopLevelClass() {
        int firstDollar = this.className.indexOf(36);
        if (firstDollar <= 0) {
            return this;
        }
        return new ClassAnnotation(this.className.substring(0, firstDollar));
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof ClassAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        ClassAnnotation other = (ClassAnnotation)o;
        return this.className.compareTo(other.className);
    }

    public SourceLineAnnotation getSourceLines() {
        if (this.sourceLines == null) {
            this.sourceLines = ClassAnnotation.getSourceLinesForClass(this.className, this.sourceFileName);
        }
        return this.sourceLines;
    }

    public static SourceLineAnnotation getSourceLinesForClass(@DottedClassName String className, String sourceFileName) {
        AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext == null) {
            return new SourceLineAnnotation(className, sourceFileName, -1, -1, -1, -1);
        }
        SourceInfoMap.SourceLineRange classLine = currentAnalysisContext.getSourceInfoMap().getClassLine(className);
        if (classLine == null) {
            return SourceLineAnnotation.getSourceAnnotationForClass(className, sourceFileName);
        }
        return new SourceLineAnnotation(className, sourceFileName, classLine.getStart(), classLine.getEnd(), -1, -1);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        String role;
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("classname", this.getClassName());
        if (isPrimary) {
            attributeList.addAttribute("primary", "true");
        }
        if (!(role = this.getDescription()).equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        xmlOutput.openTag(ELEMENT_NAME, attributeList);
        this.getSourceLines().writeXML(xmlOutput, addMessages, false);
        if (addMessages) {
            xmlOutput.openTag("Message");
            xmlOutput.writeText(this.toString());
            xmlOutput.closeTag("Message");
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }
}

