/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.client.IHttpClient;
import com.openshift.internal.client.httpclient.FormUrlEncodedMediaType;
import com.openshift.internal.client.httpclient.IMediaType;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClient;

public class UrlConnectionHttpClientBuilder {
    private String userAgent;
    private boolean sslChecks = false;
    private String username;
    private String password;
    private IMediaType requestMediaType = new FormUrlEncodedMediaType();
    private String acceptedMediaType = "application/json";
    private String version = "1.0";

    public UrlConnectionHttpClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public UrlConnectionHttpClientBuilder setSSLChecks(boolean check) {
        this.sslChecks = check;
        return this;
    }

    public UrlConnectionHttpClientBuilder setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public UrlConnectionHttpClientBuilder setRequestMediaType(IMediaType type) {
        this.requestMediaType = type;
        return this;
    }

    public UrlConnectionHttpClientBuilder setRequestMediaType(String acceptedMediaType) {
        this.acceptedMediaType = acceptedMediaType;
        return this;
    }

    public UrlConnectionHttpClientBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public IHttpClient client() {
        return new UrlConnectionHttpClient(this.username, this.password, this.userAgent, this.sslChecks, this.requestMediaType, this.acceptedMediaType, this.version);
    }
}

