/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import javax.inject.Inject;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="mkdir")
@Topic(value="File & Resources")
@RequiresResource(value={DirectoryResource.class})
@Help(value="Create a new directory")
public class MkdirPlugin
implements Plugin {
    private final Shell shell;

    @Inject
    public MkdirPlugin(Shell shell) {
        this.shell = shell;
    }

    @DefaultCommand
    public void mkdir(@Option(help="name of directory to be created", required=true) String name) {
        DirectoryResource dr = (DirectoryResource)this.shell.getCurrentResource();
        FileResource newResource = (FileResource)dr.getChild(name);
        if (!newResource.mkdir()) {
            throw new RuntimeException("failed to create directory: " + name);
        }
    }
}

