/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.channels.Channels;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.WriteTimeoutException;

public class BlockingByteChannel
implements ScatteringByteChannel,
GatheringByteChannel,
ByteChannel,
Flushable {
    private final StreamChannel delegate;
    private volatile long readTimeout;
    private volatile long writeTimeout;

    public BlockingByteChannel(StreamChannel delegate) {
        this.delegate = delegate;
    }

    public BlockingByteChannel(StreamChannel delegate, long timeout, TimeUnit timeoutUnit) {
        this(delegate, timeout, timeoutUnit, timeout, timeoutUnit);
    }

    public BlockingByteChannel(StreamChannel delegate, long readTimeout, TimeUnit readTimeoutUnit, long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (readTimeout < 0L) {
            throw new IllegalArgumentException("Negative read timeout");
        }
        if (writeTimeout < 0L) {
            throw new IllegalArgumentException("Negative write timeout");
        }
        long calcReadTimeout = readTimeoutUnit.toMillis(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcReadTimeout < 1L ? 1L : calcReadTimeout);
        long calcWriteTimeout = writeTimeoutUnit.toMillis(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcWriteTimeout < 1L ? 1L : calcWriteTimeout);
        this.delegate = delegate;
    }

    public void setReadTimeout(long readTimeout, TimeUnit readTimeoutUnit) {
        if (readTimeout < 0L) {
            throw new IllegalArgumentException("Negative read timeout");
        }
        long calcTimeout = readTimeoutUnit.toMillis(readTimeout);
        this.readTimeout = readTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public void setWriteTimeout(long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (writeTimeout < 0L) {
            throw new IllegalArgumentException("Negative write timeout");
        }
        long calcTimeout = writeTimeoutUnit.toMillis(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        StreamChannel delegate = this.delegate;
        long readTimeout = this.readTimeout;
        if (readTimeout == 0L) {
            while ((res = delegate.read(dsts, offset, length)) == 0L) {
                delegate.awaitReadable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + readTimeout;
            while ((res = delegate.read(dsts, offset, length)) == 0L) {
                if (now >= deadline) {
                    throw new ReadTimeoutException("Read timed out");
                }
                delegate.awaitReadable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        StreamChannel delegate = this.delegate;
        long readTimeout = this.readTimeout;
        if (readTimeout == 0L) {
            while ((long)(res = delegate.read(dst)) == 0L) {
                delegate.awaitReadable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + readTimeout;
            while ((long)(res = delegate.read(dst)) == 0L) {
                if (now >= deadline) {
                    throw new ReadTimeoutException("Read timed out");
                }
                delegate.awaitReadable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res;
        StreamChannel delegate = this.delegate;
        long writeTimeout = this.writeTimeout;
        if (writeTimeout == 0L) {
            while ((res = delegate.write(srcs, offset, length)) == 0L && Buffers.hasRemaining(srcs, offset, length)) {
                delegate.awaitWritable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + writeTimeout;
            while ((res = delegate.write(srcs, offset, length)) == 0L && Buffers.hasRemaining(srcs, offset, length)) {
                if (now >= deadline) {
                    throw new WriteTimeoutException("Write timed out");
                }
                delegate.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res;
        StreamChannel delegate = this.delegate;
        long writeTimeout = this.writeTimeout;
        if (writeTimeout == 0L) {
            while ((res = delegate.write(src)) == 0 && src.hasRemaining()) {
                delegate.awaitWritable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + writeTimeout;
            while ((res = delegate.write(src)) == 0 && src.hasRemaining()) {
                if (now >= deadline) {
                    throw new WriteTimeoutException("Write timed out");
                }
                delegate.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void flush() throws IOException {
        StreamChannel delegate = this.delegate;
        long writeTimeout = this.writeTimeout;
        if (writeTimeout == 0L) {
            Channels.flushBlocking(delegate);
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + writeTimeout;
            while (!delegate.flush()) {
                if (now >= deadline) {
                    throw new WriteTimeoutException("Flush timed out");
                }
                delegate.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

