/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageSupport;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.TilesHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class JumpByForwardPathHandler
extends AbstractHandler
implements StrutsConstants {
    public boolean isEnabled(XModelObject object) {
        String attr = this.getJumpAttributeName();
        return object != null && object.isActive() && object.getAttributeValue(attr) != null && object.getAttributeValue(attr).length() > 0;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        String attr = this.getJumpAttributeName();
        XModelObject target = JumpByForwardPathHandler.findForwardTarget(object, attr);
        String path = object.getAttributeValue(attr);
        if (target == null) {
            ServiceDialog d = object.getModel().getService();
            d.showDialog(StrutsUIMessages.WARNING, NLS.bind((String)StrutsUIMessages.CANNOT_FIND_OBJECT_BY_PATH, (Object)path), new String[]{StrutsUIMessages.OK}, null, 2);
        } else {
            JumpByForwardPathHandler.doOpenTarget(target);
        }
    }

    private String getJumpAttributeName() {
        String attr = this.action.getProperty("linkAttr");
        return attr == null ? "path" : attr;
    }

    public static void doOpenTarget(XModelObject target) {
        FindObjectHelper.findModelObject((XModelObject)target, (int)FindObjectHelper.IN_EDITOR_ONLY);
        String entity = target.getModelEntity().getName();
        if (entity.startsWith("StrutsAction") || entity.startsWith("StrutsForward") && target.getParent() != null && target.getParent().getModelEntity().getName().startsWith("StrutsGlobalForwards")) {
            XActionInvoker.invoke((String)"Select", (XModelObject)target, null);
        }
    }

    public static String getResourcePath(String path) {
        int i = path.indexOf(35);
        if (i >= 0) {
            path = path.substring(0, i);
        }
        if ((i = path.indexOf(63)) >= 0) {
            path = path.substring(0, i);
        }
        return path;
    }

    private static XModelObject findForwardTarget(XModelObject object, String attr) {
        String pathValue = object.getAttributeValue(attr);
        return JumpByForwardPathHandler.findWithContext(pathValue, object);
    }

    public static XModelObject findWithContext(String pathValue, XModelObject object) {
        boolean cR;
        String path = JumpByForwardPathHandler.getResourcePath(pathValue);
        String cRs = object.getAttributeValue("contextRelative");
        boolean bl = cR = cRs == null || cRs.equals("true") || cRs.equals("yes");
        if (TilesHelper.getTiles(object).containsKey(path)) {
            return TilesHelper.findTile(object, path);
        }
        WebModulesHelper wh = WebModulesHelper.getInstance(object.getModel());
        UrlPattern up = StrutsProcessStructureHelper.instance.getUrlPattern(object);
        if (up.isActionUrl(path)) {
            path = up.getActionPath(path);
            if (!cR) {
                return StrutsProcessStructureHelper.instance.getParentFile(object).getChildByPath("action-mappings/" + path.replace('/', '#'));
            }
            String s = StrutsProcessStructureHelper.instance.getProcessModule(object);
            String mod = wh.getModuleForPath(path, s);
            XModelObject[] cgs = wh.getConfigsForModule(object.getModel(), mod);
            if (cgs.length == 0) {
                return null;
            }
            if (mod.length() > 0 && path.startsWith(mod)) {
                path = path.substring(mod.length());
            }
            XModelObject t0 = null;
            int i = 0;
            while (i < cgs.length) {
                XModelObject t = cgs[i].getChildByPath("action-mappings/" + path.replace('/', '#'));
                if (t != null) {
                    if ("unknown".equals(t.getAttributeValue("subtype"))) {
                        t0 = t;
                    } else {
                        return t;
                    }
                }
                ++i;
            }
            return t0;
        }
        if (path.endsWith(".jsp") || path.indexOf(".htm") > 0 || path.endsWith(CreatePageSupport.getExtension())) {
            XModelObject fo;
            if (!cR) {
                XModelObject fo2 = XModelImpl.getByRelativePath((XModel)object.getModel(), (String)path);
                if (fo2 != null) {
                    return fo2;
                }
                return object.getModel().getByPath(path);
            }
            String s = StrutsProcessStructureHelper.instance.getProcessModule(object);
            String mod = wh.getModuleForPath(path, s);
            XModelObject fs = wh.getRootFileSystemForModule(object.getModel(), mod);
            if (fs == null) {
                return null;
            }
            if (mod.length() > 0 && path.startsWith(mod)) {
                path = path.substring(mod.length());
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!EclipseResourceUtil.isOverlapped((XModelObject)(fo = fs.getChildByPath(path)))) {
                return fo;
            }
            IResource r = EclipseResourceUtil.getResource((XModelObject)fo);
            if (r == null) {
                return fo;
            }
            XModelObject fo2 = EclipseResourceUtil.getObjectByResource((IResource)r);
            return fo2 != null ? fo2 : fo;
        }
        return null;
    }
}

