/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;

public abstract class GitUtils {
    public static Git clone(DirectoryResource dir, String repoUri) throws IOException {
        CloneCommand clone = Git.cloneRepository().setURI(repoUri).setDirectory(dir.getUnderlyingResourceObject());
        Git git = clone.call();
        return git;
    }

    public static Git git(DirectoryResource dir) throws IOException {
        RepositoryBuilder db = (RepositoryBuilder)new RepositoryBuilder().findGitDir(dir.getUnderlyingResourceObject());
        return new Git(db.build());
    }

    public static Ref checkout(Git git, String remote, boolean createBranch, CreateBranchCommand.SetupUpstreamMode mode, boolean force) throws JGitInternalException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        CheckoutCommand checkout = git.checkout();
        checkout.setCreateBranch(createBranch);
        checkout.setName(remote);
        checkout.setForce(force);
        checkout.setUpstreamMode(mode);
        return checkout.call();
    }

    public static Ref checkout(Git git, Ref localRef, boolean createBranch, CreateBranchCommand.SetupUpstreamMode mode, boolean force) throws JGitInternalException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        CheckoutCommand checkout = git.checkout();
        checkout.setName(Repository.shortenRefName((String)localRef.getName()));
        checkout.setForce(force);
        checkout.setUpstreamMode(mode);
        return checkout.call();
    }

    public static FetchResult fetch(Git git, String remote, String refSpec, int timeout, boolean fsck, boolean dryRun, boolean thin, boolean prune) throws JGitInternalException, InvalidRemoteException {
        FetchCommand fetch = git.fetch();
        fetch.setCheckFetchedObjects(fsck);
        fetch.setRemoveDeletedRefs(prune);
        if (refSpec != null) {
            fetch.setRefSpecs(new RefSpec[]{new RefSpec(refSpec)});
        }
        if (timeout >= 0) {
            fetch.setTimeout(timeout);
        }
        fetch.setDryRun(dryRun);
        fetch.setRemote(remote);
        fetch.setThin(thin);
        fetch.setProgressMonitor((ProgressMonitor)new TextProgressMonitor());
        FetchResult result = fetch.call();
        return result;
    }

    public static Git init(DirectoryResource dir) throws IllegalArgumentException, IOException {
        FileResource gitDir = (FileResource)dir.getChildDirectory(".git").reify(FileResource.class);
        gitDir.mkdirs();
        RepositoryBuilder db = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(gitDir.getUnderlyingResourceObject())).setup();
        Git git = new Git(db.build());
        git.getRepository().create();
        return git;
    }

    public static PullResult pull(Git git, int timeout) throws WrongRepositoryStateException, InvalidConfigurationException, DetachedHeadException, InvalidRemoteException, CanceledException, RefNotFoundException, NoHeadException {
        PullCommand pull = git.pull();
        if (timeout >= 0) {
            pull.setTimeout(timeout);
        }
        pull.setProgressMonitor((ProgressMonitor)new TextProgressMonitor());
        PullResult result = pull.call();
        return result;
    }

    public static List<Ref> getRemoteBranches(Git repo) throws JGitInternalException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        ArrayList<Ref> results = new ArrayList<Ref>();
        try {
            FetchResult fetch = repo.fetch().setRemote("origin").call();
            Collection refs = fetch.getAdvertisedRefs();
            for (Ref ref : refs) {
                if (!ref.getName().startsWith("refs/heads")) continue;
                results.add(ref);
            }
        }
        catch (InvalidRemoteException e) {
            e.printStackTrace();
        }
        return results;
    }
}

