/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.git.GitUtils;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyRepositoryImpl;
import org.jboss.forge.project.dependencies.DependencyResolver;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.resources.DependencyResource;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.InstalledPluginRegistry;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.events.ReinitializeEnvironment;
import org.jboss.forge.shell.exceptions.Abort;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.IndexPluginNameCompleter;
import org.jboss.forge.shell.plugins.builtin.InstalledPluginCompleter;
import org.jboss.forge.shell.util.ForgeProxySelector;
import org.jboss.forge.shell.util.PluginRef;
import org.jboss.forge.shell.util.PluginUtil;
import org.jboss.forge.shell.util.ProxySettings;

@Alias(value="forge")
@Topic(value="Shell Environment")
@Help(value="Forge control and writer environment commands. Manage plugins and other forge addons.")
public class ForgePlugin
implements Plugin {
    private static final String MODULE_TEMPLATE_XML = "/org/jboss/forge/modules/module-template.xml";
    private final Event<ReinitializeEnvironment> reinitializeEvent;
    private final ShellPrintWriter writer;
    private final DependencyResolver resolver;
    private final ForgeEnvironment environment;
    private final ShellPrompt prompt;
    private final Shell shell;
    private final Configuration configuration;

    @Inject
    public ForgePlugin(ForgeEnvironment environment, Event<ReinitializeEnvironment> reinitializeEvent, ShellPrintWriter writer, ShellPrompt prompt, DependencyResolver resolver, Shell shell, Configuration configuration) {
        this.environment = environment;
        this.reinitializeEvent = reinitializeEvent;
        this.writer = writer;
        this.prompt = prompt;
        this.shell = shell;
        this.resolver = resolver;
        this.configuration = configuration;
    }

    @DefaultCommand
    public void about(PipeOut out) {
        out.println("    _____                    ");
        out.println("   |  ___|__  _ __ __ _  ___ ");
        out.println("   | |_ / _ \\| `__/ _` |/ _ \\  " + out.renderColor(ShellColor.YELLOW, "\\\\"));
        out.println("   |  _| (_) | | | (_| |  __/  " + out.renderColor(ShellColor.YELLOW, "//"));
        out.println("   |_|  \\___/|_|  \\__, |\\___| ");
        out.println("                   |___/      ");
        out.println("");
        out.println("JBoss Forge, version [ " + this.environment.getRuntimeVersion() + " ] - JBoss, by Red Hat, Inc. [ http://jboss.org/forge ]");
    }

    @Command(value="restart", help="Reload all plugins and default configurations")
    public void restart() throws Exception {
        this.reinitializeEvent.fire((Object)new ReinitializeEnvironment());
    }

    @Command(value="list-plugins", help="List all installed plugin JAR files.")
    public void listInstalled(@Option(name="all", shortName="a", description="Show extra information about each installed plugin", defaultValue="false") boolean showAll) {
        DirectoryResource pluginDir = this.environment.getPluginDirectory();
        this.displayModules(pluginDir);
    }

    private void displayModules(DirectoryResource pluginDir) {
        List<InstalledPluginRegistry.PluginEntry> plugins = InstalledPluginRegistry.list();
        for (InstalledPluginRegistry.PluginEntry plugin : plugins) {
            this.writer.println(plugin.toString());
        }
    }

    @Command(value="find-plugin", help="Searches the configured Forge plugin index for a plugin matching the given search text")
    public void find(@Option(description="search string") String searchString, PipeOut out) throws Exception {
        List<PluginRef> pluginList = PluginUtil.findPlugin(this.shell, this.configuration, searchString);
        if (!pluginList.isEmpty()) {
            out.println();
        }
        for (PluginRef ref : pluginList) {
            out.println(" - " + out.renderColor(ShellColor.BOLD, ref.getName()) + " (" + ref.getArtifact() + ")");
            out.println("\tAuthor: " + ref.getAuthor());
            out.println("\tWebsite: " + ref.getWebsite());
            out.println("\tLocation: " + ref.getLocation());
            out.println("\tTags: " + ref.getTags());
            out.println("\tDescription: " + ref.getDescription());
            out.println();
        }
    }

    @Command(value="remove-plugin", help="Removes a plugin from the current Forge runtime configuration")
    public void removePlugin(@Option(completer=InstalledPluginCompleter.class, description="plugin-name", required=true, help="The fully qualified plugin name e.g: 'org.jboss.forge.plugin:version'") String pluginName, PipeOut out) throws Exception {
        InstalledPluginRegistry.PluginEntry plugin = InstalledPluginRegistry.PluginEntry.fromCoordinates(pluginName);
        if (!InstalledPluginRegistry.has(plugin)) {
            throw new RuntimeException("No such installed plugin [" + pluginName + "]");
        }
        InstalledPluginRegistry.remove(InstalledPluginRegistry.get(plugin));
        if (!InstalledPluginRegistry.has(plugin)) {
            ShellMessages.success((ShellPrintWriter)out, (String)("Successfully removed [" + pluginName + "]"));
            this.restart();
        } else {
            ShellMessages.error((ShellPrintWriter)out, (String)("Failed to remove [" + pluginName + ""));
        }
    }

    @Command(value="install-plugin", help="Installs a plugin from the configured Forge plugin index")
    public void installFromIndex(@Option(description="plugin-name", completer=IndexPluginNameCompleter.class) String pluginName, @Option(name="version", description="branch, tag, or version to build") String version, PipeOut out) throws Exception {
        List<PluginRef> plugins = PluginUtil.findPlugin(this.shell, this.configuration, pluginName);
        if (plugins.isEmpty()) {
            throw new RuntimeException("no plugin found with name [" + pluginName + "]");
        }
        if (plugins.size() > 1) {
            throw new RuntimeException("ambiguous plugin query: multiple matches for [" + pluginName + "]");
        }
        PluginRef ref = plugins.get(0);
        ShellMessages.info((ShellPrintWriter)out, (String)("Preparing to install plugin: " + ref.getName()));
        if (!ref.isGit()) {
            this.installFromMvnRepos(ref.getArtifact(), out, new DependencyRepository[]{new DependencyRepositoryImpl("custom", ref.getHomeRepo())});
        } else if (ref.isGit()) {
            this.installFromGit(ref.getGitRepo(), Strings.isNullOrEmpty((String)version) ? ref.getGitRef() : version, null, out);
        }
    }

    private void installFromMvnRepos(Dependency dep, PipeOut out, DependencyRepository ... repoList) throws Exception {
        this.installFromMvnRepos(dep, out, Arrays.asList(repoList));
    }

    private void installFromMvnRepos(Dependency dep, PipeOut out, List<DependencyRepository> repoList) throws Exception {
        List temp = this.resolver.resolveArtifacts(dep, repoList);
        ArrayList<DependencyResource> artifacts = new ArrayList<DependencyResource>();
        for (DependencyResource d : temp) {
            if (!d.exists()) continue;
            artifacts.add(d);
        }
        if (artifacts.isEmpty()) {
            throw new RuntimeException("No artifacts found for [" + dep + "]");
        }
        if (artifacts.size() > 1) {
            this.prompt.promptChoiceTyped("Install which version?", artifacts, artifacts.get(artifacts.size() - 1));
        } else {
            artifacts.get(0);
        }
        throw new IllegalStateException("Not yet implemented.");
    }

    public void installFromMvnRepos(@Option(description="plugin-identifier", required=true) Dependency dep, @Option(name="knownRepo", description="target repository") DependencyFacet.KnownRepository repo, @Option(name="repoUrl", description="target repository URL") String repoURL, PipeOut out) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    public void installFromLocalJar(@Option(name="jar", description="jar file to install", required=true) Resource<?> resource, @Option(name="id", description="plugin identifier, [e.g. \"com.example.group : example-plugin\"]", required=true) Dependency dep, PipeOut out) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    public void installFromRemoteURL(@Option(description="URL of jar file", required=true) URL url, @Option(name="id", description="plugin identifier, [e.g. \"com.example.group : example-plugin\"]", required=true) Dependency dep, PipeOut out) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Command(value="source-plugin", help="Install a plugin from a local project folder")
    public void installFromLocalProject(@Option(description="project directory", required=true) Resource<?> projectFolder, PipeOut out) throws Exception {
        DirectoryResource workspace = (DirectoryResource)projectFolder.reify(DirectoryResource.class);
        if (workspace == null || !workspace.exists()) {
            throw new IllegalArgumentException("Project folder must be specified.");
        }
        this.buildFromCurrentProject(out, workspace);
        ShellMessages.success((ShellPrintWriter)out, (String)("Installed from [" + workspace + "] successfully."));
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(value="git-plugin", help="Install a plugin from a public git repository")
    public void installFromGit(@Option(description="git repo", required=true) String gitRepo, @Option(name="ref", description="branch or tag to build") String refName, @Option(name="checkoutDir", description="directory in which to clone the repository") Resource<?> checkoutDir, PipeOut out) throws Exception {
        DirectoryResource workspace = this.shell.getCurrentDirectory().createTempResource();
        try {
            DirectoryResource buildDir = workspace.getChildDirectory("repo");
            if (checkoutDir != null) {
                if (!checkoutDir.exists() && checkoutDir instanceof FileResource) {
                    ((FileResource)checkoutDir).mkdirs();
                }
                buildDir = (DirectoryResource)checkoutDir.reify(DirectoryResource.class);
            }
            if (buildDir.exists()) {
                buildDir.delete(true);
                buildDir.mkdir();
            }
            this.prepareProxyForJGit();
            ShellMessages.info((ShellPrintWriter)out, (String)("Checking out plugin source files to [" + buildDir.getFullyQualifiedName() + "] via 'git'"));
            Git repo = GitUtils.clone((DirectoryResource)buildDir, (String)gitRepo);
            Ref ref = null;
            String targetRef = refName;
            if (targetRef == null) {
                targetRef = this.environment.getRuntimeVersion();
            }
            if (targetRef != null) {
                String branchName;
                Map tags = repo.getRepository().getTags();
                ref = (Ref)tags.get(targetRef);
                if (ref == null) {
                    List refs = GitUtils.getRemoteBranches((Git)repo);
                    for (Ref branchRef : refs) {
                        branchName = branchRef.getName();
                        if (branchName == null || !branchName.endsWith(targetRef)) continue;
                        ref = repo.branchCreate().setName(targetRef).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + targetRef).call();
                    }
                }
                if (ref == null) {
                    String version;
                    ArrayList<String> sortedVersions = new ArrayList<String>();
                    for (Ref branchRef : GitUtils.getRemoteBranches((Git)repo)) {
                        branchName = branchRef.getName();
                        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, branchName = branchName.replaceFirst("refs/heads/", ""))) continue;
                        sortedVersions.add(branchName);
                    }
                    for (String tag : tags.keySet()) {
                        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, tag)) continue;
                        sortedVersions.add(tag);
                    }
                    Collections.sort(sortedVersions);
                    if (!sortedVersions.isEmpty() && InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, version = (String)sortedVersions.get(sortedVersions.size() - 1)) && (ref = (Ref)tags.get(version)) == null) {
                        ref = repo.branchCreate().setName(version).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + version).call();
                    }
                }
            }
            if (ref == null) {
                ref = repo.getRepository().getRef("master");
            }
            if (ref != null) {
                ShellMessages.info((ShellPrintWriter)out, (String)("Switching to branch/tag [" + ref.getName() + "]"));
                GitUtils.checkout((Git)repo, (Ref)ref, (boolean)false, (CreateBranchCommand.SetupUpstreamMode)CreateBranchCommand.SetupUpstreamMode.TRACK, (boolean)false);
            } else {
                if (refName != null) {
                    throw new RuntimeException("Could not locate ref [" + targetRef + "] in repository [" + repo.getRepository().getDirectory().getAbsolutePath() + "]");
                }
                ShellMessages.warn((ShellPrintWriter)out, (String)("Could not find a Ref matching the current Forge version [" + this.environment.getRuntimeVersion() + "], building Plugin from HEAD."));
            }
            this.buildFromCurrentProject(out, buildDir);
        }
        finally {
            if (checkoutDir != null) {
                ShellMessages.info((ShellPrintWriter)out, (String)("Cleaning up temp workspace [" + workspace.getFullyQualifiedName() + "]"));
                workspace.delete(true);
            }
        }
        ShellMessages.success((ShellPrintWriter)out, (String)("Installed from [" + gitRepo + "] successfully."));
        this.restart();
    }

    private void prepareProxyForJGit() {
        ProxySettings proxySettings = ProxySettings.fromForgeConfiguration(this.configuration);
        if (proxySettings == null) {
            return;
        }
        if (!(ProxySelector.getDefault() instanceof ForgeProxySelector)) {
            ForgeProxySelector selector = new ForgeProxySelector(ProxySelector.getDefault(), proxySettings);
            ProxySelector.setDefault(selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFromCurrentProject(PipeOut out, DirectoryResource buildDir) throws Abort {
        block10: {
            DirectoryResource savedLocation = this.shell.getCurrentDirectory();
            try {
                Dependency managedDependency;
                Dependency directDependency;
                this.shell.setCurrentResource((Resource)buildDir);
                Project project = this.shell.getCurrentProject();
                if (project == null) {
                    throw new IllegalStateException("Unable to recognise plugin project in [" + buildDir.getFullyQualifiedName() + "]");
                }
                DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
                DependencyBuilder shellApi = DependencyBuilder.create((String)"org.jboss.forge:forge-shell-api");
                String apiVersion = null;
                if (!deps.hasEffectiveDependency((Dependency)shellApi) && !this.prompt.promptBoolean("The project does not appear to be a Forge Plugin Project, install anyway?", false)) {
                    throw new Abort("Installation aborted");
                }
                if (apiVersion == null && (directDependency = deps.getDirectDependency((Dependency)shellApi)) != null && !Strings.isNullOrEmpty((String)directDependency.getVersion())) {
                    apiVersion = directDependency.getVersion();
                }
                if (apiVersion == null && (managedDependency = deps.getManagedDependency((Dependency)shellApi)) != null && !Strings.isNullOrEmpty((String)managedDependency.getVersion())) {
                    apiVersion = managedDependency.getVersion();
                }
                if (apiVersion == null) {
                    Dependency effectiveDependency = deps.getEffectiveDependency((Dependency)shellApi);
                    apiVersion = effectiveDependency != null ? effectiveDependency.getVersion() : this.environment.getRuntimeVersion();
                }
                List<String> groupIds = Arrays.asList("org.jboss.seam.render", "org.jboss.forge");
                List dependencies = deps.getDependencies();
                for (Dependency dependency : dependencies) {
                    if (!groupIds.contains(dependency.getGroupId()) || ScopeType.PROVIDED.equals((Object)dependency.getScopeTypeEnum()) || ScopeType.TEST.equals((Object)dependency.getScopeTypeEnum())) continue;
                    ShellMessages.warn((ShellPrintWriter)out, (String)("Dependency [" + dependency.toCoordinates() + "] was not correctly marked as PROVIDED scope; this has been corrected."));
                    deps.addDirectDependency((Dependency)DependencyBuilder.create((Dependency)dependency).setScopeType(ScopeType.PROVIDED));
                }
                ShellMessages.info((ShellPrintWriter)out, (String)"Invoking build with underlying build system.");
                Resource artifact = ((PackagingFacet)project.getFacet(PackagingFacet.class)).createBuilder().runTests(false).build();
                if (artifact != null && artifact.exists()) {
                    MetadataFacet meta = (MetadataFacet)project.getFacet(MetadataFacet.class);
                    Dependency dep = meta.getOutputDependency();
                    ShellMessages.info((ShellPrintWriter)out, (String)"Installing plugin artifact.");
                    this.createModule(project, (Dependency)DependencyBuilder.create((Dependency)dep).setVersion(dep.getVersion() + "-" + UUID.randomUUID().toString()), artifact, apiVersion);
                    break block10;
                }
                throw new IllegalStateException("Build artifact [" + artifact.getFullyQualifiedName() + "] is missing and cannot be installed. Please resolve build errors and try again.");
            }
            finally {
                this.shell.setCurrentResource((Resource)savedLocation);
            }
        }
    }

    private boolean needDependenciesAsResourceRoot(Project project) {
        FileResource forgeXml = (FileResource)project.getProjectRoot().getChild("src/main/resources/META-INF/forge.xml");
        if (forgeXml.exists()) {
            try {
                Node node = XMLParser.parse((InputStream)forgeXml.getResourceInputStream());
                return node.getSingle("dependencies-as-resource-root") != null;
            }
            catch (ParserException e) {
                return false;
            }
        }
        return false;
    }

    private DirectoryResource createModule(Project project, Dependency dep, Resource<?> artifact, String apiVersion) {
        boolean dependenciesAsResourceRoot = this.needDependenciesAsResourceRoot(project);
        DirectoryResource moduleDir = this.getOrCreatePluginModuleDirectory(dep);
        String pluginName = dep.getGroupId() + "." + dep.getArtifactId();
        String pluginSlot = dep.getVersion();
        FileResource moduleXml = (FileResource)moduleDir.getChild("module.xml");
        if (moduleXml.exists() && !this.prompt.promptBoolean("An existing installation for version [" + pluginSlot + "] of this plugin was found. Replace it?", true)) {
            throw new RuntimeException("Aborted.");
        }
        moduleXml.delete();
        moduleXml.createNewFile();
        Node module = XMLParser.parse((InputStream)this.getClass().getResourceAsStream(MODULE_TEMPLATE_XML));
        module.attribute("name", pluginName);
        module.attribute("slot", pluginSlot);
        Node resources = module.getSingle("resources");
        resources.createChild("resource-root").attribute("path", dep.getArtifactId() + ".jar");
        if (dependenciesAsResourceRoot) {
            this.writeResourceRoots(project, module, moduleDir, resources);
        }
        FileResource jar = (FileResource)moduleDir.getChild(dep.getArtifactId() + ".jar").reify(FileResource.class);
        jar.createNewFile();
        jar.setContents(artifact.getResourceInputStream());
        Node dependencies = module.getSingle("dependencies");
        if (!dependenciesAsResourceRoot) {
            dependencies.createChild("module").attribute("name", pluginName + ".dependencies").attribute("slot", pluginSlot);
        }
        dependencies.createChild("module").attribute("name", "org.jboss.forge.javaee.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.maven.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.scaffold.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.shell.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.seam.render").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "javax.api");
        moduleXml.setContents(XMLParser.toXMLString((Node)module));
        if (!dependenciesAsResourceRoot) {
            this.createDependenciesModule(project, dep);
        }
        this.registerPlugin(pluginName, pluginSlot, apiVersion);
        return moduleDir;
    }

    private List<DependencyResource> getPluginDependencies(Project project, Node module) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        ArrayList<DependencyResource> pluginDependencies = new ArrayList<DependencyResource>();
        List effectiveDependenciesInScopes = deps.getEffectiveDependenciesInScopes(new ScopeType[]{ScopeType.COMPILE, ScopeType.RUNTIME});
        for (Dependency d : effectiveDependenciesInScopes) {
            if (d.getPackagingTypeEnum().equals((Object)PackagingType.JAR) && !d.getGroupId().equals("org.jboss.forge")) {
                List<DependencyResource> artifacts = this.resolveArtifacts(project, d);
                pluginDependencies.addAll(artifacts);
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-javaee-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.javaee.api").attribute("services", "import");
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-scaffold-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.scaffold.api").attribute("services", "import");
            }
            if (!DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-maven-api"))) continue;
            module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.maven.api").attribute("services", "import");
        }
        return pluginDependencies;
    }

    private void writeResourceRoots(Project project, Node module, DirectoryResource directory, Node resources) {
        List<DependencyResource> pluginDependencies = this.getPluginDependencies(project, module);
        for (DependencyResource d : pluginDependencies) {
            String name = d.getName();
            Resource child = directory.getChild(name);
            child.delete();
            FileResource depJar = (FileResource)child.reify(FileResource.class);
            depJar.setContents(d.getResourceInputStream());
            resources.createChild("resource-root").attribute("path", name);
        }
    }

    private void createDependenciesModule(Project project, Dependency dep) {
        DirectoryResource dependencyDir = this.getOrCreatePluginDependenciesModuleDirectory(dep);
        String pluginName = dep.getGroupId() + "." + dep.getArtifactId();
        String pluginSlot = dep.getVersion();
        FileResource moduleXml = (FileResource)dependencyDir.getChild("module.xml");
        moduleXml.delete();
        moduleXml.createNewFile();
        Node module = XMLParser.parse((InputStream)this.getClass().getResourceAsStream(MODULE_TEMPLATE_XML));
        module.attribute("name", pluginName + ".dependencies");
        module.attribute("slot", pluginSlot);
        Node resources = module.getSingle("resources");
        Node dependencies = module.getSingle("dependencies");
        dependencies.createChild("module").attribute("name", "javax.api");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.shell.api");
        this.writeResourceRoots(project, module, dependencyDir, resources);
        moduleXml.setContents(XMLParser.toXMLString((Node)module));
    }

    private List<DependencyResource> resolveArtifacts(Project project, Dependency dep) {
        Dependency d = dep;
        List<Object> artifacts = new ArrayList<DependencyResource>();
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        for (Dependency d2 : deps.getDependencies()) {
            if (!DependencyBuilder.areEquivalent((Dependency)d, (Dependency)d2) || d2.getVersion() == null) continue;
            d = d2;
            break;
        }
        if (artifacts.size() != 1) {
            artifacts = this.resolver.resolveArtifacts(d, deps.getRepositories());
        }
        if (artifacts.size() != 1) {
            ShellMessages.warn((ShellPrintWriter)this.writer, (String)("Could not resolve dependency [" + d.toCoordinates() + "]"));
        }
        return artifacts;
    }

    public void registerPlugin(String pluginName, String pluginSlot, String apiVersion) {
        InstalledPluginRegistry.install(pluginName, apiVersion, pluginSlot);
    }

    public DirectoryResource getOrCreatePluginModuleDirectory(Dependency dep) {
        DirectoryResource pluginDir = this.environment.getPluginDirectory();
        List<String> groupId = Arrays.asList(dep.getGroupId().split("\\."));
        List<String> artifactId = Arrays.asList(dep.getArtifactId().split("\\."));
        DirectoryResource dir = pluginDir;
        for (String segment : groupId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        for (String segment : artifactId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        dir = dir.getOrCreateChildDirectory(dep.getVersion());
        return dir;
    }

    public DirectoryResource getOrCreatePluginDependenciesModuleDirectory(Dependency dep) {
        DirectoryResource pluginDir = this.environment.getPluginDirectory();
        List<String> groupId = Arrays.asList(dep.getGroupId().split("\\."));
        List<String> artifactId = Arrays.asList(dep.getArtifactId().split("\\."));
        DirectoryResource dir = pluginDir;
        for (String segment : groupId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        for (String segment : artifactId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        dir = dir.getOrCreateChildDirectory("dependencies");
        dir = dir.getOrCreateChildDirectory(dep.getVersion());
        return dir;
    }
}

