/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.hibernate.ui.diagram.UiPlugin;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ResourceManager;
import org.jboss.tools.hibernate.ui.view.ImageBundle;

public class TitleLabel
extends Label {
    static Image shevronUp = UiPlugin.getImageDescriptor2(ImageBundle.getString("VisualMapping.shevronUp")).createImage();
    static Image shevronDown = UiPlugin.getImageDescriptor2(ImageBundle.getString("VisualMapping.shevronDown")).createImage();
    protected boolean expanded = true;

    public TitleLabel(float fontHeight) {
        Font font;
        if (Display.getCurrent() != null && (font = Display.getCurrent().getSystemFont()) != null) {
            FontData[] fontData = font.getFontData();
            fontData[0].height = fontHeight;
            this.setFont(ResourceManager.getInstance().getFont(fontData[0]));
        }
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        Dimension p = super.calculateLabelSize(txtSize).getCopy();
        p.width += 40;
        return p;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.expanded) {
            graphics.drawImage(shevronUp, this.getBounds().x + this.getBounds().width - 20, this.getBounds().y);
        } else {
            graphics.drawImage(shevronDown, this.getBounds().x + this.getBounds().width - 20, this.getBounds().y);
        }
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
        }
        this.repaint();
    }
}

